/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBAnnotation;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMapping;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.util.collection.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TypeMappingFactory {
    BOOLEAN_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMBoolean(mappingStrategy, feature, type);
        }
    }
    ,
    BYTE_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMByte(mappingStrategy, feature, type);
        }
    }
    ,
    CHARACTER_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMCharacter(mappingStrategy, feature, type);
        }
    }
    ,
    DATE2TIMESTAMP_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMDate2Timestamp(mappingStrategy, feature, type);
        }
    }
    ,
    DATE2DATE_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMDate2Date(mappingStrategy, feature, type);
        }
    }
    ,
    DATE2TIME_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMDate2Time(mappingStrategy, feature, type);
        }
    }
    ,
    DOUBLE_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMDouble(mappingStrategy, feature, type);
        }
    }
    ,
    FLOAT_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMFloat(mappingStrategy, feature, type);
        }
    }
    ,
    INT_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMInteger(mappingStrategy, feature, type);
        }
    }
    ,
    LONG_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMLong(mappingStrategy, feature, type);
        }
    }
    ,
    OBJECT_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMObject(mappingStrategy, feature, type);
        }
    }
    ,
    SHORT_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMShort(mappingStrategy, feature, type);
        }
    }
    ,
    ENUM_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMEnum(mappingStrategy, feature, type);
        }
    }
    ,
    STRING_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMString(mappingStrategy, feature, type);
        }
    }
    ,
    BIG_INT_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMBigInteger(mappingStrategy, feature, type);
        }
    }
    ,
    BIG_DECIMAL_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMBigDecimal(mappingStrategy, feature, type);
        }
    }
    ,
    BYTES_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMBytes(mappingStrategy, feature, type);
        }
    }
    ,
    CUSTOM_MAPPING{

        public ITypeMapping doCreateTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature, DBType type) {
            return new TypeMapping.TMCustom(mappingStrategy, feature, type);
        }
    };

    private static Map<EClassifier, DBType> defaultTypeMap;
    private static Map<Pair<CDOType, DBType>, TypeMappingFactory> mappingTable;
    private static Set<DBType> defaultFeatureMapDBTypes;

    static {
        defaultTypeMap = new HashMap<EClassifier, DBType>();
        mappingTable = new HashMap<Pair<CDOType, DBType>, TypeMappingFactory>();
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDate(), DBType.TIMESTAMP);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEString(), DBType.VARCHAR);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByteArray(), DBType.BLOB);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEBoolean(), DBType.BOOLEAN);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByte(), DBType.SMALLINT);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEChar(), DBType.CHAR);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDouble(), DBType.DOUBLE);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEFloat(), DBType.FLOAT);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEInt(), DBType.INTEGER);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getELong(), DBType.BIGINT);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEShort(), DBType.SMALLINT);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject(), DBType.BOOLEAN);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEByteObject(), DBType.SMALLINT);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getECharacterObject(), DBType.CHAR);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject(), DBType.DOUBLE);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEFloatObject(), DBType.FLOAT);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject(), DBType.INTEGER);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getELongObject(), DBType.BIGINT);
        defaultTypeMap.put((EClassifier)EcorePackage.eINSTANCE.getEShortObject(), DBType.SMALLINT);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.BIG_INTEGER, (Object)DBType.VARCHAR), BIG_INT_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.BIG_DECIMAL, (Object)DBType.VARCHAR), BIG_DECIMAL_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.BOOLEAN, (Object)DBType.BOOLEAN), BOOLEAN_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.BOOLEAN_OBJECT, (Object)DBType.BOOLEAN), BOOLEAN_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.BYTE, (Object)DBType.SMALLINT), BYTE_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.BYTE_OBJECT, (Object)DBType.SMALLINT), BYTE_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.BYTE_ARRAY, (Object)DBType.BLOB), BYTES_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.CHAR, (Object)DBType.CHAR), CHARACTER_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.CHARACTER_OBJECT, (Object)DBType.CHAR), CHARACTER_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.DATE, (Object)DBType.TIMESTAMP), DATE2TIMESTAMP_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.DATE, (Object)DBType.DATE), DATE2DATE_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.DATE, (Object)DBType.TIME), DATE2TIME_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.DOUBLE, (Object)DBType.DOUBLE), DOUBLE_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.DOUBLE_OBJECT, (Object)DBType.DOUBLE), DOUBLE_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.ENUM_ORDINAL, (Object)DBType.INTEGER), ENUM_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.FLOAT, (Object)DBType.FLOAT), FLOAT_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.FLOAT_OBJECT, (Object)DBType.FLOAT), FLOAT_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.INT, (Object)DBType.INTEGER), INT_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.INTEGER_OBJECT, (Object)DBType.INTEGER), INT_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.LONG, (Object)DBType.BIGINT), LONG_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.LONG_OBJECT, (Object)DBType.BIGINT), LONG_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.OBJECT, (Object)DBType.BIGINT), OBJECT_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.SHORT, (Object)DBType.SMALLINT), SHORT_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.SHORT_OBJECT, (Object)DBType.SMALLINT), SHORT_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.STRING, (Object)DBType.VARCHAR), STRING_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.STRING, (Object)DBType.CLOB), STRING_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.CUSTOM, (Object)DBType.VARCHAR), CUSTOM_MAPPING);
        mappingTable.put((Pair<CDOType, DBType>)new Pair((Object)CDOType.CUSTOM, (Object)DBType.CLOB), CUSTOM_MAPPING);
        defaultFeatureMapDBTypes = new HashSet<DBType>(defaultTypeMap.values());
    }

    private TypeMappingFactory() {
    }

    protected abstract ITypeMapping doCreateTypeMapping(IMappingStrategy var1, EStructuralFeature var2, DBType var3);

    public static ITypeMapping createTypeMapping(IMappingStrategy mappingStrategy, EStructuralFeature feature) {
        DBType dbType;
        CDOType cdoType = CDOModelUtil.getType((EStructuralFeature)feature);
        TypeMappingFactory concreteFactory = mappingTable.get(new Pair((Object)cdoType, (Object)(dbType = TypeMappingFactory.getDBType(feature, mappingStrategy.getStore().getDBAdapter()))));
        if (concreteFactory == null) {
            throw new IllegalArgumentException("No suitable mapping found from EMF type " + cdoType.getName() + " to DB type " + dbType.getClass().getSimpleName());
        }
        return concreteFactory.doCreateTypeMapping(mappingStrategy, feature, dbType);
    }

    private static DBType getDBType(EStructuralFeature feature, IDBAdapter dbAdapter) {
        String typeKeyword = DBAnnotation.COLUMN_TYPE.getValue((EModelElement)feature);
        if (typeKeyword != null) {
            DBType dbType = DBType.getTypeByKeyword((String)typeKeyword);
            if (dbType == null) {
                throw new IllegalArgumentException("Unsupported columnType (" + typeKeyword + ") annotation of feature " + feature.getName());
            }
            return dbType;
        }
        return TypeMappingFactory.getDefaultDBType(feature.getEType(), dbAdapter);
    }

    private static DBType getDefaultDBType(EClassifier type, IDBAdapter dbAdapter) {
        DBType dbType;
        DBType result = DBType.VARCHAR;
        if (type instanceof EClass) {
            result = DBType.BIGINT;
        }
        if (type instanceof EEnum) {
            result = DBType.INTEGER;
        }
        if ((dbType = defaultTypeMap.get(type)) != null) {
            result = dbType;
        }
        return dbAdapter.adaptType(result);
    }

    public static Collection<DBType> getDefaultFeatureMapDBTypes() {
        return defaultFeatureMapDBTypes;
    }

    /* synthetic */ TypeMappingFactory(String string, int n, TypeMappingFactory typeMappingFactory) {
        this();
    }
}

