/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMappingFactory;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BasicAbstractListTableMapping;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureMapTableMapping
extends BasicAbstractListTableMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractFeatureMapTableMapping.class);
    private IDBTable table;
    private HashMap<Long, String> tagMap;
    private List<String> columnNames;
    private Map<Long, ITypeMapping> typeMappings;
    private String sqlSelectChunksPrefix;
    private String sqlOrderByIndex;
    protected String sqlInsert;
    private String sqlGetListLastIndex;
    private List<DBType> dbTypes;

    public AbstractFeatureMapTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initDBTypes();
        this.initTable();
        this.initSQLStrings();
    }

    private void initDBTypes() {
        this.dbTypes = new ArrayList<DBType>(TypeMappingFactory.getDefaultFeatureMapDBTypes());
    }

    private void initTable() {
        String tableName = this.getMappingStrategy().getTableName(this.getContainingClass(), this.getFeature());
        this.table = this.getMappingStrategy().getStore().getDBSchema().addTable(tableName);
        FieldInfo[] fields = this.getKeyFields();
        IDBField[] dbFields = new IDBField[fields.length];
        int i = 0;
        while (i < fields.length) {
            dbFields[i] = this.table.addField(fields[i].getName(), fields[i].getDbType());
            ++i;
        }
        IDBField idxField = this.table.addField("cdo_idx", DBType.INTEGER);
        IDBField tagField = this.table.addField("cdo_tag", DBType.INTEGER);
        this.tagMap = new HashMap();
        this.typeMappings = new HashMap<Long, ITypeMapping>();
        this.columnNames = new ArrayList<String>();
        for (DBType type : this.getDBTypes()) {
            String column = "cdo_value_" + type.name();
            this.table.addField(column, type);
            this.columnNames.add(column);
        }
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, dbFields);
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{idxField});
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{tagField});
    }

    protected abstract FieldInfo[] getKeyFields();

    protected abstract void setKeyFields(PreparedStatement var1, CDORevision var2) throws SQLException;

    @Override
    public Collection<IDBTable> getDBTables() {
        return Arrays.asList(this.table);
    }

    private void initSQLStrings() {
        String tableName = this.getTable().getName();
        FieldInfo[] fields = this.getKeyFields();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_tag");
        builder.append(", ");
        Iterator<String> iter = this.columnNames.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        int i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            if (i + 1 < fields.length) {
                builder.append("=? AND ");
            } else {
                builder.append("=? ");
            }
            ++i;
        }
        this.sqlSelectChunksPrefix = builder.toString();
        this.sqlOrderByIndex = " ORDER BY cdo_idx";
        builder = new StringBuilder("SELECT max(");
        builder.append("cdo_idx");
        builder.append(") FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            if (i + 1 < fields.length) {
                builder.append("=? AND ");
            } else {
                builder.append("=? ");
            }
            ++i;
        }
        this.sqlGetListLastIndex = builder.toString();
        builder = new StringBuilder("INSERT INTO ");
        builder.append(tableName);
        builder.append(" (");
        i = 0;
        while (i < fields.length) {
            builder.append(fields[i].getName());
            builder.append(", ");
            ++i;
        }
        i = 0;
        while (i < this.columnNames.size()) {
            builder.append(this.columnNames.get(i));
            builder.append(", ");
            ++i;
        }
        builder.append("cdo_idx");
        builder.append(", ");
        builder.append("cdo_tag");
        builder.append(") VALUES (");
        i = 0;
        while (i < fields.length + this.columnNames.size()) {
            builder.append("?, ");
            ++i;
        }
        builder.append("?, ?)");
        this.sqlInsert = builder.toString();
    }

    protected List<DBType> getDBTypes() {
        return this.dbTypes;
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final List<String> getColumnNames() {
        return this.columnNames;
    }

    protected final Map<Long, ITypeMapping> getTypeMappings() {
        return this.typeMappings;
    }

    protected final Map<Long, String> getTagMap() {
        return this.tagMap;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        CDOList list = revision.getList(this.getFeature());
        int listSize = -1;
        if (listChunk != -1) {
            listSize = this.getListLastIndex(accessor, revision);
            if (listSize == -1) {
                return;
            }
            listSize -= listChunk;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            try {
                String sql = String.valueOf(this.sqlSelectChunksPrefix) + this.sqlOrderByIndex;
                pstmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.HIGH);
                this.setKeyFields(pstmt, (CDORevision)revision);
                if (listChunk != -1) {
                    pstmt.setMaxRows(listChunk);
                }
                resultSet = pstmt.executeQuery();
                while ((listChunk == -1 || --listChunk >= 0) && resultSet.next()) {
                    Long tag = resultSet.getLong(1);
                    Object value = this.getTypeMapping(tag).readValue(resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{list.size(), value});
                    }
                    list.add((Object)CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value));
                }
                while (listSize-- >= 0) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Adding UNINITIALIZED for index {0} ", new Object[]{list.size()});
                    }
                    list.add(InternalCDOList.UNINITIALIZED);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(pstmt);
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
    }

    private void addFeature(Long tag) {
        EStructuralFeature modelFeature = this.getFeatureByTag(tag);
        TypeMapping typeMapping = (TypeMapping)this.getMappingStrategy().createValueMapping(modelFeature);
        String column = "cdo_value_" + typeMapping.getDBType();
        this.tagMap.put(tag, column);
        typeMapping.setDBField(this.table, column);
        this.typeMappings.put(tag, typeMapping);
    }

    private int getListLastIndex(IDBStoreAccessor accessor, InternalCDORevision revision) {
        int n;
        ResultSet resultSet;
        PreparedStatement pstmt;
        IPreparedStatementCache statementCache;
        block6: {
            block7: {
                statementCache = accessor.getStatementCache();
                pstmt = null;
                resultSet = null;
                pstmt = statementCache.getPreparedStatement(this.sqlGetListLastIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                this.setKeyFields(pstmt, (CDORevision)revision);
                resultSet = pstmt.executeQuery();
                if (resultSet.next()) break block6;
                if (!TRACER.isEnabled()) break block7;
                TRACER.trace("No last index found -> list is empty. ");
            }
            DBUtil.close((ResultSet)resultSet);
            statementCache.releasePreparedStatement(pstmt);
            return -1;
        }
        try {
            int result = resultSet.getInt(1);
            if (TRACER.isEnabled()) {
                TRACER.trace("Read list last index = " + result);
            }
            n = result;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                statementCache.releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(pstmt);
        return n;
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
        }
        IPreparedStatementCache statementCache = chunkReader.getAccessor().getStatementCache();
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            try {
                StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
                if (where != null) {
                    builder.append(" AND ");
                    builder.append(where);
                }
                builder.append(this.sqlOrderByIndex);
                String sql = builder.toString();
                pstmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.LOW);
                this.setKeyFields(pstmt, chunkReader.getRevision());
                resultSet = pstmt.executeQuery();
                IStoreChunkReader.Chunk chunk = null;
                int chunkSize = 0;
                int chunkIndex = 0;
                int indexInChunk = 0;
                while (resultSet.next()) {
                    Long tag = resultSet.getLong(1);
                    Object value = this.getTypeMapping(tag).readValue(resultSet);
                    if (chunk == null) {
                        chunk = chunks.get(chunkIndex++);
                        chunkSize = chunk.size();
                        if (TRACER.isEnabled()) {
                            TRACER.format("Current chunk no. {0} is [start = {1}, size = {2}]", new Object[]{chunkIndex - 1, chunk.getStartIndex(), chunkSize});
                        }
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for chunk index {0} from result set: {1}", new Object[]{indexInChunk, value});
                    }
                    chunk.add(indexInChunk++, (Object)CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value));
                    if (indexInChunk != chunkSize) continue;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Chunk finished", new Object[0]);
                    }
                    chunk = null;
                    indexInChunk = 0;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Reading list chunk values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getTagByFeature(this.getFeature()), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(pstmt);
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getList(this.getFeature());
        int idx = 0;
        for (Object element : values) {
            this.writeValue(accessor, (CDORevision)revision, idx++, element);
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int idx, Object value) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3}v{4} : {5}", new Object[]{this.getContainingClass().getName(), this.getTagByFeature(this.getFeature()), idx, revision.getID(), revision.getVersion(), value});
        }
        try {
            try {
                FeatureMap.Entry entry = (FeatureMap.Entry)value;
                EStructuralFeature entryFeature = entry.getEStructuralFeature();
                Long tag = this.getTagByFeature(entryFeature);
                String column = this.getColumnName(tag);
                String sql = this.sqlInsert;
                stmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.HIGH);
                this.setKeyFields(stmt, revision);
                int stmtIndex = this.getKeyFields().length + 1;
                int i = 0;
                while (i < this.columnNames.size()) {
                    if (this.columnNames.get(i).equals(column)) {
                        this.getTypeMapping(tag).setValue(stmt, stmtIndex++, entry.getValue());
                    } else {
                        stmt.setNull(stmtIndex++, this.getDBTypes().get(i).getCode());
                    }
                    ++i;
                }
                stmt.setInt(stmtIndex++, idx);
                stmt.setLong(stmtIndex++, tag);
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    protected String getColumnName(Long tag) {
        String column = this.tagMap.get(tag);
        if (column == null) {
            this.addFeature(tag);
            column = this.tagMap.get(tag);
        }
        return column;
    }

    protected ITypeMapping getTypeMapping(Long tag) {
        ITypeMapping typeMapping = this.typeMappings.get(tag);
        if (typeMapping == null) {
            this.addFeature(tag);
            typeMapping = this.typeMappings.get(tag);
        }
        return typeMapping;
    }

    private EStructuralFeature getFeatureByTag(Long tag) {
        return (EStructuralFeature)this.getMappingStrategy().getStore().getMetaDataManager().getMetaInstance(tag);
    }

    protected Long getTagByFeature(EStructuralFeature feature) {
        return this.getMappingStrategy().getStore().getMetaDataManager().getMetaID((EModelElement)feature);
    }

    protected static class FieldInfo {
        private String name;
        private DBType dbType;

        public FieldInfo(String name, DBType dbType) {
            this.name = name;
            this.dbType = dbType;
        }

        public String getName() {
            return this.name;
        }

        public DBType getDbType() {
            return this.dbType;
        }
    }
}

