/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IExternalReferenceManager;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHorizontalClassMapping
implements IClassMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractHorizontalClassMapping.class);
    private EClass eClass;
    private IDBTable table;
    private AbstractHorizontalMappingStrategy mappingStrategy;
    private List<ITypeMapping> valueMappings;
    private List<IListMapping> listMappings;
    private Map<EStructuralFeature, String> unsettableFields;
    private String sqlSelectForHandle;
    private String sqlSelectForChangeSet;

    public AbstractHorizontalClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        this.mappingStrategy = mappingStrategy;
        this.eClass = eClass;
        this.initTable();
        this.initFeatures();
        this.initSQLStrings();
    }

    private void initTable() {
        String name = this.getMappingStrategy().getTableName((ENamedElement)this.eClass);
        this.table = this.getMappingStrategy().getStore().getDBSchema().addTable(name);
        IDBField idField = this.table.addField("cdo_id", DBType.BIGINT, true);
        IDBField versionField = this.table.addField("cdo_version", DBType.INTEGER, true);
        IDBField branchField = this.addBranchingField(this.table);
        this.table.addField("cdo_class", DBType.BIGINT, true);
        this.table.addField("cdo_created", DBType.BIGINT, true);
        IDBField revisedField = this.table.addField("cdo_revised", DBType.BIGINT, true);
        this.table.addField("cdo_resource", DBType.BIGINT, true);
        this.table.addField("cdo_container", DBType.BIGINT, true);
        this.table.addField("cdo_feature", DBType.INTEGER, true);
        if (branchField != null) {
            this.table.addIndex(IDBIndex.Type.UNIQUE, new IDBField[]{idField, versionField, branchField});
        } else {
            this.table.addIndex(IDBIndex.Type.UNIQUE, new IDBField[]{idField, versionField});
        }
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{idField, revisedField});
    }

    protected IDBField addBranchingField(IDBTable table) {
        return null;
    }

    private void initFeatures() {
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures((EClass)this.eClass);
        if (features == null) {
            this.valueMappings = Collections.emptyList();
            this.listMappings = Collections.emptyList();
        } else {
            this.valueMappings = this.createValueMappings(features);
            this.listMappings = this.createListMappings(features);
        }
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append("cdo_id");
        builder.append(", ");
        builder.append("cdo_version");
        builder.append(" FROM ");
        builder.append(this.getTable());
        this.sqlSelectForHandle = builder.toString();
        builder = new StringBuilder("SELECT DISTINCT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        this.sqlSelectForChangeSet = builder.toString();
    }

    private List<ITypeMapping> createValueMappings(EStructuralFeature[] features) {
        ArrayList<ITypeMapping> mappings = new ArrayList<ITypeMapping>();
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (!feature.isMany()) {
                ITypeMapping mapping = this.mappingStrategy.createValueMapping(feature);
                mapping.createDBField(this.getTable());
                mappings.add(mapping);
                if (feature.isUnsettable()) {
                    String fieldName = this.mappingStrategy.getUnsettableFieldName(feature);
                    if (this.unsettableFields == null) {
                        this.unsettableFields = new LinkedHashMap<EStructuralFeature, String>();
                    }
                    this.unsettableFields.put(feature, fieldName);
                }
            }
            ++n2;
        }
        if (this.unsettableFields != null) {
            for (String fieldName : this.unsettableFields.values()) {
                this.table.addField(fieldName, DBType.BOOLEAN, 1);
            }
        }
        return mappings;
    }

    private List<IListMapping> createListMappings(EStructuralFeature[] features) {
        ArrayList<IListMapping> listMappings = new ArrayList<IListMapping>();
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany()) {
                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                    listMappings.add(this.mappingStrategy.createFeatureMapMapping(this.eClass, feature));
                } else {
                    listMappings.add(this.mappingStrategy.createListMapping(this.eClass, feature));
                }
            }
            ++n2;
        }
        return listMappings;
    }

    protected final boolean readValuesFromStatement(PreparedStatement pstmt, InternalCDORevision revision, IDBStoreAccessor accessor) {
        ResultSet resultSet;
        block8: {
            block9: {
                resultSet = null;
                if (TRACER.isEnabled()) {
                    TRACER.format("Executing Query: {0}", new Object[]{pstmt.toString()});
                }
                pstmt.setMaxRows(1);
                resultSet = pstmt.executeQuery();
                if (resultSet.next()) break block8;
                if (!TRACER.isEnabled()) break block9;
                TRACER.format("Resultset was empty", new Object[0]);
            }
            DBUtil.close((ResultSet)resultSet);
            return false;
        }
        try {
            revision.setVersion(resultSet.getInt("cdo_version"));
            long timeStamp = resultSet.getLong("cdo_created");
            CDOBranchPoint branchPoint = revision.getBranch().getPoint(timeStamp);
            revision.setBranchPoint(branchPoint);
            revision.setRevised(resultSet.getLong("cdo_revised"));
            revision.setResourceID(CDODBUtil.convertLongToCDOID(this.getExternalReferenceManager(), accessor, resultSet.getLong("cdo_resource")));
            revision.setContainerID((Object)CDODBUtil.convertLongToCDOID(this.getExternalReferenceManager(), accessor, resultSet.getLong("cdo_container")));
            revision.setContainingFeatureID(resultSet.getInt("cdo_feature"));
            for (ITypeMapping mapping : this.valueMappings) {
                EStructuralFeature feature = mapping.getFeature();
                if (feature.isUnsettable() && !resultSet.getBoolean(this.unsettableFields.get(feature))) {
                    revision.setValue(feature, null);
                    continue;
                }
                mapping.readValueToRevision(resultSet, revision);
            }
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        return true;
    }

    protected final void readLists(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        for (IListMapping listMapping : this.listMappings) {
            listMapping.readValues(accessor, revision, listChunk);
        }
    }

    protected final IMetaDataManager getMetaDataManager() {
        return this.getMappingStrategy().getStore().getMetaDataManager();
    }

    protected final IExternalReferenceManager getExternalReferenceManager() {
        return this.mappingStrategy.getStore().getExternalReferenceManager();
    }

    protected final IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    @Override
    public final EClass getEClass() {
        return this.eClass;
    }

    protected final Map<EStructuralFeature, String> getUnsettableFields() {
        return this.unsettableFields;
    }

    public final List<ITypeMapping> getValueMappings() {
        return this.valueMappings;
    }

    public final ITypeMapping getValueMapping(EStructuralFeature feature) {
        for (ITypeMapping mapping : this.valueMappings) {
            if (mapping.getFeature() != feature) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public final List<IListMapping> getListMappings() {
        return this.listMappings;
    }

    @Override
    public final IListMapping getListMapping(EStructuralFeature feature) {
        for (IListMapping mapping : this.listMappings) {
            if (mapping.getFeature() != feature) continue;
            return mapping;
        }
        throw new IllegalArgumentException("List mapping for feature " + feature + " does not exist");
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    @Override
    public List<IDBTable> getDBTables() {
        ArrayList<IDBTable> tables = new ArrayList<IDBTable>();
        tables.add(this.table);
        for (IListMapping listMapping : this.listMappings) {
            tables.addAll(listMapping.getDBTables());
        }
        return tables;
    }

    protected void checkDuplicateResources(IDBStoreAccessor accessor, CDORevision revision) throws IllegalStateException {
        String name;
        CDOID folderID = (CDOID)revision.data().getContainerID();
        CDOID existingID = accessor.readResourceID(folderID, name = (String)revision.data().get((EStructuralFeature)EresourcePackage.eINSTANCE.getCDOResourceNode_Name(), 0), revision.getBranch().getHead());
        if (existingID != null && !existingID.equals(revision.getID())) {
            throw new IllegalStateException("Duplicate resource or folder: " + name + " in folder " + folderID);
        }
    }

    protected void writeLists(IDBStoreAccessor accessor, InternalCDORevision revision) {
        for (IListMapping listMapping : this.listMappings) {
            listMapping.writeValues(accessor, revision);
        }
    }

    @Override
    public void writeRevision(IDBStoreAccessor accessor, InternalCDORevision revision, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin(10.0);
        try {
            try {
                async = monitor.forkAsync();
                CDOID id = revision.getID();
                if (revision.getVersion() == 1) {
                    long timeStamp = revision.getTimeStamp();
                    this.mappingStrategy.putObjectType(accessor, timeStamp, id, this.eClass);
                } else {
                    long revised = revision.getTimeStamp() - 1L;
                    this.reviseOldRevision(accessor, id, revision.getBranch(), revised);
                    for (IListMapping mapping : this.getListMappings()) {
                        mapping.objectDetached(accessor, id, revised);
                    }
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                async = monitor.forkAsync();
                if (revision.isResourceFolder() || revision.isResource()) {
                    this.checkDuplicateResources(accessor, (CDORevision)revision);
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                async = monitor.forkAsync();
                this.writeValues(accessor, revision);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                if (this.listMappings != null) {
                    async = monitor.forkAsync(7.0);
                    this.writeLists(accessor, revision);
                } else {
                    monitor.worked(7.0);
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void handleRevisions(IDBStoreAccessor accessor, CDOBranch branch, long timeStamp, CDORevisionHandler handler) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        IRepository repository = accessor.getStore().getRepository();
        CDORevisionManager revisionManager = repository.getRevisionManager();
        CDOBranchManager branchManager = repository.getBranchManager();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuilder builder = new StringBuilder(this.sqlSelectForHandle);
        if (timeStamp != 0L) {
            builder.append(" WHERE ");
            builder.append("cdo_created");
            builder.append("=? ");
        }
        try {
            try {
                stmt = statementCache.getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.LOW);
                if (timeStamp != 0L) {
                    stmt.setLong(1, timeStamp);
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long id = rs.getLong(1);
                    int version = rs.getInt(2);
                    if (version < 1) continue;
                    InternalCDORevision revision = (InternalCDORevision)revisionManager.getRevisionByVersion(CDOIDUtil.createLong((long)id), branchManager.getMainBranch().getVersion(version), -1, true);
                    handler.handleRevision((CDORevision)revision);
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs);
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs);
        statementCache.releasePreparedStatement(stmt);
    }

    @Override
    public Set<CDOID> readChangeSet(IDBStoreAccessor accessor, CDOChangeSetSegment[] segments) {
        HashSet<CDOID> hashSet;
        StringBuilder builder = new StringBuilder(this.sqlSelectForChangeSet);
        boolean isFirst = true;
        int i = 0;
        while (i < segments.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(" OR ");
            }
            builder.append("cdo_created");
            builder.append(">=?");
            builder.append(" AND (");
            builder.append("cdo_revised");
            builder.append("<=? OR ");
            builder.append("cdo_revised");
            builder.append("=");
            builder.append(0L);
            builder.append(")");
            ++i;
        }
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashSet<CDOID> result = new HashSet<CDOID>();
        try {
            stmt = statementCache.getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.LOW);
            int col = 1;
            CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
                stmt.setLong(col++, segment.getTimeStamp());
                stmt.setLong(col++, segment.getEndTime());
                ++n2;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                long id = rs.getLong(1);
                result.add(CDOIDUtil.createLong((long)id));
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs);
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)rs);
        statementCache.releasePreparedStatement(stmt);
        return hashSet;
    }

    @Override
    public void detachObject(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin((double)(1 + this.listMappings.size()));
        try {
            if (version >= 1) {
                this.reviseOldRevision(accessor, id, branch, timeStamp - 1L);
            }
            this.detachAttributes(accessor, id, version + 1, branch, timeStamp, monitor.fork());
            for (IListMapping mapping : this.getListMappings()) {
                try {
                    async = monitor.forkAsync();
                    mapping.objectDetached(accessor, id, timeStamp);
                }
                finally {
                    if (async != null) {
                        async.stop();
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract void detachAttributes(IDBStoreAccessor var1, CDOID var2, int var3, CDOBranch var4, long var5, OMMonitor var7);

    protected abstract void reviseOldRevision(IDBStoreAccessor var1, CDOID var2, CDOBranch var3, long var4);

    protected abstract void writeValues(IDBStoreAccessor var1, InternalCDORevision var2);
}

