/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IObjectTypeCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.AbstractMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.ObjectTypeCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHorizontalMappingStrategy
extends AbstractMappingStrategy {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractHorizontalMappingStrategy.class);
    private IObjectTypeCache objectTypeCache;

    @Override
    public CDOClassifierRef readObjectType(IDBStoreAccessor accessor, CDOID id) {
        return this.objectTypeCache.getObjectType(accessor, id);
    }

    public void putObjectType(IDBStoreAccessor accessor, long timeStamp, CDOID id, EClass type) {
        this.objectTypeCache.putObjectType(accessor, timeStamp, id, type);
    }

    @Override
    public long[] repairAfterCrash(IDBAdapter dbAdapter, Connection connection) {
        long minLocalID = this.getMinLocalID(connection);
        long maxID = this.objectTypeCache.getMaxID(connection);
        long[] result = new long[]{minLocalID, maxID};
        return result;
    }

    @Override
    public void queryResources(IDBStoreAccessor accessor, IStoreAccessor.QueryResourcesContext context) {
        if (context.getTimeStamp() != 0L && !this.hasAuditSupport()) {
            throw new UnsupportedOperationException("Mapping Strategy does not support audits");
        }
        EresourcePackage resourcesPackage = EresourcePackage.eINSTANCE;
        boolean shallContinue = this.queryResources(accessor, this.getClassMapping(resourcesPackage.getCDOResourceFolder()), context);
        if (shallContinue) {
            this.queryResources(accessor, this.getClassMapping(resourcesPackage.getCDOResource()), context);
        }
    }

    @Override
    public void queryXRefs(IDBStoreAccessor accessor, IStoreAccessor.QueryXRefsContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rawExport(IDBStoreAccessor accessor, CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(" WHERE a_t.");
        builder.append("cdo_created");
        builder.append(" BETWEEN ");
        builder.append(fromCommitTime);
        builder.append(" AND ");
        builder.append(toCommitTime);
        String attrSuffix = builder.toString();
        Connection connection = accessor.getConnection();
        for (IClassMapping classMapping : this.getClassMappings(true).values()) {
            out.writeBoolean(true);
            EClass eClass = classMapping.getEClass();
            out.writeCDOClassifierRef((EClassifier)eClass);
            IDBTable table = classMapping.getDBTables().get(0);
            DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)table, (String)"a_t", (String)attrSuffix);
            for (IListMapping listMapping : classMapping.getListMappings()) {
                this.rawExportList(out, connection, listMapping, table, attrSuffix);
            }
        }
        out.writeBoolean(false);
        this.objectTypeCache.rawExport(connection, out, fromCommitTime, toCommitTime);
    }

    protected void rawExportList(CDODataOutput out, Connection connection, IListMapping listMapping, IDBTable attrTable, String attrSuffix) throws IOException {
        for (IDBTable table : listMapping.getDBTables()) {
            String listSuffix = ", " + attrTable + " a_t" + attrSuffix;
            String listJoin = this.getListJoin("a_t", "l_t");
            if (listJoin != null) {
                listSuffix = String.valueOf(listSuffix) + listJoin;
            }
            DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)table, (String)"l_t", (String)listSuffix);
        }
    }

    @Override
    public void rawImport(IDBStoreAccessor accessor, CDODataInput in) throws IOException {
        Connection connection = accessor.getConnection();
        while (in.readBoolean()) {
            EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
            IClassMapping classMapping = this.getClassMapping(eClass);
            IDBTable table = classMapping.getDBTables().get(0);
            DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)table);
            this.rawImportReviseOldRevisions(connection, table);
            for (IListMapping listMapping : classMapping.getListMappings()) {
                this.rawImportList(in, connection, listMapping);
            }
        }
        this.objectTypeCache.rawImport(connection, in);
    }

    protected void rawImportReviseOldRevisions(Connection connection, IDBTable table) {
        throw new UnsupportedOperationException("Must be overridden");
    }

    protected void rawImportList(CDODataInput in, Connection connection, IListMapping listMapping) throws IOException {
        for (IDBTable table : listMapping.getDBTables()) {
            DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)table);
        }
    }

    protected String getListJoin(String attrTable, String listTable) {
        return " AND " + attrTable + "." + "cdo_id" + "=" + listTable + "." + "cdo_source";
    }

    @Override
    protected Collection<EClass> getClassesWithObjectInfo() {
        return this.getClassMappings().keySet();
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.objectTypeCache == null) {
            this.objectTypeCache = this.createObjectTypeCache();
            LifecycleUtil.activate((Object)this.objectTypeCache);
        }
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.objectTypeCache);
        this.objectTypeCache = null;
        super.doDeactivate();
    }

    private IObjectTypeCache createObjectTypeCache() {
        ObjectTypeCache cache = new ObjectTypeCache();
        cache.setMappingStrategy(this);
        return cache;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean queryResources(IDBStoreAccessor accessor, IClassMapping classMapping, IStoreAccessor.QueryResourcesContext context) {
        stmt = null;
        rset = null;
        folderID = context.getFolderID();
        name = context.getName();
        exactMatch = context.exactMatch();
        try {
            stmt = classMapping.createResourceQueryStatement(accessor, folderID, name, exactMatch, (CDOBranchPoint)context);
            rset = stmt.executeQuery();
            ** GOTO lbl-1000
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable var12_12) {
                DBUtil.close(rset);
                accessor.getStatementCache().releasePreparedStatement(stmt);
                throw var12_12;
            }
        }
lbl18:
        // 1 sources

        while (true) {
            DBUtil.close((ResultSet)rset);
            accessor.getStatementCache().releasePreparedStatement(stmt);
            return false;
        }
lbl-1000:
        // 2 sources

        {
            ** while (rset.next())
        }
lbl-1000:
        // 1 sources

        {
            longID = rset.getLong(1);
            if (AbstractHorizontalMappingStrategy.TRACER.isEnabled()) {
                AbstractHorizontalMappingStrategy.TRACER.trace("Resource query returned ID " + longID);
            }
            if (context.addResource(id = CDOIDUtil.createLong((long)longID))) continue;
            ** continue;
lbl29:
            // 1 sources

            ** GOTO lbl18
        }
lbl30:
        // 1 sources

        DBUtil.close((ResultSet)rset);
        accessor.getStatementCache().releasePreparedStatement(stmt);
        return true;
    }

    private long getMinLocalID(Connection connection) {
        long min = Long.MAX_VALUE;
        if (this.getStore().getRepository().isSupportingBranches()) {
            for (IClassMapping classMapping : this.getClassMappings().values()) {
                IDBTable table = classMapping.getDBTables().get(0);
                IDBField field = table.getField("cdo_id");
                long id = DBUtil.selectMinimumLong((Connection)connection, (IDBField)field, (String[])new String[]{"0>cdo_branch"});
                if (id >= min) continue;
                min = id;
            }
        }
        return min;
    }
}

