/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMappingFactory;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BasicAbstractListTableMapping;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditFeatureMapTableMappingWithRanges
extends BasicAbstractListTableMapping
implements IListMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AuditFeatureMapTableMappingWithRanges.class);
    private static final int FINAL_VERSION = Integer.MAX_VALUE;
    private IDBTable table;
    private HashMap<Long, String> tagMap;
    private List<String> columnNames;
    private Map<Long, ITypeMapping> typeMappings;
    private String sqlSelectChunksPrefix;
    private String sqlOrderByIndex;
    protected String sqlInsert;
    private String sqlGetListLastIndex;
    private List<DBType> dbTypes;
    private String sqlRemoveEntry;
    private String sqlDeleteEntry;
    private String sqlUpdateIndex;
    private String sqlGetValue;
    private String sqlClearList;
    private String sqlDeleteList;

    public AuditFeatureMapTableMappingWithRanges(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initDBTypes();
        this.initTable();
        this.initSQLStrings();
    }

    private void initDBTypes() {
        this.dbTypes = new ArrayList<DBType>(TypeMappingFactory.getDefaultFeatureMapDBTypes());
    }

    private void initTable() {
        String tableName = this.getMappingStrategy().getTableName(this.getContainingClass(), this.getFeature());
        this.table = this.getMappingStrategy().getStore().getDBSchema().addTable(tableName);
        IDBField idField = this.table.addField("cdo_id", DBType.INTEGER);
        IDBField versionAddedField = this.table.addField("cdo_version_added", DBType.INTEGER);
        IDBField versionRemovedField = this.table.addField("cdo_version_removed", DBType.INTEGER);
        IDBField idxField = this.table.addField("cdo_idx", DBType.INTEGER);
        IDBField tagField = this.table.addField("cdo_tag", DBType.INTEGER);
        this.tagMap = new HashMap();
        this.typeMappings = new HashMap<Long, ITypeMapping>();
        this.columnNames = new ArrayList<String>();
        for (DBType type : this.getDBTypes()) {
            String column = "cdo_value_" + type.name();
            this.table.addField(column, type);
            this.columnNames.add(column);
        }
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{idField});
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{versionAddedField});
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{versionRemovedField});
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{idxField});
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{tagField});
    }

    @Override
    public Collection<IDBTable> getDBTables() {
        return Arrays.asList(this.table);
    }

    private void initSQLStrings() {
        String tableName = this.getTable().getName();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_tag");
        builder.append(", ");
        Iterator<String> iter = this.columnNames.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("<=? AND (");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL OR ");
        builder.append("cdo_version_removed");
        builder.append(">?)");
        this.sqlSelectChunksPrefix = builder.toString();
        this.sqlOrderByIndex = " ORDER BY cdo_idx";
        builder = new StringBuilder("SELECT count(1) FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("<=? AND (");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL OR ");
        builder.append("cdo_version_removed");
        builder.append(">?)");
        this.sqlGetListLastIndex = builder.toString();
        builder = new StringBuilder("INSERT INTO ");
        builder.append(tableName);
        builder.append("(");
        builder.append("cdo_source");
        builder.append(",");
        builder.append("cdo_version_added");
        builder.append(",");
        builder.append("cdo_version_removed");
        builder.append(",");
        builder.append("cdo_idx");
        builder.append(",");
        builder.append("cdo_value");
        int i = 0;
        while (i < this.columnNames.size()) {
            builder.append(this.columnNames.get(i));
            builder.append(", ");
            ++i;
        }
        builder.append("cdo_idx");
        builder.append(", ");
        builder.append("cdo_tag");
        builder.append(") VALUES (?, ?, ?, ?, ?, ");
        i = 0;
        while (i < this.columnNames.size()) {
            builder.append("?, ");
            ++i;
        }
        builder.append("?, ?)");
        this.sqlInsert = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(tableName);
        builder.append(" SET ");
        builder.append("cdo_version_removed");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlRemoveEntry = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("=?");
        this.sqlDeleteEntry = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(tableName);
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append("=? WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=?");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("cdo_tag");
        builder.append(", ");
        iter = this.columnNames.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlGetValue = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(tableName);
        builder.append(" SET ");
        builder.append("cdo_version_removed");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlClearList = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_version_added");
        builder.append("=? AND ");
        builder.append("cdo_version_removed");
        builder.append(" IS NULL");
        this.sqlDeleteList = builder.toString();
    }

    protected List<DBType> getDBTypes() {
        return this.dbTypes;
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final List<String> getColumnNames() {
        return this.columnNames;
    }

    protected final Map<Long, ITypeMapping> getTypeMappings() {
        return this.typeMappings;
    }

    protected final Map<Long, String> getTagMap() {
        return this.tagMap;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        CDOList list = revision.getList(this.getFeature());
        int listSize = -1;
        if (listChunk != -1) {
            listSize = this.getListLastIndex(accessor, revision);
            if (listSize == -1) {
                return;
            }
            listSize -= listChunk;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            try {
                String sql = String.valueOf(this.sqlSelectChunksPrefix) + this.sqlOrderByIndex;
                pstmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.HIGH);
                pstmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
                pstmt.setInt(2, revision.getVersion());
                pstmt.setInt(3, revision.getVersion());
                if (listChunk != -1) {
                    pstmt.setMaxRows(listChunk);
                }
                resultSet = pstmt.executeQuery();
                while ((listChunk == -1 || --listChunk >= 0) && resultSet.next()) {
                    Long tag = resultSet.getLong(1);
                    Object value = this.getTypeMapping(tag).readValue(resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{list.size(), value});
                    }
                    list.add((Object)CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value));
                }
                while (listSize-- >= 0) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Adding UNINITIALIZED for index {0} ", new Object[]{list.size()});
                    }
                    list.add(InternalCDOList.UNINITIALIZED);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(pstmt);
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision.getID(), revision.getVersion()});
        }
    }

    private void addFeature(Long tag) {
        EStructuralFeature modelFeature = this.getFeatureByTag(tag);
        TypeMapping typeMapping = (TypeMapping)this.getMappingStrategy().createValueMapping(modelFeature);
        String column = "cdo_value_" + typeMapping.getDBType();
        this.tagMap.put(tag, column);
        typeMapping.setDBField(this.table, column);
        this.typeMappings.put(tag, typeMapping);
    }

    private int getListLastIndex(IDBStoreAccessor accessor, InternalCDORevision revision) {
        int n;
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            pstmt = statementCache.getPreparedStatement(this.sqlGetListLastIndex, IPreparedStatementCache.ReuseProbability.HIGH);
            pstmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
            pstmt.setInt(2, revision.getVersion());
            pstmt.setInt(3, revision.getVersion());
            resultSet = pstmt.executeQuery();
            if (!resultSet.next()) {
                throw new DBException("Count expects exactly one result");
            }
            int result = resultSet.getInt(1) - 1;
            if (TRACER.isEnabled()) {
                TRACER.trace("Read list last index = " + result);
            }
            n = result;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                statementCache.releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(pstmt);
        return n;
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
        }
        IPreparedStatementCache statementCache = chunkReader.getAccessor().getStatementCache();
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            try {
                StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
                if (where != null) {
                    builder.append(" AND ");
                    builder.append(where);
                }
                builder.append(this.sqlOrderByIndex);
                String sql = builder.toString();
                pstmt = statementCache.getPreparedStatement(sql, IPreparedStatementCache.ReuseProbability.LOW);
                pstmt.setLong(1, CDOIDUtil.getLong((CDOID)chunkReader.getRevision().getID()));
                pstmt.setInt(2, chunkReader.getRevision().getVersion());
                pstmt.setInt(3, chunkReader.getRevision().getVersion());
                resultSet = pstmt.executeQuery();
                IStoreChunkReader.Chunk chunk = null;
                int chunkSize = 0;
                int chunkIndex = 0;
                int indexInChunk = 0;
                while (resultSet.next()) {
                    Long tag = resultSet.getLong(1);
                    Object value = this.getTypeMapping(tag).readValue(resultSet);
                    if (chunk == null) {
                        chunk = chunks.get(chunkIndex++);
                        chunkSize = chunk.size();
                        if (TRACER.isEnabled()) {
                            TRACER.format("Current chunk no. {0} is [start = {1}, size = {2}]", new Object[]{chunkIndex - 1, chunk.getStartIndex(), chunkSize});
                        }
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for chunk index {0} from result set: {1}", new Object[]{indexInChunk, value});
                    }
                    chunk.add(indexInChunk++, (Object)CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value));
                    if (indexInChunk != chunkSize) continue;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Chunk finished", new Object[0]);
                    }
                    chunk = null;
                    indexInChunk = 0;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Reading list chunk values done for feature {0}.{1} of {2}v{3}", new Object[]{this.getContainingClass().getName(), this.getTagByFeature(this.getFeature()), chunkReader.getRevision().getID(), chunkReader.getRevision().getVersion()});
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            statementCache.releasePreparedStatement(pstmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        statementCache.releasePreparedStatement(pstmt);
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getList(this.getFeature());
        int idx = 0;
        for (Object element : values) {
            this.writeValue(accessor, (CDORevision)revision, idx++, element);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing done", new Object[0]);
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int idx, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3}v{4} : {5}", new Object[]{this.getContainingClass().getName(), this.getTagByFeature(this.getFeature()), idx, revision.getID(), revision.getVersion(), value});
        }
        this.addEntry(accessor, revision.getID(), revision.getVersion(), idx, value);
    }

    protected String getColumnName(Long tag) {
        String column = this.tagMap.get(tag);
        if (column == null) {
            this.addFeature(tag);
            column = this.tagMap.get(tag);
        }
        return column;
    }

    protected ITypeMapping getTypeMapping(Long tag) {
        ITypeMapping typeMapping = this.typeMappings.get(tag);
        if (typeMapping == null) {
            this.addFeature(tag);
            typeMapping = this.typeMappings.get(tag);
        }
        return typeMapping;
    }

    private EStructuralFeature getFeatureByTag(Long tag) {
        return (EStructuralFeature)this.getMappingStrategy().getStore().getMetaDataManager().getMetaInstance(tag);
    }

    protected Long getTagByFeature(EStructuralFeature feature) {
        return this.getMappingStrategy().getStore().getMetaDataManager().getMetaID((EModelElement)feature);
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement pstmtDeleteTemp = null;
        PreparedStatement pstmtClear = null;
        try {
            try {
                pstmtDeleteTemp = statementCache.getPreparedStatement(this.sqlDeleteList, IPreparedStatementCache.ReuseProbability.HIGH);
                pstmtDeleteTemp.setLong(1, CDOIDUtil.getLong((CDOID)id));
                pstmtDeleteTemp.setInt(2, newVersion);
                int result = CDODBUtil.sqlUpdate(pstmtDeleteTemp, false);
                if (TRACER.isEnabled()) {
                    TRACER.format("DeleteList result: {0}", new Object[]{result});
                }
                pstmtClear = statementCache.getPreparedStatement(this.sqlClearList, IPreparedStatementCache.ReuseProbability.HIGH);
                pstmtClear.setInt(1, newVersion);
                pstmtClear.setLong(2, CDOIDUtil.getLong((CDOID)id));
                result = CDODBUtil.sqlUpdate(pstmtClear, false);
                if (TRACER.isEnabled()) {
                    TRACER.format("ClearList result: {0}", new Object[]{result});
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(pstmtDeleteTemp);
            statementCache.releasePreparedStatement(pstmtClear);
            throw throwable;
        }
        statementCache.releasePreparedStatement(pstmtDeleteTemp);
        statementCache.releasePreparedStatement(pstmtClear);
    }

    @Override
    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        if (TRACER.isEnabled()) {
            TRACER.format("objectRevised {0}: {1}", new Object[]{id, revised});
        }
        CDOBranch main = this.getMappingStrategy().getStore().getRepository().getBranchManager().getMainBranch();
        CDORevision revision = this.getMappingStrategy().getStore().getRepository().getRevisionManager().getRevision(id, main.getHead(), 0, 0, true);
        this.clearList(accessor, id, revision.getVersion(), Integer.MAX_VALUE);
    }

    @Override
    public void processDelta(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, long created, CDOListFeatureDelta delta) {
        IRepository repo = accessor.getStore().getRepository();
        InternalCDORevision originalRevision = (InternalCDORevision)repo.getRevisionManager().getRevision(id, repo.getBranchManager().getMainBranch().getHead(), 0, 0, true);
        int oldListSize = originalRevision.getList(this.getFeature()).size();
        if (TRACER.isEnabled()) {
            TRACER.format("ListTableMapping.processDelta for revision {0} - previous list size: {1}", new Object[]{originalRevision, oldListSize});
        }
        ListDeltaVisitor visitor = new ListDeltaVisitor(accessor, originalRevision, oldVersion, newVersion);
        if (TRACER.isEnabled()) {
            TRACER.format("Processing deltas...", new Object[0]);
        }
        for (CDOFeatureDelta listDelta : delta.getListChanges()) {
            listDelta.accept((CDOFeatureDeltaVisitor)visitor);
        }
    }

    private void addEntry(IDBStoreAccessor accessor, CDOID id, int version, int index, Object value) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement pstmt = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Adding value for feature() {0}.{1} index {2} of {3}v{4} : {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, version, value});
        }
        try {
            try {
                FeatureMap.Entry entry = (FeatureMap.Entry)value;
                EStructuralFeature entryFeature = entry.getEStructuralFeature();
                Long tag = this.getTagByFeature(entryFeature);
                String column = this.getColumnName(tag);
                pstmt = statementCache.getPreparedStatement(this.sqlInsert, IPreparedStatementCache.ReuseProbability.HIGH);
                int stmtIndex = 1;
                pstmt.setLong(stmtIndex++, CDOIDUtil.getLong((CDOID)id));
                pstmt.setInt(stmtIndex++, version);
                pstmt.setInt(stmtIndex++, index);
                int i = 0;
                while (i < this.columnNames.size()) {
                    if (this.columnNames.get(i).equals(column)) {
                        this.getTypeMapping(tag).setValue(pstmt, stmtIndex++, entry.getValue());
                    } else {
                        pstmt.setNull(stmtIndex++, this.getDBTypes().get(i).getCode());
                    }
                    ++i;
                }
                pstmt.setInt(stmtIndex++, index);
                pstmt.setLong(stmtIndex++, tag);
                CDODBUtil.sqlUpdate(pstmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(pstmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(pstmt);
    }

    private void removeEntry(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, int index) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement pstmt = null;
        if (TRACER.isEnabled()) {
            TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion});
        }
        try {
            try {
                pstmt = statementCache.getPreparedStatement(this.sqlDeleteEntry, IPreparedStatementCache.ReuseProbability.HIGH);
                int stmtIndex = 1;
                pstmt.setLong(stmtIndex++, CDOIDUtil.getLong((CDOID)id));
                pstmt.setInt(stmtIndex++, index);
                pstmt.setInt(stmtIndex++, newVersion);
                int result = CDODBUtil.sqlUpdate(pstmt, false);
                if (result == 1) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("removeEntry deleted: {0}", new Object[]{index});
                    }
                } else {
                    if (result > 1) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("removeEntry Too many results: {0}: {1}", new Object[]{index, result});
                        }
                        throw new DBException("Too many results");
                    }
                    statementCache.releasePreparedStatement(pstmt);
                    pstmt = statementCache.getPreparedStatement(this.sqlRemoveEntry, IPreparedStatementCache.ReuseProbability.HIGH);
                    stmtIndex = 1;
                    pstmt.setInt(stmtIndex++, newVersion);
                    pstmt.setLong(stmtIndex++, CDOIDUtil.getLong((CDOID)id));
                    pstmt.setInt(stmtIndex++, index);
                    CDODBUtil.sqlUpdate(pstmt, true);
                }
            }
            catch (SQLException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4} FAILED {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4} FAILED {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(pstmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(pstmt);
    }

    private FeatureMap.Entry getValue(IDBStoreAccessor accessor, CDOID id, int index) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement pstmt = null;
        FeatureMap.Entry result = null;
        try {
            try {
                pstmt = statementCache.getPreparedStatement(this.sqlGetValue, IPreparedStatementCache.ReuseProbability.HIGH);
                int stmtIndex = 1;
                pstmt.setLong(stmtIndex++, CDOIDUtil.getLong((CDOID)id));
                pstmt.setInt(stmtIndex++, index);
                ResultSet resultSet = pstmt.executeQuery();
                if (!resultSet.next()) {
                    throw new DBException("getValue expects exactly one result");
                }
                Long tag = resultSet.getLong(1);
                Object value = this.getTypeMapping(tag).readValue(resultSet);
                result = CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value);
                if (TRACER.isEnabled()) {
                    TRACER.format("Read value (index {0}) from result set: {1}", new Object[]{index, result});
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(pstmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(pstmt);
        return result;
    }

    private class ListDeltaVisitor
    implements CDOFeatureDeltaVisitor {
        private IDBStoreAccessor accessor;
        private InternalCDORevision originalRevision;
        private CDOID id;
        private int oldVersion;
        private int newVersion;
        private int lastIndex;

        public ListDeltaVisitor(IDBStoreAccessor accessor, InternalCDORevision originalRevision, int oldVersion, int newVersion) {
            this.accessor = accessor;
            this.originalRevision = originalRevision;
            this.id = this.originalRevision.getID();
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
            this.lastIndex = originalRevision.getList(AuditFeatureMapTableMappingWithRanges.this.getFeature()).size() - 1;
        }

        public void visit(CDOMoveFeatureDelta delta) {
            int fromIdx = delta.getOldPosition();
            int toIdx = delta.getNewPosition();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Moving: {0} to {1}", new Object[]{fromIdx, toIdx});
            }
            FeatureMap.Entry value = AuditFeatureMapTableMappingWithRanges.this.getValue(this.accessor, this.id, fromIdx);
            AuditFeatureMapTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.oldVersion, this.newVersion, fromIdx);
            if (fromIdx < toIdx) {
                this.moveOneUp(this.accessor, this.id, this.oldVersion, this.newVersion, fromIdx + 1, toIdx);
            } else {
                this.moveOneDown(this.accessor, this.id, this.oldVersion, this.newVersion, toIdx, fromIdx - 1);
            }
            AuditFeatureMapTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.newVersion, toIdx, value);
        }

        public void visit(CDOAddFeatureDelta delta) {
            int startIndex = delta.getIndex();
            int endIndex = this.lastIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Adding at: {0}", new Object[]{startIndex});
            }
            if (startIndex <= endIndex) {
                this.moveOneDown(this.accessor, this.id, this.oldVersion, this.newVersion, startIndex, endIndex);
            }
            AuditFeatureMapTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.newVersion, startIndex, delta.getValue());
            ++this.lastIndex;
        }

        public void visit(CDORemoveFeatureDelta delta) {
            int startIndex = delta.getIndex();
            int endIndex = this.lastIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Removing at: {0}", new Object[]{startIndex});
            }
            AuditFeatureMapTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.oldVersion, this.newVersion, startIndex);
            this.moveOneUp(this.accessor, this.id, this.oldVersion, this.newVersion, startIndex + 1, endIndex);
            --this.lastIndex;
        }

        public void visit(CDOSetFeatureDelta delta) {
            int index = delta.getIndex();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Setting at: {0}", new Object[]{index});
            }
            AuditFeatureMapTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.oldVersion, this.newVersion, index);
            AuditFeatureMapTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.newVersion, index, delta.getValue());
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            if (delta.getFeature().isUnsettable()) {
                throw new ImplementationError("Should not be called");
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Unsetting", new Object[0]);
            }
            AuditFeatureMapTableMappingWithRanges.this.clearList(this.accessor, this.id, this.oldVersion, this.newVersion);
            this.lastIndex = -1;
        }

        public void visit(CDOListFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOClearFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Clearing", new Object[0]);
            }
            AuditFeatureMapTableMappingWithRanges.this.clearList(this.accessor, this.id, this.oldVersion, this.newVersion);
            this.lastIndex = -1;
        }

        public void visit(CDOContainerFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        private void moveOneUp(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = statementCache.getPreparedStatement(AuditFeatureMapTableMappingWithRanges.this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                    int index = startIndex;
                    while (index <= endIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneUp moving: {0} -> {1}", new Object[]{index, index - 1});
                        }
                        int stmtIndex = 1;
                        pstmt.setInt(stmtIndex++, index - 1);
                        pstmt.setLong(stmtIndex++, CDOIDUtil.getLong((CDOID)id));
                        pstmt.setInt(stmtIndex++, newVersion);
                        pstmt.setInt(stmtIndex++, index);
                        int result = CDODBUtil.sqlUpdate(pstmt, false);
                        switch (result) {
                            case 0: {
                                FeatureMap.Entry value = AuditFeatureMapTableMappingWithRanges.this.getValue(accessor, id, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp remove: {0}", new Object[]{index});
                                }
                                AuditFeatureMapTableMappingWithRanges.this.removeEntry(accessor, id, oldVersion, newVersion, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp add: {0}", new Object[]{index - 1});
                                }
                                AuditFeatureMapTableMappingWithRanges.this.addEntry(accessor, id, newVersion, index - 1, value);
                                break;
                            }
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneUp updated: {0} -> {1}", new Object[]{index, index - 1});
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        ++index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(pstmt);
                throw throwable;
            }
            statementCache.releasePreparedStatement(pstmt);
        }

        private void moveOneDown(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IPreparedStatementCache statementCache = accessor.getStatementCache();
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = statementCache.getPreparedStatement(AuditFeatureMapTableMappingWithRanges.this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                    int index = endIndex;
                    while (index >= startIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneDown moving: {0} -> {1}", new Object[]{index, index + 1});
                        }
                        int stmtIndex = 1;
                        pstmt.setInt(stmtIndex++, index + 1);
                        pstmt.setLong(stmtIndex++, CDOIDUtil.getLong((CDOID)id));
                        pstmt.setInt(stmtIndex++, newVersion);
                        pstmt.setInt(stmtIndex++, index);
                        int result = CDODBUtil.sqlUpdate(pstmt, false);
                        switch (result) {
                            case 0: {
                                FeatureMap.Entry value = AuditFeatureMapTableMappingWithRanges.this.getValue(accessor, id, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown remove: {0}", new Object[]{index});
                                }
                                AuditFeatureMapTableMappingWithRanges.this.removeEntry(accessor, id, oldVersion, newVersion, index);
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown add: {0}", new Object[]{index + 1});
                                }
                                AuditFeatureMapTableMappingWithRanges.this.addEntry(accessor, id, newVersion, index + 1, value);
                                break;
                            }
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneDown updated: {0} -> {1}", new Object[]{index, index + 1});
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        --index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(pstmt);
                throw throwable;
            }
            statementCache.releasePreparedStatement(pstmt);
        }
    }
}

