/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingAuditSupport;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingMappingStrategy;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalBranchingClassMapping
extends AbstractHorizontalClassMapping
implements IClassMappingAuditSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HorizontalBranchingClassMapping.class);
    private String sqlInsertAttributes;
    private String sqlSelectCurrentAttributes;
    private String sqlSelectAllObjectIDs;
    private String sqlSelectAttributesByTime;
    private String sqlSelectAttributesByVersion;
    private String sqlReviseAttributes;
    private String sqlSelectForHandle;
    private String sqlSelectForChangeSet;

    public HorizontalBranchingClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        super(mappingStrategy, eClass);
        this.initSQLStrings();
    }

    @Override
    protected IDBField addBranchingField(IDBTable table) {
        return table.addField("cdo_branch", DBType.INTEGER, true);
    }

    private void initSQLStrings() {
        Map<EStructuralFeature, String> unsettableFields = this.getUnsettableFields();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_version");
        builder.append(", ");
        builder.append("cdo_created");
        builder.append(", ");
        builder.append("cdo_revised");
        builder.append(", ");
        builder.append("cdo_resource");
        builder.append(", ");
        builder.append("cdo_container");
        builder.append(", ");
        builder.append("cdo_feature");
        for (ITypeMapping singleMapping : this.getValueMappings()) {
            builder.append(", ");
            builder.append(singleMapping.getField());
        }
        if (unsettableFields != null) {
            for (String fieldName : unsettableFields.values()) {
                builder.append(", ");
                builder.append(fieldName);
            }
        }
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_branch");
        builder.append("=? AND (");
        String sqlSelectAttributesPrefix = builder.toString();
        builder.append("cdo_revised");
        builder.append("=0)");
        this.sqlSelectCurrentAttributes = builder.toString();
        builder = new StringBuilder(sqlSelectAttributesPrefix);
        builder.append("cdo_created");
        builder.append("<=? AND (");
        builder.append("cdo_revised");
        builder.append("=0 OR ");
        builder.append("cdo_revised");
        builder.append(">=?))");
        this.sqlSelectAttributesByTime = builder.toString();
        builder = new StringBuilder(sqlSelectAttributesPrefix);
        builder.append("ABS(");
        builder.append("cdo_version");
        builder.append(")=?)");
        this.sqlSelectAttributesByVersion = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable());
        builder.append("(");
        builder.append("cdo_id");
        builder.append(", ");
        builder.append("cdo_version");
        builder.append(", ");
        builder.append("cdo_branch");
        builder.append(", ");
        builder.append("cdo_class");
        builder.append(", ");
        builder.append("cdo_created");
        builder.append(", ");
        builder.append("cdo_revised");
        builder.append(", ");
        builder.append("cdo_resource");
        builder.append(", ");
        builder.append("cdo_container");
        builder.append(", ");
        builder.append("cdo_feature");
        for (ITypeMapping singleMapping : this.getValueMappings()) {
            builder.append(", ");
            builder.append(singleMapping.getField());
        }
        if (unsettableFields != null) {
            for (String fieldName : unsettableFields.values()) {
                builder.append(", ");
                builder.append(fieldName);
            }
        }
        builder.append(") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?");
        int i = 0;
        while (i < this.getValueMappings().size()) {
            builder.append(", ?");
            ++i;
        }
        if (unsettableFields != null) {
            i = 0;
            while (i < unsettableFields.size()) {
                builder.append(", ?");
                ++i;
            }
        }
        builder.append(")");
        this.sqlInsertAttributes = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_revised");
        builder.append("=? WHERE ");
        builder.append("cdo_id");
        builder.append("=? AND ");
        builder.append("cdo_branch");
        builder.append("=? AND ");
        builder.append("cdo_revised");
        builder.append("=0");
        this.sqlReviseAttributes = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_revised");
        builder.append("=0");
        this.sqlSelectAllObjectIDs = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("cdo_id");
        builder.append(", ");
        builder.append("cdo_version");
        builder.append(", ");
        builder.append("cdo_branch");
        builder.append(" FROM ");
        builder.append(this.getTable());
        this.sqlSelectForHandle = builder.toString();
        builder = new StringBuilder("SELECT DISTINCT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        this.sqlSelectForChangeSet = builder.toString();
    }

    @Override
    public boolean readRevision(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement pstmt = null;
        long timeStamp = revision.getTimeStamp();
        int branchID = revision.getBranch().getID();
        try {
            if (timeStamp != 0L) {
                pstmt = statementCache.getPreparedStatement(this.sqlSelectAttributesByTime, IPreparedStatementCache.ReuseProbability.MEDIUM);
                pstmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
                pstmt.setLong(2, branchID);
                pstmt.setLong(3, timeStamp);
                pstmt.setLong(4, timeStamp);
            } else {
                pstmt = statementCache.getPreparedStatement(this.sqlSelectCurrentAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                pstmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
                pstmt.setLong(2, branchID);
            }
            boolean success = this.readValuesFromStatement(pstmt, revision, accessor);
            if (success && revision.getVersion() >= 1) {
                this.readLists(accessor, revision, listChunk);
            }
            boolean bl = success;
            statementCache.releasePreparedStatement(pstmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
    }

    @Override
    public boolean readRevisionByVersion(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement pstmt = null;
        try {
            pstmt = statementCache.getPreparedStatement(this.sqlSelectAttributesByVersion, IPreparedStatementCache.ReuseProbability.HIGH);
            pstmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
            pstmt.setInt(2, revision.getBranch().getID());
            pstmt.setInt(3, revision.getVersion());
            boolean success = this.readValuesFromStatement(pstmt, revision, accessor);
            if (success) {
                this.readLists(accessor, revision, listChunk);
            }
            boolean bl = success;
            statementCache.releasePreparedStatement(pstmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
    }

    @Override
    public PreparedStatement createResourceQueryStatement(IDBStoreAccessor accessor, CDOID folderId, String name, boolean exactMatch, CDOBranchPoint branchPoint) {
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        ITypeMapping nameValueMapping = this.getValueMapping((EStructuralFeature)nameFeature);
        if (nameValueMapping == null) {
            throw new ImplementationError(nameFeature + " not found in ClassMapping " + this);
        }
        int branchID = branchPoint.getBranch().getID();
        long timeStamp = branchPoint.getTimeStamp();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_version");
        builder.append(">0 AND ");
        builder.append("cdo_branch");
        builder.append("=? AND ");
        builder.append("cdo_container");
        builder.append("=? AND ");
        builder.append(nameValueMapping.getField());
        if (name == null) {
            builder.append(" IS NULL");
        } else {
            builder.append(exactMatch ? " =? " : " LIKE ? ");
        }
        builder.append(" AND (");
        if (timeStamp == 0L) {
            builder.append("cdo_revised");
            builder.append("=0)");
        } else {
            builder.append("cdo_created");
            builder.append("<=? AND (");
            builder.append("cdo_revised");
            builder.append("=0 OR ");
            builder.append("cdo_revised");
            builder.append(">=?))");
        }
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement pstmt = null;
        try {
            int idx = 1;
            pstmt = statementCache.getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.MEDIUM);
            pstmt.setInt(idx++, branchID);
            pstmt.setLong(idx++, CDOIDUtil.getLong((CDOID)folderId));
            if (name != null) {
                String queryName = exactMatch ? name : String.valueOf(name) + "%";
                nameValueMapping.setValue(pstmt, idx++, queryName);
            }
            if (timeStamp != 0L) {
                pstmt.setLong(idx++, timeStamp);
                pstmt.setLong(idx++, timeStamp);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Created Resource Query: {0}", new Object[]{pstmt.toString()});
            }
            return pstmt;
        }
        catch (SQLException ex) {
            statementCache.releasePreparedStatement(pstmt);
            throw new DBException((Throwable)ex);
        }
    }

    @Override
    public PreparedStatement createObjectIDStatement(IDBStoreAccessor accessor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Created ObjectID Statement : {0}", new Object[]{this.sqlSelectAllObjectIDs});
        }
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        return statementCache.getPreparedStatement(this.sqlSelectAllObjectIDs, IPreparedStatementCache.ReuseProbability.HIGH);
    }

    @Override
    protected final void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        long commitTime = revision.getTimeStamp();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                int col = 1;
                stmt = statementCache.getPreparedStatement(this.sqlInsertAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(col++, CDOIDUtil.getLong((CDOID)revision.getID()));
                stmt.setInt(col++, revision.getVersion());
                stmt.setInt(col++, revision.getBranch().getID());
                stmt.setLong(col++, accessor.getStore().getMetaDataManager().getMetaID((EModelElement)revision.getEClass()));
                stmt.setLong(col++, commitTime);
                stmt.setLong(col++, revision.getRevised());
                stmt.setLong(col++, CDODBUtil.convertCDOIDToLong(this.getExternalReferenceManager(), accessor, revision.getResourceID(), commitTime));
                stmt.setLong(col++, CDODBUtil.convertCDOIDToLong(this.getExternalReferenceManager(), accessor, (CDOID)revision.getContainerID(), commitTime));
                stmt.setInt(col++, revision.getContainingFeatureID());
                int isSetCol = col + this.getValueMappings().size();
                for (ITypeMapping mapping : this.getValueMappings()) {
                    EStructuralFeature feature = mapping.getFeature();
                    if (feature.isUnsettable()) {
                        if (revision.getValue(feature) == null) {
                            stmt.setBoolean(isSetCol++, false);
                            mapping.setDefaultValue(stmt, col++);
                            continue;
                        }
                        stmt.setBoolean(isSetCol++, true);
                    }
                    mapping.setValueFromRevision(stmt, col++, revision);
                }
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    @Override
    protected void detachAttributes(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, long timeStamp, OMMonitor mon) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlInsertAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                int col = 1;
                stmt.setLong(col++, CDOIDUtil.getLong((CDOID)id));
                stmt.setInt(col++, -version);
                stmt.setInt(col++, branch.getID());
                stmt.setLong(col++, accessor.getStore().getMetaDataManager().getMetaID((EModelElement)this.getEClass()));
                stmt.setLong(col++, timeStamp);
                stmt.setLong(col++, 0L);
                stmt.setLong(col++, DBStore.NULL);
                stmt.setLong(col++, DBStore.NULL);
                stmt.setInt(col++, 0);
                int isSetCol = col + this.getValueMappings().size();
                for (ITypeMapping mapping : this.getValueMappings()) {
                    EStructuralFeature feature = mapping.getFeature();
                    if (feature.isUnsettable()) {
                        stmt.setBoolean(isSetCol++, false);
                    }
                    mapping.setDefaultValue(stmt, col++);
                }
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    @Override
    protected void reviseOldRevision(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, long revised) {
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(this.sqlReviseAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(1, revised);
                stmt.setLong(2, CDOIDUtil.getLong((CDOID)id));
                stmt.setInt(3, branch.getID());
                CDODBUtil.sqlUpdate(stmt, false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        statementCache.releasePreparedStatement(stmt);
    }

    @Override
    public void writeRevision(IDBStoreAccessor accessor, InternalCDORevision revision, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin(10.0);
        try {
            try {
                async = monitor.forkAsync();
                CDOID id = revision.getID();
                if (accessor.isNewObject(id)) {
                    long timeStamp = revision.getTimeStamp();
                    HorizontalBranchingMappingStrategy mappingStrategy = (HorizontalBranchingMappingStrategy)this.getMappingStrategy();
                    mappingStrategy.putObjectType(accessor, timeStamp, id, this.getEClass());
                } else if (revision.getVersion() > 1) {
                    long revised = revision.getTimeStamp() - 1L;
                    this.reviseOldRevision(accessor, id, revision.getBranch(), revised);
                    for (IListMapping mapping : this.getListMappings()) {
                        mapping.objectDetached(accessor, id, revised);
                    }
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                async = monitor.forkAsync();
                if (revision.isResourceFolder() || revision.isResource()) {
                    this.checkDuplicateResources(accessor, (CDORevision)revision);
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                async = monitor.forkAsync();
                this.writeValues(accessor, revision);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                async = monitor.forkAsync(7.0);
                if (this.getListMappings() != null) {
                    this.writeLists(accessor, revision);
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void handleRevisions(IDBStoreAccessor accessor, CDOBranch branch, long timeStamp, CDORevisionHandler handler) {
        StringBuilder builder = new StringBuilder(this.sqlSelectForHandle);
        boolean whereAppend = false;
        if (branch != null) {
            builder.append(" WHERE ");
            builder.append("cdo_branch");
            builder.append("=? ");
            whereAppend = true;
        }
        if (timeStamp != 0L) {
            builder.append(whereAppend ? " AND " : " WHERE ");
            builder.append("cdo_created");
            builder.append("=? ");
        }
        IRepository repository = accessor.getStore().getRepository();
        CDORevisionManager revisionManager = repository.getRevisionManager();
        CDOBranchManager branchManager = repository.getBranchManager();
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = statementCache.getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.LOW);
                int col = 1;
                if (branch != null) {
                    stmt.setInt(col++, branch.getID());
                }
                if (timeStamp != 0L) {
                    stmt.setLong(col, timeStamp);
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long id = rs.getLong(1);
                    int version = rs.getInt(2);
                    int branchID = rs.getInt(3);
                    if (version < 1) continue;
                    CDOBranchVersion branchVersion = branchManager.getBranch(branchID).getVersion(Math.abs(version));
                    InternalCDORevision revision = (InternalCDORevision)revisionManager.getRevisionByVersion(CDOIDUtil.createLong((long)id), branchVersion, -1, true);
                    handler.handleRevision((CDORevision)revision);
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs);
            statementCache.releasePreparedStatement(stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs);
        statementCache.releasePreparedStatement(stmt);
    }

    @Override
    public Set<CDOID> readChangeSet(IDBStoreAccessor accessor, CDOChangeSetSegment[] segments) {
        HashSet<CDOID> hashSet;
        StringBuilder builder = new StringBuilder(this.sqlSelectForChangeSet);
        boolean isFirst = true;
        int i = 0;
        while (i < segments.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(" OR ");
            }
            builder.append("cdo_branch");
            builder.append("=? AND ");
            builder.append("cdo_created");
            builder.append(">=?");
            builder.append(" AND (");
            builder.append("cdo_revised");
            builder.append("<=? OR ");
            builder.append("cdo_revised");
            builder.append("=");
            builder.append(0L);
            builder.append(")");
            ++i;
        }
        IPreparedStatementCache statementCache = accessor.getStatementCache();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashSet<CDOID> result = new HashSet<CDOID>();
        try {
            stmt = statementCache.getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.LOW);
            int col = 1;
            CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
                stmt.setInt(col++, segment.getBranch().getID());
                stmt.setLong(col++, segment.getTimeStamp());
                stmt.setLong(col++, segment.getEndTime());
                ++n2;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                long id = rs.getLong(1);
                result.add(CDOIDUtil.createLong((long)id));
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs);
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)rs);
        statementCache.releasePreparedStatement(stmt);
        return hashSet;
    }
}

