/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingFeatureMapTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.BranchingListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingClassMapping;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBTable;

public class HorizontalBranchingMappingStrategy
extends AbstractHorizontalMappingStrategy {
    public boolean hasAuditSupport() {
        return true;
    }

    public boolean hasBranchingSupport() {
        return true;
    }

    public boolean hasDeltaSupport() {
        return false;
    }

    public IClassMapping doCreateClassMapping(EClass eClass) {
        return new HorizontalBranchingClassMapping(this, eClass);
    }

    public IListMapping doCreateListMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingListTableMapping(this, containingClass, feature);
    }

    public IListMapping doCreateFeatureMapMapping(EClass containingClass, EStructuralFeature feature) {
        return new BranchingFeatureMapTableMapping(this, containingClass, feature);
    }

    protected void rawImportReviseOldRevisions(Connection connection, IDBTable table) {
        String sqlUpdate = "UPDATE " + table + " SET " + "cdo_revised" + "=? WHERE " + "cdo_id" + "=? AND " + "cdo_branch" + "=? AND " + "cdo_version" + "=?";
        String sqlQuery = "SELECT cdo1.cdo_id, cdo1.cdo_branch, cdo1.cdo_version, cdo2.cdo_created FROM " + table + " cdo1, " + table + " cdo2 WHERE cdo1." + "cdo_id" + "=cdo2." + "cdo_id" + " AND cdo1." + "cdo_branch" + "=cdo2." + "cdo_branch" + " AND cdo1." + "cdo_version" + "=cdo2." + "cdo_version" + "-1 AND cdo1." + "cdo_revised" + "=0";
        PreparedStatement stmtUpdate = null;
        PreparedStatement stmtQuery = null;
        ResultSet resultSet = null;
        try {
            try {
                stmtUpdate = connection.prepareStatement(sqlUpdate);
                stmtQuery = connection.prepareStatement(sqlQuery);
                resultSet = stmtQuery.executeQuery();
                while (resultSet.next()) {
                    long id = resultSet.getLong(1);
                    int branch = resultSet.getInt(2);
                    int version = resultSet.getInt(3);
                    long revised = resultSet.getLong(4) - 1L;
                    stmtUpdate.setLong(1, revised);
                    stmtUpdate.setLong(2, id);
                    stmtUpdate.setInt(3, branch);
                    stmtUpdate.setInt(4, version);
                    stmtUpdate.addBatch();
                }
                stmtUpdate.executeBatch();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close(stmtQuery);
            DBUtil.close((Statement)stmtUpdate);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmtQuery);
        DBUtil.close((Statement)stmtUpdate);
    }

    protected String getListJoin(String attrTable, String listTable) {
        String join = super.getListJoin(attrTable, listTable);
        join = String.valueOf(join) + " AND " + attrTable + "." + "cdo_version" + "=" + listTable + "." + "cdo_version";
        join = String.valueOf(join) + " AND " + attrTable + "." + "cdo_branch" + "=" + listTable + "." + "cdo_branch";
        return join;
    }
}

