/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractListTableMapping;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class NonAuditListTableMapping
extends AbstractListTableMapping
implements IListMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, NonAuditListTableMapping.class);
    private static final AbstractListTableMapping.FieldInfo[] KEY_FIELDS = new AbstractListTableMapping.FieldInfo[]{new AbstractListTableMapping.FieldInfo("cdo_source", DBType.BIGINT)};
    private static final int UNBOUNDED_SHIFT = -1;
    private ArrayList<ManipulationElement> manipulations = new ArrayList();
    private boolean clearFirst;
    private String sqlClear;
    private String sqlUpdateValue;
    private String sqlUpdateIndex;
    private String sqlInsertValue;
    private String sqlDeleteItem;

    public NonAuditListTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initSQLStrings();
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? ");
        this.sqlClear = builder.toString();
        builder.append(" AND ");
        builder.append("cdo_idx");
        builder.append("=? ");
        this.sqlDeleteItem = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_value");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? ");
        this.sqlUpdateValue = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable());
        builder.append(" (");
        builder.append("cdo_source");
        builder.append(", ");
        builder.append("cdo_idx");
        builder.append(", ");
        builder.append("cdo_value");
        builder.append(") VALUES(?, ?, ?) ");
        this.sqlInsertValue = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append("=? AND ");
        builder.append("cdo_idx");
        builder.append("=? ");
        this.sqlUpdateIndex = builder.toString();
    }

    protected AbstractListTableMapping.FieldInfo[] getKeyFields() {
        return KEY_FIELDS;
    }

    protected void setKeyFields(PreparedStatement stmt, CDORevision revision) throws SQLException {
        stmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
    }

    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        this.clearList(accessor, id);
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlClear, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(1, CDOIDUtil.getLong((CDOID)id));
                CDODBUtil.sqlUpdate(stmt, false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    public void processDelta(IDBStoreAccessor accessor, CDOID id, int oldVersion, int newVersion, long created, CDOListFeatureDelta delta) {
        CDOBranchPoint main = accessor.getStore().getRepository().getBranchManager().getMainBranch().getHead();
        InternalCDORevision originalRevision = (InternalCDORevision)accessor.getStore().getRepository().getRevisionManager().getRevision(id, main, -1, 0, true);
        int oldListSize = originalRevision.getList(this.getFeature()).size();
        this.clearFirst = false;
        if (TRACER.isEnabled()) {
            TRACER.format("ListTableMapping.processDelta for revision {0} - previous list size: {1}", new Object[]{originalRevision, oldListSize});
        }
        if (this.manipulations == null) {
            this.manipulations = new ArrayList();
        } else {
            this.manipulations.clear();
        }
        int i = 0;
        while (i < oldListSize) {
            this.manipulations.add(this.createOriginalElement(i));
            ++i;
        }
        ListDeltaVisitor visitor = new ListDeltaVisitor();
        if (TRACER.isEnabled()) {
            TRACER.format("Procssing deltas...", new Object[0]);
        }
        for (CDOFeatureDelta listDelta : delta.getListChanges()) {
            listDelta.accept((CDOFeatureDeltaVisitor)visitor);
        }
        this.writeResultToDatabase(accessor, id);
    }

    private void writeResultToDatabase(IDBStoreAccessor accessor, CDOID id) {
        long longId = CDOIDUtil.getLong((CDOID)id);
        PreparedStatement deleteStmt = null;
        PreparedStatement moveStmt = null;
        Statement setValueStmt = null;
        Statement insertStmt = null;
        int deleteCounter = 0;
        int moveCounter = 0;
        int setValueCounter = 0;
        int insertCounter = 0;
        int tempIndex = -1;
        if (TRACER.isEnabled()) {
            TRACER.format("Writing to database:", new Object[0]);
        }
        if (this.clearFirst) {
            if (TRACER.isEnabled()) {
                TRACER.format(" - clear list", new Object[0]);
            }
            this.clearList(accessor, id);
        }
        try {
            try {
                int n;
                int n2;
                int[] nArray;
                Object element;
                for (ManipulationElement element2 : this.manipulations) {
                    if (element2.is(16)) {
                        if (deleteStmt == null) {
                            deleteStmt = accessor.getStatementCache().getPreparedStatement(this.sqlDeleteItem, IPreparedStatementCache.ReuseProbability.HIGH);
                            deleteStmt.setLong(1, longId);
                        }
                        deleteStmt.setInt(2, element2.sourceIndex);
                        deleteStmt.addBatch();
                        ++deleteCounter;
                        if (TRACER.isEnabled()) {
                            TRACER.format(" - delete at {0} ", new Object[]{element2.sourceIndex});
                        }
                    }
                    if (!element2.is(4)) continue;
                    if (moveStmt == null) {
                        moveStmt = accessor.getStatementCache().getPreparedStatement(this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                        moveStmt.setLong(2, longId);
                    }
                    moveStmt.setInt(3, element2.sourceIndex);
                    moveStmt.setInt(1, --tempIndex);
                    element2.tempIndex = tempIndex;
                    moveStmt.addBatch();
                    ++moveCounter;
                    if (!TRACER.isEnabled()) continue;
                    TRACER.format(" - move {0} -> {1} ", new Object[]{element2.sourceIndex, element2.tempIndex});
                }
                int size = this.manipulations.size();
                int i = 0;
                while (i < size) {
                    element = this.manipulations.get(i);
                    if ((((ManipulationElement)element).type == 0 || ((ManipulationElement)element).type == 2) && ((ManipulationElement)element).sourceIndex > ((ManipulationElement)element).destinationIndex) {
                        if (moveStmt == null) {
                            moveStmt = accessor.getStatementCache().getPreparedStatement(this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                            moveStmt.setLong(2, longId);
                        }
                        moveStmt.setInt(3, ((ManipulationElement)element).sourceIndex);
                        moveStmt.setInt(1, ((ManipulationElement)element).destinationIndex);
                        moveStmt.addBatch();
                        ++moveCounter;
                        if (TRACER.isEnabled()) {
                            TRACER.format(" - move {0} -> {1} ", new Object[]{((ManipulationElement)element).sourceIndex, ((ManipulationElement)element).destinationIndex});
                        }
                    }
                    ++i;
                }
                i = size - 1;
                while (i >= 0) {
                    element = this.manipulations.get(i);
                    if ((((ManipulationElement)element).type == 0 || ((ManipulationElement)element).type == 2) && ((ManipulationElement)element).sourceIndex < ((ManipulationElement)element).destinationIndex) {
                        if (moveStmt == null) {
                            moveStmt = accessor.getStatementCache().getPreparedStatement(this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                            moveStmt.setLong(2, longId);
                        }
                        moveStmt.setInt(3, ((ManipulationElement)element).sourceIndex);
                        moveStmt.setInt(1, ((ManipulationElement)element).destinationIndex);
                        moveStmt.addBatch();
                        ++moveCounter;
                        if (TRACER.isEnabled()) {
                            TRACER.format(" - move {0} -> {1} ", new Object[]{((ManipulationElement)element).sourceIndex, ((ManipulationElement)element).destinationIndex});
                        }
                    }
                    --i;
                }
                for (ManipulationElement element3 : this.manipulations) {
                    if (element3.is(4)) {
                        moveStmt.setInt(3, element3.tempIndex);
                        moveStmt.setInt(1, element3.destinationIndex);
                        element3.tempIndex = tempIndex;
                        moveStmt.addBatch();
                        ++moveCounter;
                        if (TRACER.isEnabled()) {
                            TRACER.format(" - move {0} -> {1} ", new Object[]{element3.tempIndex, element3.destinationIndex});
                        }
                    }
                    if (element3.is(2)) {
                        if (setValueStmt == null) {
                            setValueStmt = accessor.getStatementCache().getPreparedStatement(this.sqlUpdateValue, IPreparedStatementCache.ReuseProbability.HIGH);
                            setValueStmt.setLong(2, longId);
                        }
                        setValueStmt.setInt(3, element3.destinationIndex);
                        this.getTypeMapping().setValue((PreparedStatement)setValueStmt, 1, element3.value);
                        setValueStmt.addBatch();
                        ++setValueCounter;
                        if (TRACER.isEnabled()) {
                            TRACER.format(" - set value at {0} to {1} ", new Object[]{element3.destinationIndex, element3.value});
                        }
                    }
                    if (!element3.is(8)) continue;
                    if (insertStmt == null) {
                        insertStmt = accessor.getStatementCache().getPreparedStatement(this.sqlInsertValue, IPreparedStatementCache.ReuseProbability.HIGH);
                        insertStmt.setLong(1, longId);
                    }
                    insertStmt.setInt(2, element3.destinationIndex);
                    this.getTypeMapping().setValue((PreparedStatement)insertStmt, 3, element3.value);
                    insertStmt.addBatch();
                    ++insertCounter;
                    if (!TRACER.isEnabled()) continue;
                    TRACER.format(" - insert value at {0} : value {1} ", new Object[]{element3.destinationIndex, element3.value});
                }
                if (deleteCounter > 0) {
                    int[] result;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Performing {0} delete operations", new Object[]{deleteCounter});
                    }
                    Assert.isTrue(((result = deleteStmt.executeBatch()).length == deleteCounter ? 1 : 0) != 0);
                    nArray = result;
                    n2 = result.length;
                    n = 0;
                    while (n < n2) {
                        int r = nArray[n];
                        Assert.isTrue((r == 1 ? 1 : 0) != 0);
                        ++n;
                    }
                }
                if (moveCounter > 0) {
                    int[] result;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Performing {0} move operations", new Object[]{moveCounter});
                    }
                    Assert.isTrue(((result = moveStmt.executeBatch()).length == moveCounter ? 1 : 0) != 0);
                    nArray = result;
                    n2 = result.length;
                    n = 0;
                    while (n < n2) {
                        int r = nArray[n];
                        Assert.isTrue((r == 1 ? 1 : 0) != 0);
                        ++n;
                    }
                }
                if (insertCounter > 0) {
                    int[] result;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Performing {0} insert operations", new Object[]{insertCounter});
                    }
                    Assert.isTrue(((result = insertStmt.executeBatch()).length == insertCounter ? 1 : 0) != 0);
                    nArray = result;
                    n2 = result.length;
                    n = 0;
                    while (n < n2) {
                        int r = nArray[n];
                        Assert.isTrue((r == 1 ? 1 : 0) != 0);
                        ++n;
                    }
                }
                if (setValueCounter > 0) {
                    int[] result;
                    if (TRACER.isEnabled()) {
                        TRACER.format("Performing {0} set operations", new Object[]{setValueCounter});
                    }
                    Assert.isTrue(((result = setValueStmt.executeBatch()).length == setValueCounter ? 1 : 0) != 0);
                    nArray = result;
                    n2 = result.length;
                    n = 0;
                    while (n < n2) {
                        int r = nArray[n];
                        Assert.isTrue((r == 1 ? 1 : 0) != 0);
                        ++n;
                    }
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.releaseStatement(accessor, new PreparedStatement[]{deleteStmt, moveStmt, insertStmt, setValueStmt});
            throw throwable;
        }
        this.releaseStatement(accessor, new PreparedStatement[]{deleteStmt, moveStmt, insertStmt, setValueStmt});
    }

    private void releaseStatement(IDBStoreAccessor accessor, PreparedStatement ... stmts) {
        Throwable t = null;
        PreparedStatement[] preparedStatementArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                PreparedStatement stmt = preparedStatementArray[n2];
                try {
                    if (stmt == null) break block10;
                    try {
                        try {
                            stmt.clearBatch();
                        }
                        catch (SQLException e) {
                            throw new DBException((Throwable)e);
                        }
                    }
                    finally {
                        accessor.getStatementCache().releasePreparedStatement(stmt);
                    }
                }
                catch (Throwable th) {
                    if (t == null) {
                        t = th;
                    }
                    OM.LOG.error(t);
                }
            }
            ++n2;
        }
        if (t != null) {
            throw new DBException(t);
        }
    }

    private void shiftIndexes(int from, int to, int offset) {
        for (ManipulationElement e : this.manipulations) {
            if (e.destinationIndex < from || to != -1 && e.destinationIndex > to) continue;
            e.destinationIndex += offset;
        }
    }

    private ManipulationElement findElement(int index) {
        for (ManipulationElement e : this.manipulations) {
            if (e.destinationIndex != index) continue;
            return e;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private void deleteItem(ManipulationElement e) {
        if (e.is(8)) {
            this.manipulations.remove(e);
        } else {
            e.type = 16;
            e.destinationIndex = Integer.MIN_VALUE;
        }
    }

    private ManipulationElement createOriginalElement(int index) {
        return new ManipulationElement(index, index, ManipulationConstants.NIL, 0);
    }

    private ManipulationElement createInsertedElement(int index, Object value) {
        return new ManipulationElement(0, index, value, 8);
    }

    private final class ListDeltaVisitor
    implements CDOFeatureDeltaVisitor {
        private ListDeltaVisitor() {
        }

        public void visit(CDOAddFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - insert at {0} value {1}", new Object[]{delta.getIndex(), delta.getValue()});
            }
            NonAuditListTableMapping.this.shiftIndexes(delta.getIndex(), -1, 1);
            NonAuditListTableMapping.this.manipulations.add(NonAuditListTableMapping.this.createInsertedElement(delta.getIndex(), delta.getValue()));
        }

        public void visit(CDORemoveFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - remove at {0}", new Object[]{delta.getIndex()});
            }
            ManipulationElement e = NonAuditListTableMapping.this.findElement(delta.getIndex());
            NonAuditListTableMapping.this.deleteItem(e);
            NonAuditListTableMapping.this.shiftIndexes(delta.getIndex() + 1, -1, -1);
        }

        public void visit(CDOSetFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - set at {0} value {1}", new Object[]{delta.getIndex(), delta.getValue()});
            }
            ManipulationElement e = NonAuditListTableMapping.this.findElement(delta.getIndex());
            e.value = delta.getValue();
            if (!e.is(8)) {
                e.addType(2);
            }
        }

        public void visit(CDOClearFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("  - clear list", new Object[0]);
            }
            NonAuditListTableMapping.this.clearFirst = true;
            NonAuditListTableMapping.this.manipulations.clear();
        }

        public void visit(CDOMoveFeatureDelta delta) {
            int fromIdx = delta.getOldPosition();
            int toIdx = delta.getNewPosition();
            if (TRACER.isEnabled()) {
                TRACER.format("  - move {0} -> {1}", new Object[]{fromIdx, toIdx});
            }
            if (fromIdx == toIdx) {
                return;
            }
            ManipulationElement e = NonAuditListTableMapping.this.findElement(fromIdx);
            if (fromIdx < toIdx) {
                NonAuditListTableMapping.this.shiftIndexes(fromIdx + 1, toIdx, -1);
            } else {
                NonAuditListTableMapping.this.shiftIndexes(toIdx, fromIdx - 1, 1);
            }
            e.destinationIndex = toIdx;
            if (!e.is(8)) {
                e.addType(4);
            }
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            if (delta.getFeature().isUnsettable()) {
                Assert.isTrue((boolean)false);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("  - unset list", new Object[0]);
            }
            NonAuditListTableMapping.this.clearFirst = true;
            NonAuditListTableMapping.this.manipulations.clear();
        }

        public void visit(CDOListFeatureDelta delta) {
            Assert.isTrue((boolean)false);
        }

        public void visit(CDOContainerFeatureDelta delta) {
            Assert.isTrue((boolean)false);
        }
    }

    private static final class ManipulationConstants {
        public static final int NO_INDEX = Integer.MIN_VALUE;
        public static final int DELETE = 16;
        public static final int INSERT = 8;
        public static final int MOVE = 4;
        public static final int SET_VALUE = 2;
        public static final Object NIL = new Object();
        public static final int NONE = 0;

        private ManipulationConstants() {
        }
    }

    private static final class ManipulationElement {
        public int type;
        public int sourceIndex;
        public int tempIndex;
        public int destinationIndex;
        public Object value;

        public ManipulationElement(int srcIdx, int dstIdx, Object val, int t) {
            this.sourceIndex = srcIdx;
            this.tempIndex = 0;
            this.destinationIndex = dstIdx;
            this.value = val;
            this.type = t;
        }

        public boolean is(int t) {
            return (this.type & t) > 0;
        }

        public void addType(int t) {
            this.type |= t;
        }
    }
}

