/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.IObjectTypeCache;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class ObjectTypeCache
extends Lifecycle
implements IObjectTypeCache {
    private static final String SQL_STATE_UNIQUE_KEY_VIOLATION = "23001";
    private IMappingStrategy mappingStrategy;
    private IDBTable table;
    private IDBField idField;
    private IDBField typeField;
    private IDBField timeField;
    private String sqlDelete;
    private String sqlInsert;
    private String sqlSelect;
    private IMetaDataManager metaDataManager;

    public IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(IMappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public final CDOClassifierRef getObjectType(IDBStoreAccessor accessor, CDOID id) {
        ResultSet resultSet;
        PreparedStatement stmt;
        IPreparedStatementCache statementCache;
        block5: {
            statementCache = accessor.getStatementCache();
            stmt = null;
            stmt = statementCache.getPreparedStatement(this.sqlSelect, IPreparedStatementCache.ReuseProbability.MAX);
            stmt.setLong(1, CDOIDUtil.getLong((CDOID)id));
            DBUtil.trace((String)stmt.toString());
            resultSet = stmt.executeQuery();
            if (resultSet.next()) break block5;
            DBUtil.trace((String)("ClassID for CDOID " + id + " not found"));
            statementCache.releasePreparedStatement(stmt);
            return null;
        }
        try {
            long classID = resultSet.getLong(1);
            EClass eClass = (EClass)this.metaDataManager.getMetaInstance(classID);
            CDOClassifierRef cDOClassifierRef = new CDOClassifierRef((EClassifier)eClass);
            statementCache.releasePreparedStatement(stmt);
            return cDOClassifierRef;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                statementCache.releasePreparedStatement(stmt);
                throw throwable;
            }
        }
    }

    public final void putObjectType(IDBStoreAccessor accessor, long timeStamp, CDOID id, EClass type) {
        block7: {
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = accessor.getStatementCache().getPreparedStatement(this.sqlInsert, IPreparedStatementCache.ReuseProbability.MAX);
                    stmt.setLong(1, CDOIDUtil.getLong((CDOID)id));
                    stmt.setLong(2, this.metaDataManager.getMetaID((EModelElement)type));
                    stmt.setLong(3, timeStamp);
                    DBUtil.trace((String)stmt.toString());
                    int result = stmt.executeUpdate();
                    if (result != 1) {
                        throw new DBException("Object type could not be inserted: " + id);
                    }
                }
                catch (SQLException ex) {
                    if (!SQL_STATE_UNIQUE_KEY_VIOLATION.equals(ex.getSQLState())) {
                        throw new DBException((Throwable)ex);
                    }
                    accessor.getStatementCache().releasePreparedStatement(stmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                accessor.getStatementCache().releasePreparedStatement(stmt);
                throw throwable;
            }
            accessor.getStatementCache().releasePreparedStatement(stmt);
        }
    }

    public final void removeObjectType(IDBStoreAccessor accessor, CDOID id) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlDelete, IPreparedStatementCache.ReuseProbability.MAX);
                stmt.setLong(1, CDOIDUtil.getLong((CDOID)id));
                DBUtil.trace((String)stmt.toString());
                int result = stmt.executeUpdate();
                if (result != 1) {
                    throw new DBException("Object type could not be deleted: " + id);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    public long getMaxID(Connection connection) {
        return DBUtil.selectMaximumLong((Connection)connection, (IDBField)this.idField, (String[])new String[0]);
    }

    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        String where = " WHERE " + this.timeField + " BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.table, null, (String)where);
    }

    public void rawImport(Connection connection, CDODataInput in) throws IOException {
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.table);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.mappingStrategy, "mappingStrategy");
    }

    protected void doActivate() throws Exception {
        this.metaDataManager = this.getMappingStrategy().getStore().getMetaDataManager();
        IDBSchema schema = this.mappingStrategy.getStore().getDBSchema();
        this.table = schema.addTable("cdo_objects");
        this.idField = this.table.addField("cdo_id", DBType.BIGINT);
        this.typeField = this.table.addField("cdo_class", DBType.BIGINT);
        this.timeField = this.table.addField("cdo_created", DBType.BIGINT);
        this.table.addIndex(IDBIndex.Type.UNIQUE, new IDBField[]{this.idField});
        IDBStoreAccessor writer = this.getMappingStrategy().getStore().getWriter(null);
        Connection connection = writer.getConnection();
        IDBAdapter dbAdapter = this.mappingStrategy.getStore().getDBAdapter();
        Statement statement = null;
        try {
            try {
                statement = connection.createStatement();
                dbAdapter.createTable(this.table, statement);
                connection.commit();
            }
            catch (SQLException ex) {
                connection.rollback();
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)statement);
            LifecycleUtil.deactivate((Object)writer);
        }
        this.sqlSelect = "SELECT " + this.typeField + " FROM " + this.table + " WHERE " + this.idField + "=?";
        this.sqlInsert = "INSERT INTO " + this.table + "(" + this.idField + "," + this.typeField + "," + this.timeField + ") VALUES (?, ?, ?)";
        this.sqlDelete = "DELETE FROM " + this.table + " WHERE " + this.idField + "=?";
    }

    protected void doDeactivate() throws Exception {
        this.table = null;
        this.idField = null;
        this.typeField = null;
        super.doDeactivate();
    }
}

