/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticationResult;
import org.eclipse.emf.cdo.server.IRepositoryProvider;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.AuthenticationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.BranchNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ChangeSubscriptionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ChangeViewIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CloseViewIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitDelegationIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitTransactionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitXATransactionCancelIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitXATransactionPhase1Indication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitXATransactionPhase2Indication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitXATransactionPhase3Indication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CreateBranchIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.DisablePassiveUpdateIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.GetRemoteSessionsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadBranchIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadBranchesIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadChangeSetsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadChunkIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadCommitDataIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadCommitInfosIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadMergeDataIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadPackagesIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadRevisionByVersionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadRevisionsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadSubBranchesIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LockObjectsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ObjectLockedIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.OpenSessionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.OpenViewIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.QueryCancelIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.QueryIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RefreshSessionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RemoteMessageIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RemoteMessageNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RemoteSessionNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ReplicateRepositoryIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ReplicateRepositoryRawIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RepositoryStateNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RepositoryTimeIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RepositoryTypeNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.SetPassiveUpdateModeIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.UnlockObjectsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.UnsubscribeRemoteSessionsIndication;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.util.io.StringCompressor;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOServerProtocol
extends SignalProtocol<InternalSession>
implements ISessionProtocol {
    public static final long DEFAULT_NEGOTIATION_TIMEOUT = 15000L;
    private long negotiationTimeout = 15000L;
    private IRepositoryProvider repositoryProvider;
    private StringIO packageURICompressor = StringCompressor.BYPASS ? StringIO.DIRECT : new StringCompressor(false);

    public CDOServerProtocol(IRepositoryProvider repositoryProvider) {
        super("cdo");
        this.repositoryProvider = repositoryProvider;
    }

    public InternalSession getSession() {
        return (InternalSession)this.getInfraStructure();
    }

    public IRepositoryProvider getRepositoryProvider() {
        return this.repositoryProvider;
    }

    public StringIO getPackageURICompressor() {
        return this.packageURICompressor;
    }

    public long getNegotiationTimeout() {
        return this.negotiationTimeout;
    }

    public void setNegotiationTimeout(long negotiationTimeout) {
        this.negotiationTimeout = negotiationTimeout;
    }

    public CDOAuthenticationResult sendAuthenticationChallenge(byte[] randomToken) throws Exception {
        return (CDOAuthenticationResult)new AuthenticationRequest(this, randomToken).send(this.negotiationTimeout);
    }

    public void sendRepositoryTypeNotification(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RepositoryTypeNotificationRequest(this, oldType, newType).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RepositoryStateNotificationRequest(this, oldState, newState).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    public void sendBranchNotification(InternalCDOBranch branch) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new BranchNotificationRequest(this, (CDOBranch)branch).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    public void sendCommitNotification(CDOCommitInfo commitInfo) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new CommitNotificationRequest(this, commitInfo).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    public void sendRemoteSessionNotification(InternalSession sender, byte opcode) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RemoteSessionNotificationRequest(this, sender, opcode).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    public void sendRemoteMessageNotification(InternalSession sender, CDORemoteSessionMessage message) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RemoteMessageNotificationRequest(this, sender, message).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    protected void handleInactiveSession() {
        OM.LOG.warn("Session channel is inactive: " + (Object)((Object)this));
    }

    protected SignalReactor createSignalReactor(short signalID) {
        switch (signalID) {
            case 1: {
                return new OpenSessionIndication(this);
            }
            case 3: {
                return new OpenViewIndication(this);
            }
            case 4: {
                return new ChangeViewIndication(this);
            }
            case 5: {
                return new CloseViewIndication(this);
            }
            case 6: {
                return new LoadPackagesIndication(this);
            }
            case 32: {
                return new CreateBranchIndication(this);
            }
            case 33: {
                return new LoadBranchIndication(this);
            }
            case 34: {
                return new LoadSubBranchesIndication(this);
            }
            case 35: {
                return new LoadBranchesIndication(this);
            }
            case 7: {
                return new LoadRevisionsIndication(this);
            }
            case 8: {
                return new LoadRevisionByVersionIndication(this);
            }
            case 9: {
                return new LoadChunkIndication(this);
            }
            case 11: {
                return new CommitTransactionIndication(this);
            }
            case 12: {
                return new CommitDelegationIndication(this);
            }
            case 13: {
                return new CommitXATransactionPhase1Indication(this);
            }
            case 14: {
                return new CommitXATransactionPhase2Indication(this);
            }
            case 15: {
                return new CommitXATransactionPhase3Indication(this);
            }
            case 16: {
                return new CommitXATransactionCancelIndication(this);
            }
            case 17: {
                return new QueryIndication(this);
            }
            case 18: {
                return new QueryCancelIndication(this);
            }
            case 19: {
                return new RefreshSessionIndication(this);
            }
            case 20: {
                return new DisablePassiveUpdateIndication(this);
            }
            case 21: {
                return new SetPassiveUpdateModeIndication(this);
            }
            case 22: {
                return new ChangeSubscriptionIndication(this);
            }
            case 23: {
                return new RepositoryTimeIndication(this);
            }
            case 24: {
                return new LockObjectsIndication(this);
            }
            case 25: {
                return new UnlockObjectsIndication(this);
            }
            case 26: {
                return new ObjectLockedIndication(this);
            }
            case 27: {
                return new GetRemoteSessionsIndication(this);
            }
            case 30: {
                return new UnsubscribeRemoteSessionsIndication(this);
            }
            case 28: {
                return new RemoteMessageIndication(this);
            }
            case 39: {
                return new LoadCommitInfosIndication(this);
            }
            case 40: {
                return new LoadCommitDataIndication(this);
            }
            case 41: {
                return new ReplicateRepositoryIndication(this);
            }
            case 42: {
                return new ReplicateRepositoryRawIndication(this);
            }
            case 43: {
                return new LoadChangeSetsIndication(this);
            }
            case 44: {
                return new LoadMergeDataIndication(this);
            }
        }
        return super.createSignalReactor(signalID);
    }
}

