/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.server.InternalView;

public class ChangeViewIndication
extends CDOReadIndication {
    private boolean[] existanceFlags;

    public ChangeViewIndication(CDOServerProtocol protocol) {
        super(protocol, (short)4);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        CDOBranchPoint branchPoint = in.readCDOBranchPoint();
        int size = in.readInt();
        ArrayList<CDOID> invalidObjects = new ArrayList<CDOID>(size);
        int i = 0;
        while (i < size) {
            CDOID id = in.readCDOID();
            invalidObjects.add(id);
            ++i;
        }
        InternalView view = this.getSession().getView(viewID);
        this.existanceFlags = view.changeTarget(branchPoint, invalidObjects);
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeInt(this.existanceFlags.length);
        int i = 0;
        while (i < this.existanceFlags.length) {
            out.writeBoolean(this.existanceFlags[i]);
            ++i;
        }
    }
}

