/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.internal.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.internal.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDOListImpl;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CommitTransactionIndication
extends IndicationWithMonitoring {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionIndication.class);
    protected InternalCommitContext commitContext;

    public CommitTransactionIndication(CDOServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)11);
    }

    protected CommitTransactionIndication(CDOServerProtocol protocol, short signalID) {
        super((SignalProtocol)protocol, signalID);
    }

    public CDOServerProtocol getProtocol() {
        return (CDOServerProtocol)super.getProtocol();
    }

    protected InternalSession getSession() {
        return this.getProtocol().getSession();
    }

    protected InternalRepository getRepository() {
        InternalRepository repository = this.getSession().getManager().getRepository();
        if (!LifecycleUtil.isActive((Object)repository)) {
            throw new IllegalStateException("CDORepositoryInfo has been deactivated");
        }
        return repository;
    }

    protected IStore getStore() {
        InternalStore store = this.getRepository().getStore();
        if (!LifecycleUtil.isActive((Object)store)) {
            throw new IllegalStateException("Store has been deactivated");
        }
        return store;
    }

    protected final void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
        this.indicating((CDODataInput)new CDODataInputImpl((ExtendedDataInput)in){

            protected CDOPackageRegistry getPackageRegistry() {
                return CommitTransactionIndication.this.commitContext.getPackageRegistry();
            }

            protected StringIO getPackageURICompressor() {
                return CommitTransactionIndication.this.getProtocol().getPackageURICompressor();
            }

            protected CDOBranchManager getBranchManager() {
                return CommitTransactionIndication.this.getRepository().getBranchManager();
            }

            protected CDOCommitInfoManager getCommitInfoManager() {
                return CommitTransactionIndication.this.getRepository().getCommitInfoManager();
            }

            protected CDORevisionFactory getRevisionFactory() {
                return CommitTransactionIndication.this.getRepository().getRevisionManager().getFactory();
            }

            protected CDOListFactory getListFactory() {
                return CDOListImpl.FACTORY;
            }
        }, monitor);
    }

    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        try {
            try {
                monitor.begin(10.0);
                this.indicatingCommit(in, monitor.fork(1.0));
                this.indicatingCommit(monitor.fork(9.0));
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void indicatingCommit(CDODataInput in, OMMonitor monitor) throws Exception {
        this.initializeCommitContext(in);
        this.commitContext.preWrite();
        boolean autoReleaseLocksEnabled = in.readBoolean();
        this.commitContext.setAutoReleaseLocksEnabled(autoReleaseLocksEnabled);
        String commitComment = in.readString();
        InternalCDOPackageUnit[] newPackageUnits = new InternalCDOPackageUnit[in.readInt()];
        InternalCDORevision[] newObjects = new InternalCDORevision[in.readInt()];
        InternalCDORevisionDelta[] dirtyObjectDeltas = new InternalCDORevisionDelta[in.readInt()];
        CDOID[] detachedObjects = new CDOID[in.readInt()];
        monitor.begin((double)(newPackageUnits.length + newObjects.length + dirtyObjectDeltas.length + detachedObjects.length));
        try {
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} new package units", new Object[]{newPackageUnits.length});
            }
            InternalCDOPackageRegistry packageRegistry = this.commitContext.getPackageRegistry();
            ResourceSet resourceSet = this.createResourceSet(packageRegistry);
            int i = 0;
            while (i < newPackageUnits.length) {
                newPackageUnits[i] = (InternalCDOPackageUnit)in.readCDOPackageUnit(resourceSet);
                packageRegistry.putPackageUnit(newPackageUnits[i]);
                monitor.worked();
                ++i;
            }
            EMFUtil.safeResolveAll((ResourceSet)resourceSet);
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} new objects", new Object[]{newObjects.length});
            }
            i = 0;
            while (i < newObjects.length) {
                newObjects[i] = (InternalCDORevision)in.readCDORevision();
                monitor.worked();
                ++i;
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} dirty object deltas", new Object[]{dirtyObjectDeltas.length});
            }
            i = 0;
            while (i < dirtyObjectDeltas.length) {
                dirtyObjectDeltas[i] = (InternalCDORevisionDelta)in.readCDORevisionDelta();
                monitor.worked();
                ++i;
            }
            HashMap<CDOID, EClass> detachedObjectTypes = null;
            InternalRepository repository = this.getRepository();
            if (repository instanceof Repository && ((Repository)repository).isEnsuringReferentialIntegrity()) {
                detachedObjectTypes = new HashMap<CDOID, EClass>();
            }
            int i2 = 0;
            while (i2 < detachedObjects.length) {
                CDOID id;
                detachedObjects[i2] = id = in.readCDOID();
                if (detachedObjectTypes != null) {
                    EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
                    detachedObjectTypes.put(id, eClass);
                }
                monitor.worked();
                ++i2;
            }
            if (detachedObjectTypes != null && detachedObjectTypes.isEmpty()) {
                detachedObjectTypes = null;
            }
            this.commitContext.setNewPackageUnits(newPackageUnits);
            this.commitContext.setNewObjects(newObjects);
            this.commitContext.setDirtyObjectDeltas(dirtyObjectDeltas);
            this.commitContext.setDetachedObjects(detachedObjects);
            if (this.commitContext instanceof TransactionCommitContext) {
                ((TransactionCommitContext)this.commitContext).setDetachedObjectTypes(detachedObjectTypes);
            }
            this.commitContext.setCommitComment(commitComment);
        }
        finally {
            monitor.done();
        }
    }

    private ResourceSet createResourceSet(InternalCDOPackageRegistry packageRegistry) {
        ResourceSetImpl resourceSet = new ResourceSetImpl(){

            protected void demandLoad(Resource resource) throws IOException {
            }
        };
        EcoreResourceFactoryImpl resourceFactory = new EcoreResourceFactoryImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", resourceFactory);
        resourceSet.setPackageRegistry((EPackage.Registry)packageRegistry);
        return resourceSet;
    }

    protected void initializeCommitContext(CDODataInput in) throws Exception {
        int viewID = in.readInt();
        this.commitContext = this.getTransaction(viewID).createCommitContext();
    }

    protected void indicatingCommit(OMMonitor monitor) {
        ProgressDistributor distributor = this.getStore().getIndicatingCommitDistributor();
        distributor.run(InternalCommitContext.OPS, (Object)this.commitContext, monitor);
    }

    protected final void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
        this.responding((CDODataOutput)new CDODataOutputImpl((ExtendedDataOutput)out){

            public CDOPackageRegistry getPackageRegistry() {
                return CommitTransactionIndication.this.commitContext.getPackageRegistry();
            }

            public CDOIDProvider getIDProvider() {
                return CommitTransactionIndication.this.getSession();
            }

            protected StringIO getPackageURICompressor() {
                return CommitTransactionIndication.this.getProtocol().getPackageURICompressor();
            }
        }, monitor);
    }

    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        boolean success = false;
        try {
            success = this.respondingException(out, this.commitContext.getRollbackMessage());
            if (success) {
                this.respondingResult(out);
                this.respondingMappingNewPackages(out);
                this.respondingMappingNewObjects(out);
            }
        }
        finally {
            this.commitContext.postCommit(success);
        }
    }

    protected boolean respondingException(CDODataOutput out, String rollbackMessage) throws Exception {
        boolean success = rollbackMessage == null;
        out.writeBoolean(success);
        if (!success) {
            out.writeString(rollbackMessage);
        }
        return success;
    }

    protected void respondingResult(CDODataOutput out) throws Exception {
        out.writeCDOBranchPoint(this.commitContext.getBranchPoint());
    }

    protected void respondingMappingNewPackages(CDODataOutput out) throws Exception {
        List metaRanges = this.commitContext.getMetaIDRanges();
        for (CDOIDMetaRange metaRange : metaRanges) {
            out.writeCDOIDMetaRange(metaRange);
        }
    }

    protected void respondingMappingNewObjects(CDODataOutput out) throws Exception {
        Map idMappings = this.commitContext.getIDMappings();
        for (Map.Entry entry : idMappings.entrySet()) {
            CDOID oldID = (CDOID)entry.getKey();
            if (oldID.isMeta()) continue;
            CDOID newID = (CDOID)entry.getValue();
            out.writeCDOID(oldID);
            out.writeCDOID(newID);
        }
        out.writeCDOID(CDOID.NULL);
    }

    protected InternalTransaction getTransaction(int viewID) {
        InternalView view = this.getSession().getView(viewID);
        if (view instanceof InternalTransaction) {
            return (InternalTransaction)view;
        }
        throw new IllegalStateException("Illegal transaction: " + view);
    }
}

