/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;

public class CreateBranchIndication
extends CDOReadIndication {
    private int branchID;
    private InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo;

    public CreateBranchIndication(CDOServerProtocol protocol) {
        super(protocol, (short)32);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.branchID = in.readInt();
        this.branchInfo = new InternalCDOBranchManager.BranchLoader.BranchInfo(in);
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        InternalCDOBranch baseBranch = branchManager.getBranch(this.branchInfo.getBaseBranchID());
        InternalCDOBranch branch = branchManager.createBranch(this.branchID, this.branchInfo.getName(), baseBranch, this.branchInfo.getBaseTimeStamp());
        out.writeInt(branch.getID());
        InternalSessionManager sessionManager = this.getRepository().getSessionManager();
        sessionManager.sendBranchNotification(this.getSession(), branch);
    }
}

