/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class GetRemoteSessionsIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, GetRemoteSessionsIndication.class);
    private boolean subscribe;

    public GetRemoteSessionsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)27);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.subscribe = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read subscribe: {0}", new Object[]{this.subscribe});
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalSession[] sessions;
        InternalSession localSession = this.getSession();
        InternalSession[] internalSessionArray = sessions = this.getSession().getManager().getSessions();
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            InternalSession session = internalSessionArray[n2];
            if (session != localSession) {
                out.writeInt(session.getSessionID());
                out.writeString(session.getUserID());
                out.writeBoolean(session.isSubscribed());
            }
            ++n2;
        }
        out.writeInt(-1);
        localSession.setSubscribed(this.subscribe);
    }
}

