/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.server.InternalRepository;

public class LoadChangeSetsIndication
extends CDOReadIndication {
    private CDOBranchPointRange[] ranges;

    public LoadChangeSetsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)43);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int size = in.readInt();
        this.ranges = new CDOBranchPointRange[size];
        int i = 0;
        while (i < this.ranges.length) {
            CDOBranchPoint startPoint = in.readCDOBranchPoint();
            CDOBranchPoint endPoint = in.readCDOBranchPoint();
            this.ranges[i] = CDOBranchUtil.createRange((CDOBranchPoint)startPoint, (CDOBranchPoint)endPoint);
            ++i;
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalRepository repository = this.getRepository();
        CDOBranchPointRange[] cDOBranchPointRangeArray = this.ranges;
        int n = this.ranges.length;
        int n2 = 0;
        while (n2 < n) {
            CDOBranchPointRange range = cDOBranchPointRangeArray[n2];
            CDOBranchPoint startPoint = range.getStartPoint();
            CDOBranchPoint endPoint = range.getEndPoint();
            CDOChangeSetData data = repository.getChangeSet(startPoint, endPoint);
            out.writeCDOChangeSetData(data);
            ++n2;
        }
    }
}

