/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.server.InternalRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadMergeDataIndication
extends CDOReadIndication {
    private CDORevisionAvailabilityInfo ancestorInfo;
    private CDORevisionAvailabilityInfo targetInfo;
    private CDORevisionAvailabilityInfo sourceInfo;

    public LoadMergeDataIndication(CDOServerProtocol protocol) {
        super(protocol, (short)44);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.ancestorInfo = this.readRevisionAvailabilityInfo(in);
        this.targetInfo = this.readRevisionAvailabilityInfo(in);
        this.sourceInfo = this.readRevisionAvailabilityInfo(in);
    }

    private CDORevisionAvailabilityInfo readRevisionAvailabilityInfo(CDODataInput in) throws IOException {
        CDOBranchPoint branchPoint = in.readCDOBranchPoint();
        CDORevisionAvailabilityInfo info = new CDORevisionAvailabilityInfo(branchPoint);
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            CDOID id = in.readCDOID();
            info.getAvailableRevisions().put(id, null);
            ++i;
        }
        return info;
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        InternalRepository repository = this.getRepository();
        Set ids = repository.getMergeData(this.ancestorInfo, this.targetInfo, this.sourceInfo);
        out.writeInt(ids.size());
        for (CDOID id : ids) {
            out.writeCDOID(id);
        }
        HashSet<CDORevisionKey> writtenRevisions = new HashSet<CDORevisionKey>();
        this.writeRevisionAvailabilityInfo(out, this.ancestorInfo, writtenRevisions);
        this.writeRevisionAvailabilityInfo(out, this.targetInfo, writtenRevisions);
        this.writeRevisionAvailabilityInfo(out, this.sourceInfo, writtenRevisions);
    }

    private void writeRevisionAvailabilityInfo(CDODataOutput out, CDORevisionAvailabilityInfo info, Set<CDORevisionKey> writtenRevisions) throws IOException {
        Collection revisions = info.getAvailableRevisions().values();
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            CDORevisionKey key = (CDORevisionKey)it.next();
            if (key != null) continue;
            it.remove();
        }
        out.writeInt(revisions.size());
        for (CDORevisionKey revision : revisions) {
            CDORevisionKey key = CDORevisionUtil.createRevisionKey((CDORevisionKey)revision);
            if (writtenRevisions.add(key)) {
                out.writeBoolean(true);
                out.writeCDORevision((CDORevision)revision, -1);
                continue;
            }
            out.writeBoolean(false);
            out.writeCDORevisionKey(key);
        }
    }
}

