/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadRevisionByVersionIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionByVersionIndication.class);
    private CDOID id;
    private CDOBranchVersion branchVersion;
    private int referenceChunk;

    public LoadRevisionByVersionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)8);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.id = in.readCDOID();
        if (TRACER.isEnabled()) {
            TRACER.format("Read id: {0}", new Object[]{this.id});
        }
        this.branchVersion = in.readCDOBranchVersion();
        if (TRACER.isEnabled()) {
            TRACER.format("Read branchVersion: {0}", new Object[]{this.branchVersion});
        }
        this.referenceChunk = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read referenceChunk: {0}", new Object[]{this.referenceChunk});
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalCDORevisionManager revisionManager = this.getRepository().getRevisionManager();
        InternalCDORevision revision = revisionManager.getRevisionByVersion(this.id, this.branchVersion, this.referenceChunk, true);
        RevisionInfo.writeResult((CDODataOutput)out, (int)this.referenceChunk, (InternalCDORevision)revision);
    }
}

