/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RefreshSessionIndication;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public class LockObjectsIndication
extends RefreshSessionIndication {
    private List<Object> objectsToBeLocked = new ArrayList<Object>();
    private IView view;
    private IRWLockManager.LockType lockType;

    public LockObjectsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)24);
    }

    protected void indicating(CDODataInput in) throws IOException {
        super.indicating(in);
        int viewID = in.readInt();
        this.lockType = in.readCDOLockType();
        long timeout = in.readLong();
        this.view = this.getSession().getView(viewID);
        InternalLockManager lockManager = this.getRepository().getLockManager();
        try {
            lockManager.lock(this.lockType, (Object)this.view, this.objectsToBeLocked, timeout);
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    protected CDORevisionKey handleViewedRevision(CDOBranch branch, CDORevisionKey revision) {
        if (this.getRepository().isSupportingBranches()) {
            this.objectsToBeLocked.add(CDOIDUtil.createIDAndBranch((CDOID)revision.getID(), (CDOBranch)branch));
        } else {
            this.objectsToBeLocked.add(revision.getID());
        }
        return revision;
    }

    protected void writeDetachedObject(CDODataOutput out, CDORevisionKey key) throws IOException {
        this.getRepository().getLockManager().unlock(this.lockType, (Object)this.view, this.objectsToBeLocked);
        throw new IllegalArgumentException("Object has been detached: " + key);
    }

    protected void respondingDone() {
    }
}

