/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class QueryCancelIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, QueryCancelIndication.class);
    private int queryID;

    public QueryCancelIndication(CDOServerProtocol protocol) {
        super(protocol, (short)18);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.queryID = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.trace("Query " + this.queryID + " will be cancelled");
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        try {
            this.getRepository().getQueryManager().cancel(this.queryID);
            out.writeBoolean(false);
        }
        catch (Exception exception) {
            out.writeBoolean(true);
            out.writeString(exception.getMessage());
        }
    }
}

