/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.internal.common.CDOQueryInfoImpl;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.server.InternalQueryManager;
import org.eclipse.emf.cdo.spi.server.InternalQueryResult;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class QueryIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, QueryIndication.class);
    private boolean xrefs;
    private InternalQueryResult queryResult;

    public QueryIndication(CDOServerProtocol protocol) {
        super(protocol, (short)17);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        InternalView view = this.getSession().getView(viewID);
        CDOQueryInfoImpl queryInfo = new CDOQueryInfoImpl(in);
        this.xrefs = queryInfo.getQueryLanguage().equals("xrefs");
        InternalQueryManager queryManager = this.getRepository().getQueryManager();
        this.queryResult = queryManager.execute(view, (CDOQueryInfo)queryInfo);
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeInt(this.queryResult.getQueryID());
        this.flush();
        int numberOfResults = 0;
        while (this.queryResult.hasNext()) {
            Object object = this.queryResult.next();
            ++numberOfResults;
            out.writeBoolean(true);
            if (this.xrefs) {
                Object[] values = (Object[])object;
                CDOID targetID = (CDOID)values[0];
                CDOID sourceID = (CDOID)values[1];
                EReference sourceReference = (EReference)values[2];
                int sourceIndex = (Integer)values[3];
                out.writeCDOID(targetID);
                out.writeCDOID(sourceID);
                out.writeCDOClassifierRef((EClassifier)sourceReference.eClass());
                out.writeString(sourceReference.getName());
                out.writeInt(sourceIndex);
            } else {
                out.writeCDORevisionOrPrimitive(object);
            }
            if (this.queryResult.peek() != null) continue;
            this.flush();
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Query returned " + numberOfResults + " results");
        }
        out.writeBoolean(false);
    }
}

