/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity;

import com.objy.db.app.Connection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStoreAccessor;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.clustering.ObjyPlacementManager;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyCommitInfoHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyConnection;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyPackageHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyPropertyMapHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyScope;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySession;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyStoreInfo;
import org.eclipse.emf.cdo.server.objectivity.IObjectivityStore;
import org.eclipse.emf.cdo.server.objectivity.IObjectivityStoreConfig;
import org.eclipse.emf.cdo.spi.server.LongIDStore;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectivityStore
extends Store
implements IObjectivityStore {
    public static final String TYPE = "objectivity";
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjectivityStore.class);
    protected ConcurrentLinkedQueue<ObjectivityStoreAccessor> writers = new ConcurrentLinkedQueue();
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool readerPool = new StoreAccessorPool((IStore)this, null);
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool writerPool = new StoreAccessorPool((IStore)this, null);
    private ObjyConnection objyConnection = null;
    private IObjectivityStoreConfig storeConfig = null;
    private boolean firstTime = false;
    private int nActivate = 0;
    private boolean requiredToSupportAudits;
    private boolean requiredToSupportBranches;
    private ObjyCommitInfoHandler objyCommitInfoHandler = null;
    private ObjyPropertyMapHandler objyPropertyMapHandler = null;
    private ObjyPackageHandler objyPackageHandler = null;
    private boolean storeInitialized = false;
    private long creationTime = 0L;

    public ObjectivityStore(IObjectivityStoreConfig config) {
        super(TYPE, LongIDStore.OBJECT_ID_TYPES, ObjectivityStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION, IStore.ChangeFormat.DELTA}), ObjectivityStore.set((Object[])new IStore.RevisionTemporality[]{IStore.RevisionTemporality.NONE, IStore.RevisionTemporality.AUDITING}), ObjectivityStore.set((Object[])new IStore.RevisionParallelism[]{IStore.RevisionParallelism.NONE, IStore.RevisionParallelism.BRANCHING}));
        this.storeConfig = config;
    }

    private void initStore() {
        this.objyConnection = ObjyConnection.INSTANCE;
        this.objyConnection.setSessionMinCacheSize(this.storeConfig.getSessionMinCacheSize());
        this.objyConnection.setSessionMaxCacheSize(this.storeConfig.getSessionMaxCacheSize());
        this.objyConnection.connect(this.storeConfig.getFdName());
        Connection.current().setUserClassLoader(this.getClass().getClassLoader());
        this.objyConnection.registerClass("org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyStoreInfo");
        this.objyConnection.registerClass("org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyPackageInfo");
        this.objyConnection.registerClass("org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyPackageUnit");
        this.objyConnection.registerClass("org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyCommitInfo");
        this.objyConnection.registerClass("org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyProperty");
        ObjySession objySession = this.objyConnection.getWriteSessionFromPool("Main");
        objySession.setRecoveryAutomatic(true);
        objySession.begin();
        ObjySchema.createBaseSchema();
        try {
            try {
                String repositoryName = this.getRepository().getName();
                ObjyScope objyScope = new ObjyScope(repositoryName, "_ooDefaultContObj");
                ObjyStoreInfo objyStoreInfo = null;
                try {
                    objyStoreInfo = (ObjyStoreInfo)objyScope.lookupObject("ObjyStoreInfo");
                    this.creationTime = objyStoreInfo.getCreationTime();
                }
                catch (Exception ex) {
                    objyStoreInfo = new ObjyStoreInfo(System.currentTimeMillis(), "...");
                    objyScope.getContainerObj().cluster((Object)objyStoreInfo);
                    objyScope.nameObj("ObjyStoreInfo", objyStoreInfo);
                    this.firstTime = true;
                }
                this.creationTime = objyStoreInfo.getCreationTime();
                this.objyCommitInfoHandler = new ObjyCommitInfoHandler(repositoryName);
                this.objyPropertyMapHandler = new ObjyPropertyMapHandler(repositoryName);
                this.objyPackageHandler = new ObjyPackageHandler(repositoryName);
                objySession.commit();
                this.storeInitialized = true;
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                objySession.abort();
                this.objyConnection.returnSessionToPool(objySession);
            }
        }
        finally {
            this.objyConnection.returnSessionToPool(objySession);
        }
    }

    protected IStoreAccessor createReader(ISession session) {
        return new ObjectivityStoreAccessor(this, session);
    }

    protected IStoreAccessor createWriter(ITransaction transaction) {
        return new ObjectivityStoreAccessor(this, transaction);
    }

    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return this.readerPool;
    }

    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return this.writerPool;
    }

    public CDOID createObjectID(String val) {
        Long id = Long.valueOf(val);
        return CDOIDUtil.createLong((long)id);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public ObjyConnection getConnection() {
        return this.objyConnection;
    }

    public boolean isRequiredToSupportAudits() {
        return this.requiredToSupportAudits;
    }

    public boolean isRequiredToSupportBranches() {
        return this.requiredToSupportBranches;
    }

    protected void doBeforeActivate() {
        this.requiredToSupportAudits = this.getRepository().isSupportingAudits();
        this.requiredToSupportBranches = this.getRepository().isSupportingBranches();
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (!this.storeInitialized) {
            this.initStore();
        }
        ++this.nActivate;
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("doActivate - count: " + this.nActivate);
        }
        ObjySession objySession = this.objyConnection.getWriteSessionFromPool("Main");
        objySession.setRecoveryAutomatic(true);
        objySession.begin();
        try {
            try {
                if (!objySession.getFD().hasDB(this.getRepository().getName())) {
                    ObjyScope.insureScopeExist(objySession, this.getRepository().getName(), "_ooDefaultContObj");
                }
                objySession.commit();
            }
            catch (RuntimeException ex) {
                objySession.abort();
                this.objyConnection.returnSessionToPool(objySession);
            }
        }
        finally {
            this.objyConnection.returnSessionToPool(objySession);
        }
    }

    protected void doDeactivate() throws Exception {
        try {
            ObjySchema.resetCache();
        }
        finally {
            ObjyConnection.INSTANCE.disconnect();
        }
        super.doDeactivate();
    }

    public Map<String, String> getPropertyValues(Set<String> names) {
        ObjySession objySession = this.objyConnection.getReadSessionFromPool("Main");
        objySession.begin();
        Map<String, String> properties = this.objyPropertyMapHandler.getPropertyValues(names);
        objySession.commit();
        return properties;
    }

    public void setPropertyValues(Map<String, String> properties) {
        ObjySession objySession = this.objyConnection.getWriteSessionFromPool("Main");
        objySession.begin();
        this.objyPropertyMapHandler.setPropertyValues(properties);
        objySession.commit();
    }

    public void removePropertyValues(Set<String> names) {
        ObjySession objySession = this.objyConnection.getWriteSessionFromPool("Main");
        objySession.begin();
        this.objyPropertyMapHandler.removePropertyValues(names);
        objySession.commit();
    }

    public ObjyCommitInfoHandler getCommitInfoHandler() {
        return this.objyCommitInfoHandler;
    }

    public ObjyPackageHandler getPackageHandler() {
        return this.objyPackageHandler;
    }

    public ObjyPlacementManager getGlobalPlacementManager() {
        return ObjyConnection.INSTANCE.getDefaultPlacementManager();
    }
}

