/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity;

import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityFeatureDeltaWriter;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityQueryHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStore;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.clustering.ObjyPlacementManagerLocal;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyCommitInfoHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObjectManager;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyPackageHandler;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySession;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBranch;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBranchManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyCommitInfo;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyResourceList;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.OBJYCDOIDUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.SmartLock;
import org.eclipse.emf.cdo.server.objectivity.IObjectivityStoreAccessor;
import org.eclipse.emf.cdo.server.objectivity.IObjectivityStoreChunkReader;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectivityStoreAccessor
extends StoreAccessor
implements IObjectivityStoreAccessor {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjectivityStoreAccessor.class);
    private static final ContextTracer TRACER_ERROR = new ContextTracer(OM.ERROR, ObjectivityStoreAccessor.class);
    private static final ContextTracer TRACER_INFO = new ContextTracer(OM.INFO, ObjectivityStoreAccessor.class);
    protected ObjySession objySession = null;
    protected boolean isRead = false;
    protected int sessionID = 0;
    boolean zipped = true;

    protected ObjectivityStoreAccessor(ObjectivityStore store, ISession cdoSession) {
        super((Store)store, cdoSession);
        this.isRead = true;
        if (cdoSession != null) {
            this.sessionID = cdoSession.getSessionID();
        }
    }

    public ObjectivityStoreAccessor(ObjectivityStore store, ITransaction transaction) {
        super((Store)store, transaction);
        if (transaction != null) {
            this.sessionID = transaction.getSession().getSessionID();
        }
    }

    protected void detachObjects(CDOID[] detachedObjects, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        this.ensureSessionBegin();
        try {
            monitor.begin((double)detachedObjects.length);
            HashSet<ooId> containerToLocks = new HashSet<ooId>();
            CDOID[] cDOIDArray = detachedObjects;
            int n = detachedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                CDOID id = cDOIDArray[n2];
                ooId containerID = OBJYCDOIDUtil.getContainerId(id);
                containerToLocks.add(containerID);
                ++n2;
            }
            this.lockContainers(containerToLocks);
            InternalCDORevisionManager revisionManager = this.getStore().getRepository().getRevisionManager();
            CDOID[] cDOIDArray2 = detachedObjects;
            int n3 = detachedObjects.length;
            n = 0;
            while (n < n3) {
                CDOID id = cDOIDArray2[n];
                InternalCDORevision revision = revisionManager.getRevision(id, branch.getHead(), -1, 0, true);
                int version = ObjectUtil.equals((Object)branch, (Object)revision.getBranch()) ? revision.getVersion() : 1;
                this.detachObject(id, version, branch, timeStamp);
                ++n;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void detachObject(CDOID id, int version, CDOBranch branch, long timeStamp) {
        this.ensureSessionBegin();
        ObjyObject objyObject = this.getObject(id);
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Detaching id " + objyObject.ooId().getStoreString());
        }
        if (this.getStore().isRequiredToSupportAudits() || this.getStore().isRequiredToSupportBranches()) {
            ObjyObject objyRevision = objyObject.getRevisionByVersion(version);
            objyRevision.setRevisedTime(timeStamp - 1L);
            objyObject.detach(version, branch, timeStamp);
        } else {
            objyObject.setVersion(-version);
            objyObject.delete(this, this.objySession.getObjectManager());
        }
        this.objySession.getObjectManager().remove(objyObject);
    }

    protected void doActivate() throws Exception {
    }

    private void getObjySession() {
        if (this.objySession != null) {
            return;
        }
        String sessionName = "Session_" + this.sessionID;
        if (this.isRead && this.objySession == null) {
            this.objySession = this.getStore().getConnection().getReadSessionFromPool(sessionName);
        } else if (this.objySession == null) {
            this.objySession = this.getStore().getConnection().getWriteSessionFromPool(sessionName);
        }
        if (!this.objySession.isOpen()) {
            this.objySession.setMrowMode(8);
            this.objySession.setWaitOption(45000);
            this.objySession.setAllowUnregisterableTypes(true);
            this.objySession.begin();
        }
    }

    private void returnObjySession() {
        this.ensureSessionJoin();
        if (this.objySession == null) {
            return;
        }
        if (this.objySession.isOpen()) {
            this.objySession.commit();
        }
        this.getStore().getConnection().returnSessionToPool(this.objySession);
        this.objySession = null;
    }

    protected void doDeactivate() throws Exception {
        this.returnObjySession();
    }

    protected void doPassivate() throws Exception {
        this.returnObjySession();
    }

    protected void doUnpassivate() throws Exception {
        this.getObjySession();
    }

    protected void rollback(IStoreAccessor.CommitContext commitContext) {
        try {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Rollback session " + (Object)((Object)this.objySession));
            }
            this.ensureSessionJoin();
            if (this.objySession.isOpen()) {
                this.objySession.abort();
                if (TRACER_DEBUG.isEnabled()) {
                    TRACER_DEBUG.trace("OBJY: session aborted - Session: " + (Object)((Object)this.objySession) + " - open:" + this.objySession.isOpen());
                }
            }
        }
        catch (RuntimeException exception) {
            TRACER_INFO.trace(exception.getMessage(), (Throwable)exception);
            exception.printStackTrace();
            throw exception;
        }
    }

    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, CDOBranch branch, long created, OMMonitor monitor) {
        this.ensureSessionBegin();
        try {
            monitor.begin((double)revisionDeltas.length);
            HashSet<ooId> containerToLocks = new HashSet<ooId>();
            InternalCDORevisionDelta[] internalCDORevisionDeltaArray = revisionDeltas;
            int n = revisionDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevisionDelta delta = internalCDORevisionDeltaArray[n2];
                ooId containerID = OBJYCDOIDUtil.getContainerId(delta.getID());
                containerToLocks.add(containerID);
                ++n2;
            }
            this.lockContainers(containerToLocks);
            internalCDORevisionDeltaArray = revisionDeltas;
            n = revisionDeltas.length;
            n2 = 0;
            while (n2 < n) {
                InternalCDORevisionDelta revisionDelta = internalCDORevisionDeltaArray[n2];
                this.writeRevisionDelta(revisionDelta, branch, created);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void writeRevisionDelta(InternalCDORevisionDelta delta, CDOBranch branch, long created) {
        this.ensureSessionBegin();
        int deltaVersion = delta.getVersion();
        ObjyObject objyObject = this.getObject(delta.getID());
        ObjyObject objyRevision = objyObject.getRevisionByVersion(deltaVersion);
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("Writing revision delta: {0}, v:{1} - OID:{2}, v: {3}", new Object[]{delta, deltaVersion, objyObject.ooId().getStoreString(), objyRevision.getVersion()});
            TRACER_DEBUG.format("... delta branch ID: {0} - revision branch ID: {1}", new Object[]{branch.getID(), objyRevision.getBranchId()});
        }
        if (objyRevision.getVersion() != deltaVersion) {
            throw new RuntimeException("ObjecitivityStoreAccessor : Dirty write");
        }
        ObjyObject newObjyRevision = null;
        if (this.getStore().isRequiredToSupportAudits()) {
            objyRevision.setRevisedTime(branch.getPoint(created).getTimeStamp() - 1L);
            InternalCDORevision originalRevision = this.getStore().getRepository().getRevisionManager().getRevisionByVersion(delta.getID(), (CDOBranchVersion)delta, 0, true);
            InternalCDORevision newRevision = originalRevision.copy();
            newRevision.setVersion(deltaVersion + 1);
            newRevision.setBranchPoint(delta.getBranch().getPoint(created));
            newObjyRevision = this.objySession.getObjectManager().newObject(newRevision.getEClass(), objyRevision.ooId());
            newObjyRevision.update(this, newRevision);
            objyObject.addToRevisions(newObjyRevision);
            if (this.getStore().isRequiredToSupportBranches()) {
                ObjyBranch objyBranch = this.objySession.getBranchManager(this.getRepositoryName()).getBranch(branch.getID());
                ooObj anObj = ooObj.create_ooObj((ooId)newObjyRevision.ooId());
                objyBranch.addRevision(anObj);
            }
        } else {
            newObjyRevision = objyRevision;
        }
        ObjectivityFeatureDeltaWriter visitor = new ObjectivityFeatureDeltaWriter(newObjyRevision);
        delta.accept((CDOFeatureDeltaVisitor)visitor);
        newObjyRevision.setCreationTime(branch.getPoint(created).getTimeStamp());
        newObjyRevision.setVersion(deltaVersion + 1);
    }

    @Override
    public ObjectivityStore getStore() {
        return (ObjectivityStore)super.getStore();
    }

    protected void writeRevisions(InternalCDORevision[] revisions, CDOBranch branch, OMMonitor monitor) {
        long start = System.currentTimeMillis();
        this.ensureSessionBegin();
        try {
            InternalCDORevision revision;
            monitor.begin((double)revisions.length);
            HashSet<ooId> containersToLock = new HashSet<ooId>();
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                revision = internalCDORevisionArray[n2];
                ooId containerID = OBJYCDOIDUtil.getContainerId(revision.getID());
                containersToLock.add(containerID);
                ++n2;
            }
            internalCDORevisionArray = revisions;
            n = revisions.length;
            n2 = 0;
            while (n2 < n) {
                revision = internalCDORevisionArray[n2];
                this.writeRevision(revision, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("\t writeRevisions time: " + (System.currentTimeMillis() - start));
        }
    }

    @Override
    public ObjyObject getObject(CDOID cdoId) {
        return this.objySession.getObjectManager().getObject(cdoId);
    }

    private void lockContainers(Set<ooId> containerToLocks) {
        if (!containerToLocks.isEmpty()) {
            ooId[] idsToLock = containerToLocks.toArray(new ooId[containerToLocks.size()]);
            while (true) {
                try {
                    this.objySession.openContainers(idsToLock, 2);
                }
                catch (Exception e) {
                    TRACER_INFO.trace("Locking problem try again : " + e.getMessage());
                    if (this.objySession.isOpen()) continue;
                    TRACER_INFO.trace("Objy session is not open");
                    continue;
                }
                break;
            }
        }
    }

    private void writeRevision(InternalCDORevision revision, OMMonitor fork) {
        ObjyObject objyObject = this.getObject(revision.getID());
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("Writing revision: {0} - OID: {1}", new Object[]{revision, objyObject.ooId().getStoreString()});
        }
        ObjyObject newObjyRevision = objyObject;
        if (revision.getVersion() > 1) {
            ObjyObject oldObjyRevision = objyObject.getRevisionByVersion(revision.getVersion() - 1);
            if (oldObjyRevision == null) {
                new IllegalStateException("Revision with version: " + (revision.getVersion() - 1) + " is not in the store.");
            }
            if (this.getStore().isRequiredToSupportAudits()) {
                newObjyRevision = this.objySession.getObjectManager().newObject(revision.getEClass(), oldObjyRevision.ooId());
                objyObject.addToRevisions(newObjyRevision);
            } else {
                newObjyRevision = oldObjyRevision;
            }
        }
        if (this.getStore().isRequiredToSupportBranches()) {
            ObjyBranch objyBranch = this.objySession.getBranchManager(this.getRepositoryName()).getBranch(revision.getBranch().getID());
            ooObj anObj = ooObj.create_ooObj((ooId)newObjyRevision.ooId());
            objyBranch.addRevision(anObj);
        }
        newObjyRevision.update(this, revision);
        if (revision.isResourceNode()) {
            ObjyResourceList resourceList = this.objySession.getResourceList(this.getRepositoryName());
            if (revision.isResourceFolder() || revision.isResource()) {
                resourceList.checkDuplicateResources(this, revision);
            }
            SmartLock.lock(newObjyRevision);
            resourceList.add(newObjyRevision);
        }
    }

    protected void doCommit(OMMonitor monitor) {
        long start = System.currentTimeMillis();
        try {
            this.ensureSessionJoin();
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Committing ..." + (Object)((Object)this.objySession) + " nc:" + this.objySession.nestCount());
            }
            if (this.objySession.isOpen()) {
                this.objySession.commit();
            } else {
                TRACER_DEBUG.trace("Error: calling objySession.commit() without having an open trx.");
            }
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Committed");
            }
        }
        catch (RuntimeException exception) {
            TRACER_ERROR.trace(exception.getMessage(), (Throwable)exception);
            exception.printStackTrace();
            throw exception;
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("\t commit time: " + (System.currentTimeMillis() - start));
        }
    }

    @Override
    public IObjectivityStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new ObjectivityStoreChunkReader(this, (CDORevision)revision, feature);
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        byte[] bytes = null;
        this.ensureSessionBegin();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("loadPackageUnit for: {0}", new Object[]{packageUnit.getID()});
        }
        ObjyPackageHandler objyPackageHandler = this.getStore().getPackageHandler();
        bytes = objyPackageHandler.readPackageBytes(packageUnit);
        EPackage ePackage = this.createEPackage(packageUnit, bytes);
        return EMFUtil.getAllPackages((EPackage)ePackage);
    }

    private EPackage createEPackage(InternalCDOPackageUnit packageUnit, byte[] bytes) {
        ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)this.getPackageRegistry());
        return EMFUtil.createEPackage((String)packageUnit.getID(), (byte[])bytes, (boolean)this.zipped, (ResourceSet)resourceSet, (boolean)false);
    }

    private CDOPackageRegistry getPackageRegistry() {
        return this.getStore().getRepository().getPackageRegistry();
    }

    private InternalCDOPackageRegistry getInternalPackageRegistry() {
        return (InternalCDOPackageRegistry)this.getPackageRegistry();
    }

    public long getMetaID(EModelElement modelElement) {
        CDOID cdoid = this.getInternalPackageRegistry().getMetaInstanceMapper().lookupMetaInstanceID((InternalEObject)modelElement);
        return CDOIDUtil.getLong((CDOID)cdoid);
    }

    public EModelElement getMetaInstance(long id) {
        CDOIDMeta cdoid = CDOIDUtil.createMeta((long)id);
        InternalEObject metaInstance = this.getInternalPackageRegistry().getMetaInstanceMapper().lookupMetaInstance((CDOID)cdoid);
        return (EModelElement)metaInstance;
    }

    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        this.ensureSessionBegin();
        String pathPrefix = context.getName();
        boolean exactMatch = context.exactMatch();
        ObjyResourceList resourceList = this.objySession.getResourceList(this.getRepositoryName());
        int size = resourceList.size();
        if (size == 0) {
            CDOID resourceID = OBJYCDOIDUtil.getCDOID(null);
            context.addResource(resourceID);
        }
        int i = 0;
        while (i < size) {
            ObjyObject resource = resourceList.getResource(i);
            if (resource != null) {
                ObjyObject resourceRevision = resource;
                if (this.getStore().isRequiredToSupportBranches()) {
                    resourceRevision = resource.getRevision(context.getTimeStamp(), context.getBranch().getID());
                } else if (this.getStore().isRequiredToSupportAudits()) {
                    resourceRevision = resource.getRevision(context.getTimeStamp(), 0);
                }
                if (resourceRevision != null && resourceRevision.getVersion() >= 0) {
                    CDOID resourceID;
                    String resourceName = ObjyResourceList.getResourceName(resourceRevision);
                    if (exactMatch && pathPrefix != null && pathPrefix.equals(resourceName)) {
                        resourceID = OBJYCDOIDUtil.getCDOID(resource.ooId());
                        if (!context.addResource(resourceID)) {
                            break;
                        }
                    } else if (pathPrefix == null && resourceName == null) {
                        resourceID = OBJYCDOIDUtil.getCDOID(resource.ooId());
                        if (!context.addResource(resourceID)) {
                            break;
                        }
                    } else if (!exactMatch && resourceName != null && resourceName.startsWith(pathPrefix)) {
                        resourceID = OBJYCDOIDUtil.getCDOID(resource.ooId());
                        context.addResource(resourceID);
                    }
                }
            }
            ++i;
        }
    }

    public void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        throw new UnsupportedOperationException();
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("readPackageUnits()", new Object[0]);
        }
        this.ensureSessionBegin();
        ObjyPackageHandler objyPackageHandler = this.getStore().getPackageHandler();
        Collection<InternalCDOPackageUnit> packageUnits = objyPackageHandler.readPackageUnits();
        return packageUnits;
    }

    public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint, int listChunk, CDORevisionCacheAdder cache) {
        boolean ok;
        ObjyObject objyObject;
        this.ensureSessionBegin();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("Reading revision for: {0}", new Object[]{id});
        }
        if ((objyObject = this.getObject(id)) == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.format("objyObject is NULL", new Object[0]);
            }
            return null;
        }
        InternalCDORevision revision = this.createRevision(objyObject, id);
        revision.setBranchPoint(branchPoint);
        ObjyObject objyRevision = objyObject;
        if (this.getStore().isRequiredToSupportBranches()) {
            objyRevision = objyObject.getRevision(branchPoint.getTimeStamp(), branchPoint.getBranch().getID());
        } else if (this.getStore().isRequiredToSupportAudits()) {
            objyRevision = objyObject.getRevision(branchPoint.getTimeStamp(), 0);
        }
        if (objyRevision == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.format("objyRevision is NULL", new Object[0]);
            }
            return null;
        }
        if (objyRevision.getVersion() < 0) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.format("...revision for: {0} - OID: {1} is detached.", new Object[]{id, objyObject.ooId().getStoreString()});
            }
            EClass eClass = ObjySchema.getEClass(this.getStore(), objyObject.objyClass());
            return new DetachedCDORevision(eClass, id, branchPoint.getBranch(), -objyRevision.getVersion(), objyRevision.getCreationTime());
        }
        CDOBranchPoint branchPoint2 = revision.getBranch().getPoint(objyRevision.getCreationTime());
        revision.setBranchPoint(branchPoint2);
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("Fetching revision details for: {0} - OID: {1}", new Object[]{id, objyRevision.ooId().getStoreString()});
        }
        return (ok = objyRevision.fetch(this, revision, listChunk)) ? revision : null;
    }

    public InternalCDORevision readRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int listChunk, CDORevisionCacheAdder cache) {
        this.ensureSessionBegin();
        ObjyObject objyObject = this.getObject(id);
        if (objyObject == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.format("objyObject is NULL", new Object[0]);
            }
            return null;
        }
        ObjyObject objyRevision = null;
        objyRevision = objyObject.getRevisionByVersion(branchVersion.getVersion());
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("Reading revision by version {0} for: {1} - OID: {2}", new Object[]{branchVersion.getVersion(), id, objyObject.ooId().getStoreString()});
        }
        if (objyRevision == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.format("objyRevision is NULL", new Object[0]);
            }
            return null;
        }
        InternalCDORevision revision = this.createRevision(objyRevision, id);
        revision.setVersion(branchVersion.getVersion());
        revision.setBranchPoint(branchVersion.getBranch().getHead());
        boolean ok = objyRevision.fetch(this, revision, listChunk);
        if (ok && objyRevision.getVersion() != branchVersion.getVersion()) {
            throw new IllegalStateException("Can only retrieve current version " + revision.getVersion() + " for " + id + " - version requested was " + branchVersion + ".");
        }
        return ok ? revision : null;
    }

    public void refreshRevisions() {
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("writePackageUnits()", new Object[0]);
        }
        this.ensureSessionBegin();
        ObjyPackageHandler objyPackageHandler = this.getStore().getPackageHandler();
        InternalCDOPackageRegistry packageRegistry = this.getStore().getRepository().getPackageRegistry();
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
        int n = packageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            objyPackageHandler.writePackages((CDOPackageRegistry)packageRegistry, packageUnit, monitor);
            ++n2;
        }
    }

    private InternalCDORevision createRevision(ObjyObject objyObject, CDOID id) {
        EClass eClass = ObjySchema.getEClass(this.getStore(), objyObject.objyClass());
        if (eClass == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("OBJY: Can't find eClass for id:" + id);
            }
            return null;
        }
        return this.getStore().createRevision(eClass, id);
    }

    private String getRepositoryName() {
        return this.getStore().getRepository().getName();
    }

    protected void addIDMappings(InternalCommitContext commitContext, OMMonitor monitor) {
        long start = System.currentTimeMillis();
        this.ensureSessionBegin();
        if (commitContext.getNewObjects().length > 0) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("creating " + commitContext.getNewObjects().length + " new objects and assigning new IDs");
            }
            InternalCDORevision[] newObjects = commitContext.getNewObjects();
            monitor.begin((double)newObjects.length);
            ObjyPlacementManagerLocal placementManager = new ObjyPlacementManagerLocal(this.getStore(), this.objySession, commitContext);
            InternalCDORevision[] internalCDORevisionArray = newObjects;
            int n = newObjects.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                placementManager.processRevision(revision);
                ++n2;
            }
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("addIDMappings time: " + (System.currentTimeMillis() - start));
        }
    }

    protected void ensureSessionBegin() {
        this.getObjySession();
        this.objySession.join();
        if (!this.objySession.isOpen()) {
            this.objySession.begin();
        }
    }

    private void ensureSessionJoin() {
        assert (this.objySession != null);
        if (this.objySession != null) {
            this.objySession.join();
        }
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        this.ensureSessionBegin();
        ObjyCommitInfoHandler commitInfoHandler = this.getStore().getCommitInfoHandler();
        List<ObjyCommitInfo> commitInfoList = commitInfoHandler.getCommitInfo(branch, startTime, endTime);
        InternalSessionManager manager = this.getSession().getManager();
        InternalRepository repository = manager.getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        InternalCDOCommitInfoManager commitInfoManager = repository.getCommitInfoManager();
        for (ObjyCommitInfo ooCommitInfo : commitInfoList) {
            long timeStamp = ooCommitInfo.getTimeStamp();
            String userID = ooCommitInfo.getUserId();
            String comment = ooCommitInfo.getComment();
            CDOBranch infoBranch = branch;
            if (infoBranch == null) {
                int id = ooCommitInfo.getBranchId();
                infoBranch = branchManager.getBranch(id);
            }
            CDOCommitInfo commitInfo = commitInfoManager.createCommitInfo(infoBranch, timeStamp, userID, comment, null);
            handler.handleCommitInfo(commitInfo);
        }
    }

    protected void writeCommitInfo(CDOBranch branch, long timeStamp, String userID, String comment, OMMonitor monitor) {
        this.ensureSessionBegin();
        ObjyCommitInfoHandler commitInfoHandler = this.getStore().getCommitInfoHandler();
        commitInfoHandler.writeCommitInfo(branch.getID(), timeStamp, userID, comment);
    }

    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        if ("OBJY".equals(info.getQueryLanguage())) {
            return new ObjectivityQueryHandler(this);
        }
        return null;
    }

    public int createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        this.ensureSessionBegin();
        return this.objySession.getBranchManager(this.getRepositoryName()).createBranch(branchID, branchInfo);
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        this.ensureSessionBegin();
        ObjyBranch objyBranch = this.objySession.getBranchManager(this.getRepositoryName()).getBranch(branchID);
        return objyBranch != null ? objyBranch.getBranchInfo() : null;
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        int count = 0;
        List<ObjyBranch> branches = this.objySession.getBranchManager(this.getRepositoryName()).getBranches(startID, endID);
        InternalCDOBranchManager branchManager = this.getStore().getRepository().getBranchManager();
        for (ObjyBranch objyBranch : branches) {
            InternalCDOBranch branch = branchManager.getBranch(objyBranch.getBranchId(), new InternalCDOBranchManager.BranchLoader.BranchInfo(objyBranch.getBranchName(), objyBranch.getBaseBranchId(), objyBranch.getBaseBranchTimeStamp()));
            branchHandler.handleBranch((CDOBranch)branch);
            ++count;
        }
        return count;
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        this.ensureSessionBegin();
        ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo> result = new ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo>();
        List<ObjyBranch> objyBranchList = this.objySession.getBranchManager(this.getRepositoryName()).getSubBranches(branchID);
        for (ObjyBranch objyBranch : objyBranchList) {
            InternalCDOBranchManager.BranchLoader.SubBranchInfo subBranchInfo = new InternalCDOBranchManager.BranchLoader.SubBranchInfo(objyBranch.getBranchId(), objyBranch.getBranchName(), objyBranch.getBaseBranchTimeStamp());
            result.add(subBranchInfo);
        }
        return result.toArray(new InternalCDOBranchManager.BranchLoader.SubBranchInfo[result.size()]);
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, CDORevisionHandler handler) {
        throw new UnsupportedOperationException();
    }

    public Set<CDOID> readChangeSet(CDOChangeSetSegment ... segments) {
        this.ensureSessionBegin();
        ObjyBranchManager objyBranchManager = this.objySession.getBranchManager(this.getRepositoryName());
        ObjyObjectManager objyObjectManager = this.objySession.getObjectManager();
        HashSet<CDOID> results = new HashSet<CDOID>();
        CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
            ObjyBranch objyBranch = objyBranchManager.getBranch(segment.getBranch().getID());
            Iterator<?> objItr = objyBranch.getRevisions();
            while (objItr.hasNext()) {
                ooObj anObj = (ooObj)objItr.next();
                ObjyObject objyObject = objyObjectManager.getObject(anObj.getOid());
                long creationTime = objyObject.getCreationTime();
                long revisedTime = objyObject.getRevisedTime();
                if (creationTime < segment.getTimeStamp() || revisedTime > segment.getEndTime() && revisedTime != 0L) continue;
                results.add(objyObject.getRevisionId());
            }
            ++n2;
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("ChangeSet " + ((Object)results).toString());
        }
        return results;
    }

    public void rawExport(CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void rawImport(CDODataInput in, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        throw new UnsupportedOperationException();
    }
}

