/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity;

import org.eclipse.emf.cdo.server.internal.objectivity.db.FdManager;
import org.eclipse.emf.cdo.server.objectivity.IObjectivityStoreConfig;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ObjectivityStoreConfig
extends Lifecycle
implements IObjectivityStoreConfig {
    private static final long serialVersionUID = 1L;
    FdManager fdManager = new FdManager();
    private int sessionMinCacheSize = 0;
    private int sessionMaxCacheSize = 0;

    public ObjectivityStoreConfig() {
        this.fdManager.configure();
    }

    public ObjectivityStoreConfig(Element storeConfig) {
        this.getFdProperties(storeConfig);
        this.fdManager.configure();
    }

    public ObjectivityStoreConfig(String name) {
        this.fdManager.configure(name);
    }

    public void doActivate() {
        this.fdManager.deleteFD();
        this.fdManager.configure();
    }

    public void doDeactivate() {
        this.fdManager.deleteFD();
    }

    public String getFdName() {
        return this.fdManager.getFd();
    }

    public void resetFD() {
        this.fdManager.removeData();
    }

    private void getFdProperties(Element storeConfig) {
        NodeList fdConfigs = storeConfig.getElementsByTagName("fdConfig");
        if (fdConfigs.getLength() != 1) {
            throw new IllegalStateException("FD configuration is missing");
        }
        Element fdConfig = (Element)fdConfigs.item(0);
        String fdName = fdConfig.getAttribute("name");
        String lockServerHost = fdConfig.getAttribute("lockServerHost");
        String fdDirPath = fdConfig.getAttribute("fdDirPath");
        String fdFileHost = fdConfig.getAttribute("fdFileHost");
        String fdNumber = fdConfig.getAttribute("fdNumber");
        String pageSize = fdConfig.getAttribute("pageSize");
        this.sessionMinCacheSize = this.getIntegerValue(fdConfig.getAttribute("SessionMinCacheSize"), 0);
        this.sessionMaxCacheSize = this.getIntegerValue(fdConfig.getAttribute("SessionMaxCacheSize"), 0);
        this.fdManager.setFdName(fdName);
        this.fdManager.setFdDirPath(fdDirPath);
        this.fdManager.setFdNumber(fdNumber);
        this.fdManager.setFdFileHost(fdFileHost);
        this.fdManager.setLockServerHost(lockServerHost);
        this.fdManager.setPageSize(pageSize);
    }

    private int getIntegerValue(String str, int defaultValue) {
        if (str.length() == 0) {
            return defaultValue;
        }
        return new Integer(str);
    }

    public int getSessionMinCacheSize() {
        return this.sessionMinCacheSize;
    }

    public int getSessionMaxCacheSize() {
        return this.sessionMaxCacheSize;
    }
}

