/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.clustering;

import com.objy.db.app.ooId;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStore;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.clustering.ObjyPlacementManager;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyScope;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySession;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.OBJYCDOIDUtil;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOIDLong;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjyPlacementManagerLocal {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyPlacementManagerLocal.class);
    private String repositoryName = null;
    private ObjyPlacementManager globalPlacementManager = null;
    ObjySession objySession = null;
    InternalCommitContext commitContext = null;
    Map<CDOID, InternalCDORevision> newObjectsMap;
    Map<CDOID, CDOID> idMapper;

    public ObjyPlacementManagerLocal(ObjectivityStore objyStore, ObjySession objySession, InternalCommitContext commitContext) {
        this.repositoryName = objyStore.getRepository().getName();
        this.globalPlacementManager = objyStore.getGlobalPlacementManager();
        this.objySession = objySession;
        this.commitContext = commitContext;
        this.newObjectsMap = new HashMap<CDOID, InternalCDORevision>();
        InternalCDORevision[] internalCDORevisionArray = commitContext.getNewObjects();
        int n = internalCDORevisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            this.newObjectsMap.put(revision.getID(), revision);
            ++n2;
        }
        this.idMapper = new HashMap<CDOID, CDOID>();
    }

    public void processRevision(InternalCDORevision revision) {
        if (this.isIdProcessed(revision.getID())) {
            return;
        }
        this.createObjectAndAddToMapping(revision);
    }

    private ObjyObject createObjectAndAddToMapping(InternalCDORevision revision) {
        ObjyObject objyObject = this.createObject(revision);
        CDOID newID = OBJYCDOIDUtil.getCDOID(objyObject.ooId());
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Adding object to mapping from " + revision.getID() + " to " + newID);
        }
        this.commitContext.addIDMapping(revision.getID(), newID);
        this.idMapper.put(revision.getID(), newID);
        return objyObject;
    }

    protected boolean isIdProcessed(CDOID id) {
        return this.idMapper.get(id) != null;
    }

    protected ObjyObject createObject(InternalCDORevision revision) {
        ooId nearObject = null;
        EClass eClass = revision.getEClass();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Creating new object with " + revision + " " + eClass);
        }
        if (revision.isResourceNode()) {
            if (revision.getID() == revision.getResourceID()) {
                nearObject = this.objySession.getResourceList(this.repositoryName).ooId();
            } else {
                ObjyScope objyScope = new ObjyScope(this.repositoryName, "ResourceListCont");
                nearObject = objyScope.getScopeContOid();
            }
        } else {
            nearObject = this.getNearObject(revision);
        }
        if (nearObject == null) {
            nearObject = this.globalPlacementManager.getNearObject(null, null, revision.getEClass());
        }
        ObjyObject objyObject = this.objySession.getObjectManager().newObject(eClass, nearObject);
        return objyObject;
    }

    protected ooId getNearObject(InternalCDORevision revision) {
        ooId nearObject = null;
        Object cdoId = revision.getContainerID();
        if (cdoId instanceof CDOID && (CDOID)cdoId != CDOID.NULL) {
            nearObject = this.getOidFromCDOID((CDOID)cdoId);
        } else {
            CDOID resourceId = revision.getResourceID();
            nearObject = this.getOidFromCDOID(resourceId);
        }
        return nearObject;
    }

    protected ooId getOidFromCDOID(CDOID cdoId) {
        ooId oid = null;
        if (cdoId instanceof AbstractCDOIDLong) {
            oid = OBJYCDOIDUtil.getooId(cdoId);
        } else if (cdoId instanceof CDOIDTemp) {
            CDOID nearId = this.idMapper.get(cdoId);
            if (nearId != null) {
                oid = OBJYCDOIDUtil.getooId(nearId);
            } else {
                InternalCDORevision containerRevision = this.newObjectsMap.get(cdoId);
                if (containerRevision != null) {
                    oid = this.createObjectAndAddToMapping(containerRevision).ooId();
                }
            }
        }
        return oid;
    }
}

