/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.db.DatabaseNotFoundException;
import com.objy.db.DatabaseOpenException;
import com.objy.db.ObjyRuntimeException;
import com.objy.db.app.Connection;
import com.objy.db.app.Session;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.clustering.ObjyPlacementManager;
import org.eclipse.emf.cdo.server.internal.objectivity.clustering.ObjyPlacementManagerImpl;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySession;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyConnection {
    public static final ObjyConnection INSTANCE = new ObjyConnection();
    protected Connection connection = null;
    protected boolean isConnected = false;
    protected String fdName = "";
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyConnection.class);
    private static final String SESSION_POOL_NAME_READ = "ReadSP";
    private static final String SESSION_POOL_NAME_WRITE = "WriteSP";
    protected ConcurrentHashMap<String, ObjySession> readPool;
    protected ConcurrentHashMap<String, ObjySession> writePool;
    private ObjyPlacementManager defaultPlacementManager = null;
    private Object syncObject = new Object();
    private ReentrantLock lock = new ReentrantLock();
    private int sessionMinCacheSize = 600;
    private int sessionMaxCacheSize = 1000;

    public ObjyConnection() {
        this.readPool = new ConcurrentHashMap(20);
        this.writePool = new ConcurrentHashMap(20);
    }

    public synchronized void connect(String fdName) {
        this.fdName = fdName;
        this.connect();
    }

    private void connect() {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace(" SessionMinCacheSize: " + this.sessionMinCacheSize);
            TRACER_DEBUG.trace(" SessionMaxCacheSize: " + this.sessionMaxCacheSize);
        }
        if (!this.isConnected) {
            try {
                if (Connection.current() == null) {
                    int options = 0;
                    Connection.setLoggingOptions((int)options, (boolean)true, (boolean)true, (String)"c:\\data", (String)"MainLog.txt");
                    if (TRACER_DEBUG.isEnabled()) {
                        TRACER_DEBUG.trace(" creating new Connection");
                    }
                    this.connection = Connection.open((String)this.fdName, (int)2);
                    this.connection.useContextClassLoader(true);
                } else {
                    this.connection.addToMainLog("ObjyConnection.connect()", "...reopen connection to the FD.");
                    this.connection.setOpenMode(2);
                    this.connection.reopen();
                    this.connection.loadSchemaClasses(true);
                }
                this.isConnected = true;
            }
            catch (DatabaseOpenException e) {
                e.printStackTrace();
            }
            catch (DatabaseNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public String getSessionPoolNameRead() {
        return SESSION_POOL_NAME_READ;
    }

    public String getSessionPoolNameWrite() {
        return SESSION_POOL_NAME_WRITE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjySession getWriteSessionFromPool(String sessionName) {
        Object object = this.syncObject;
        synchronized (object) {
            ObjySession session = this.writePool.get(sessionName);
            if (session == null) {
                session = new ObjySession(sessionName, this.writePool, this);
                this.writePool.put(sessionName, session);
            }
            session.join();
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjySession getReadSessionFromPool(String sessionName) {
        Object object = this.syncObject;
        synchronized (object) {
            ObjySession session = this.readPool.get(sessionName);
            if (session == null) {
                session = new ObjySession(sessionName, this.writePool, this);
                this.readPool.put(sessionName, session);
            }
            session.join();
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnSessionToPool(ObjySession session) {
        Object object = this.syncObject;
        synchronized (object) {
            session.leave();
        }
    }

    public void disconnect() {
        if (!this.isConnected) {
            return;
        }
        this.lock.lock();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("ObjyConnection.disconnect() -- Start. " + this.toString());
        }
        this.cleanupSessionPool(this.readPool);
        this.cleanupSessionPool(this.writePool);
        Vector sessions = this.connection.sessions();
        for (Session aSession : sessions) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Session: " + aSession + " - open state: " + aSession.isOpen());
            }
            if (!aSession.isOpen()) continue;
            try {
                try {
                    aSession.join();
                    aSession.abort();
                }
                catch (ObjyRuntimeException ex) {
                    ex.printStackTrace();
                    aSession.terminate();
                    continue;
                }
            }
            catch (Throwable throwable) {
                aSession.terminate();
                throw throwable;
            }
            aSession.terminate();
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("ObjyConnection.disconnect() -- END. ");
        }
        this.lock.unlock();
    }

    public void registerClass(String name) {
        this.connection.registerClass(name);
    }

    public ObjyPlacementManager getDefaultPlacementManager() {
        if (this.defaultPlacementManager == null) {
            this.defaultPlacementManager = new ObjyPlacementManagerImpl();
        }
        return this.defaultPlacementManager;
    }

    protected void cleanupSessionPool(ConcurrentHashMap<String, ObjySession> pool) {
        for (ObjySession objySession : pool.values()) {
            try {
                try {
                    if (objySession.isOpen()) {
                        objySession.join();
                        objySession.abort();
                    }
                }
                catch (ObjyRuntimeException ex) {
                    ex.printStackTrace();
                    try {
                        objySession.terminate();
                    }
                    catch (ObjyRuntimeException ex2) {
                        ex2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    objySession.terminate();
                }
                catch (ObjyRuntimeException ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
            try {
                objySession.terminate();
            }
            catch (ObjyRuntimeException ex) {
                ex.printStackTrace();
            }
        }
        pool.clear();
    }

    public void setSessionMinCacheSize(int sessionMinCacheSize) {
        if (sessionMinCacheSize > this.sessionMinCacheSize) {
            this.sessionMinCacheSize = sessionMinCacheSize;
        }
    }

    public void setSessionMaxCacheSize(int sessionMaxCacheSize) {
        if (sessionMaxCacheSize > this.sessionMaxCacheSize) {
            this.sessionMaxCacheSize = sessionMaxCacheSize;
        }
    }

    public int getMinSessionCacheSize() {
        return this.sessionMinCacheSize;
    }

    public int getMaxSessionCacheSize() {
        return this.sessionMaxCacheSize;
    }
}

