/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Class_Position;
import com.objy.as.app.Numeric_Value;
import com.objy.as.app.Relationship_Object;
import com.objy.as.app.String_Value;
import com.objy.as.app.VArray_Object;
import com.objy.as.app.d_Class;
import com.objy.as.asException;
import com.objy.db.app.Iterator;
import com.objy.db.app.Session;
import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStoreAccessor;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyClass;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObjectManager;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.IManyTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ISingleTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ITypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ObjyMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.SingleReferenceMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyFeatureMapEntry;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyProxy;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.OBJYCDOIDUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjyObject {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyObject.class);
    protected Class_Object classObject;
    protected ObjyClass objyClass;
    protected Class_Object baseClassObject = null;
    protected Relationship_Object baseRel = null;
    protected Relationship_Object revisionsRel = null;
    protected Relationship_Object lastRevisionRel = null;
    protected ooId objectId;
    private Map<Class_Position, Object> featureMap = new HashMap<Class_Position, Object>();

    public ObjyObject(Class_Object classObject) {
        this.classObject = classObject;
        this.objyClass = ObjySchema.getObjyClass(classObject.type_of().name());
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.format("...classObject type: {0} - oid: {1}", new Object[]{classObject.type_of().name(), classObject.objectID().getStoreString()});
        }
        this.baseRel = classObject.get_relationship(this.objyClass.resolve_position("oo_base"));
        if (!this.baseRel.exists()) {
            this.revisionsRel = classObject.get_relationship(this.objyClass.resolve_position("oo_revisions"));
            this.lastRevisionRel = classObject.get_relationship(this.objyClass.resolve_position("oo_lastRevision"));
        } else {
            this.baseClassObject = this.baseRel.get_class_obj();
        }
        this.setObjectId(classObject.objectID());
    }

    public ObjyClass objyClass() {
        return this.objyClass;
    }

    public Class_Object ooClassObject() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        return this.classObject;
    }

    public void setObjectId(ooId objectId) {
        this.objectId = objectId;
    }

    public ooId ooId() {
        return this.objectId;
    }

    public void setEContainer(Object containerID) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        Class_Position position = this.objyClass.resolve_position("oo_containerId");
        SingleReferenceMapper.INSTANCE.setValue(this, position, containerID);
    }

    public Object getEContainer() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        Class_Position position = this.objyClass.resolve_position("oo_containerId");
        Object value = SingleReferenceMapper.INSTANCE.getValue(this, position);
        return value;
    }

    public ooId getEContainerAsOid() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        Class_Position position = this.objyClass.resolve_position("oo_containerId");
        ooId childOid = this.get_ooId(position);
        return childOid;
    }

    public void setEResource(Object resourceID) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        Class_Position position = this.objyClass.resolve_position("oo_resourceId");
        SingleReferenceMapper.INSTANCE.setValue(this, position, resourceID);
    }

    public Object getEResource() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        Class_Position position = this.objyClass.resolve_position("oo_resourceId");
        Object value = SingleReferenceMapper.INSTANCE.getValue(this, position);
        return value;
    }

    public ooId getEResourceAsOid() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        Class_Position position = this.objyClass.resolve_position("oo_resourceId");
        ooId childOid = this.get_ooId(position);
        return childOid;
    }

    public void setEContainingFeature(int contFeature) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        Class_Position position = this.objyClass.resolve_position("oo_containerFeatureId");
        this.set_numeric(position, new Numeric_Value(contFeature));
    }

    public int getEContainingFeature() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        Class_Position position = this.objyClass.resolve_position("oo_containerFeatureId");
        return this.get_numeric(position).intValue();
    }

    public Object getFeatureList(Class_Position position) {
        return this.featureMap.get(position);
    }

    public void setFeatureList(Class_Position position, Object object) {
        this.featureMap.put(position, object);
    }

    public int getVersion() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        int version = this.classObject.get_numeric(this.objyClass.resolve_position("oo_version")).intValue();
        return version;
    }

    public void setVersion(int version) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        this.classObject.set_numeric(this.objyClass.resolve_position("oo_version"), new Numeric_Value(version));
        this.getVersion();
    }

    public long getCreationTime() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        long creationTime = this.classObject.get_numeric(this.objyClass.resolve_position("oo_creationTime")).longValue();
        return creationTime;
    }

    public void setCreationTime(long creationTime) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        this.classObject.set_numeric(this.objyClass.resolve_position("oo_creationTime"), new Numeric_Value(creationTime));
    }

    public long getRevisedTime() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        long revisedTime = this.classObject.get_numeric(this.objyClass.resolve_position("oo_revisedTime")).longValue();
        return revisedTime;
    }

    public void setRevisedTime(long revisedTime) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        this.classObject.set_numeric(this.objyClass.resolve_position("oo_revisedTime"), new Numeric_Value(revisedTime));
    }

    public void setBranchId(int branchId) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        this.classObject.set_numeric(this.objyClass.resolve_position("oo_branchId"), new Numeric_Value(branchId));
    }

    public long getBranchId() {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        int branchId = this.classObject.get_numeric(this.objyClass.resolve_position("oo_branchId")).intValue();
        return branchId;
    }

    public ObjyObject copy(EClass eClass) {
        ObjyObject newObjyObject = null;
        ooObj obj = ooObj.create_ooObj((ooId)this.objectId);
        ooObj newObj = (ooObj)obj.copy((Object)obj);
        newObjyObject = new ObjyObject(Class_Object.class_object_from_oid((ooId)newObj.getOid()));
        try {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("=> ObjyObject.copy() - oid:" + this.ooId().getStoreString() + " version:" + this.getVersion());
            }
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature)) continue;
                feature.isMany();
            }
        }
        catch (asException ex) {
            ex.printStackTrace();
        }
        return newObjyObject;
    }

    public void update(ObjectivityStoreAccessor storeAccessor, InternalCDORevision revision) {
        try {
            if (TRACER_DEBUG.isEnabled()) {
                this.checkSession();
                TRACER_DEBUG.trace("=> ObjyObject.update() - oid:" + this.ooId().getStoreString() + " - version:" + revision.getVersion());
            }
            this.updateData(storeAccessor, revision);
        }
        catch (asException ex) {
            ex.printStackTrace();
        }
    }

    private void updateData(ObjectivityStoreAccessor storeAccessor, InternalCDORevision revision) {
        EClass eClass = revision.getEClass();
        try {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("=> ObjyObject.updateData() - oid:" + this.ooId().getStoreString() + " - version:" + revision.getVersion());
            }
            this.setVersion(revision.getVersion());
            this.setEContainer(revision.getContainerID());
            this.setEResource(revision.getResourceID());
            this.setEContainingFeature(revision.getContainingFeatureID());
            this.setCreationTime(revision.getTimeStamp());
            this.setRevisedTime(revision.getRevised());
            this.setBranchId(revision.getBranch().getID());
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature)) continue;
                ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
                if (mapper == null) {
                    if (!TRACER_DEBUG.isEnabled()) continue;
                    TRACER_DEBUG.trace("In " + this.ooId().getStoreString() + " - Can't find mapper for feature " + feature.getName());
                    continue;
                }
                if (feature.isMany()) {
                    CDOList list = revision.getList(feature);
                    Object[] values = new Object[list.size()];
                    int i = 0;
                    while (i < values.length) {
                        Object value = list.get(i);
                        if (value instanceof CDOIDExternal) {
                            ObjyProxy proxyObject = ObjyProxy.createObject(this.ooId());
                            proxyObject.setUri(((CDOIDExternal)value).getURI());
                            values[i] = proxyObject.ooId();
                        } else if (value instanceof CDOID) {
                            values[i] = OBJYCDOIDUtil.getooId((CDOID)list.get(i));
                        } else if (value instanceof FeatureMap.Entry) {
                            FeatureMap.Entry entry = (FeatureMap.Entry)value;
                            EStructuralFeature entryFeature = entry.getEStructuralFeature();
                            Object entryValue = entry.getValue();
                            long metaId = storeAccessor.getMetaID((EModelElement)entryFeature);
                            ooId oid = null;
                            if (entryValue instanceof CDOIDExternal) {
                                ObjyProxy proxyObject = ObjyProxy.createObject(this.ooId());
                                proxyObject.setUri(((CDOIDExternal)entryValue).getURI());
                                oid = proxyObject.ooId();
                            } else if (entryValue instanceof CDOID) {
                                oid = OBJYCDOIDUtil.getooId((CDOID)entryValue);
                            } else if (TRACER_DEBUG.isEnabled()) {
                                TRACER_DEBUG.trace("OBJY: don't know what kind of entryValue is this!!! - " + entryValue);
                            }
                            ObjyFeatureMapEntry featureMapEntry = new ObjyFeatureMapEntry(entryFeature.getName(), oid, metaId, this.objectId);
                            values[i] = featureMapEntry;
                        } else {
                            values[i] = value;
                        }
                        ++i;
                    }
                    ((IManyTypeMapper)mapper).setAll(this, feature, 0, values);
                    continue;
                }
                Object newValue = revision.get(feature, feature.getFeatureID());
                ((ISingleTypeMapper)mapper).setValue(this, feature, newValue);
            }
        }
        catch (asException ex) {
            ex.printStackTrace();
        }
    }

    public ObjyObject getLastRevision() {
        if (!this.lastRevisionRel.exists()) {
            return this;
        }
        Class_Object lastRevision = this.lastRevisionRel.get_class_obj();
        return new ObjyObject(lastRevision);
    }

    public ObjyObject getRevisionByVersion(int version) {
        ObjyObject objyRevision = null;
        if (Math.abs(this.getVersion()) == version) {
            return this;
        }
        Session.getCurrent().setReturn_Class_Object(true);
        Iterator itr = this.revisionsRel.get_iterator();
        while (itr.hasNext()) {
            objyRevision = new ObjyObject((Class_Object)itr.next());
            if (Math.abs(objyRevision.getVersion()) != version) continue;
            return objyRevision;
        }
        return null;
    }

    public void addToRevisions(ObjyObject objyRevision) {
        this.revisionsRel.add(objyRevision.objectId);
        this.lastRevisionRel.clear();
        this.lastRevisionRel.form(objyRevision.objectId);
    }

    public boolean fetch(ObjectivityStoreAccessor storeAccessor, InternalCDORevision revision, int listChunk) {
        boolean bRet = true;
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        EClass eClass = revision.getEClass();
        try {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("=> ObjyObject.fetch() - oid:" + this.ooId().getStoreString() + " version:" + this.getVersion());
            }
            revision.setVersion(this.getVersion());
            revision.setContainerID(this.getEContainer());
            revision.setResourceID((CDOID)this.getEResource());
            revision.setContainingFeatureID(this.getEContainingFeature());
            long creationTime = this.getCreationTime();
            long revisedTime = this.getRevisedTime();
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("... ObjyObject.creationTime: " + creationTime);
                TRACER_DEBUG.trace("... ObjyObject.revisedTime : " + revisedTime);
            }
            revision.setRevised(revisedTime);
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature)) continue;
                if (feature.isMany()) {
                    int featureSize;
                    int chunkSize = featureSize = this.size(feature);
                    if (listChunk != -1) {
                        chunkSize = Math.min(chunkSize, listChunk);
                    }
                    Object[] objects = this.getAll(feature, 0, chunkSize);
                    CDOList list = revision.getList(feature);
                    int i = 0;
                    while (i < chunkSize) {
                        if (objects[i] instanceof ooId) {
                            Class_Object refClassObject = Class_Object.class_object_from_oid((ooId)((ooId)objects[i]));
                            if (refClassObject.type_of().name().equals(ObjyProxy.className)) {
                                ObjyProxy proxyObject = new ObjyProxy(refClassObject);
                                list.add((Object)OBJYCDOIDUtil.createCDIDExternal(proxyObject));
                            } else {
                                CDOID childID = OBJYCDOIDUtil.getCDOID((ooId)objects[i]);
                                list.add((Object)childID);
                            }
                            refClassObject = null;
                        } else if (objects[i] instanceof ObjyFeatureMapEntry) {
                            ObjyFeatureMapEntry mapEntry = (ObjyFeatureMapEntry)objects[i];
                            long metaId = mapEntry.getMetaId();
                            ooId oid = mapEntry.getObject();
                            CDOID cdoId = null;
                            Class_Object refClassObject = Class_Object.class_object_from_oid((ooId)oid);
                            if (refClassObject.type_of().name().equals(ObjyProxy.className)) {
                                ObjyProxy proxyObject = new ObjyProxy(refClassObject);
                                cdoId = OBJYCDOIDUtil.createCDIDExternal(proxyObject);
                            } else {
                                cdoId = OBJYCDOIDUtil.getCDOID((ooId)objects[i]);
                            }
                            EStructuralFeature entryFeature = (EStructuralFeature)storeAccessor.getMetaInstance(metaId);
                            FeatureMap.Entry entry = CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)entryFeature, (Object)cdoId);
                            entryFeature = entry.getEStructuralFeature();
                            list.add((Object)entry);
                            refClassObject = null;
                        } else {
                            list.add(objects[i]);
                        }
                        ++i;
                    }
                    if (featureSize - chunkSize <= 0) continue;
                    i = 0;
                    while (i < featureSize - chunkSize) {
                        list.add(InternalCDOList.UNINITIALIZED);
                        ++i;
                    }
                    continue;
                }
                Object object = this.get(feature, 0);
                revision.set(feature, 0, object);
            }
        }
        catch (asException ex) {
            ex.printStackTrace();
        }
        return bRet;
    }

    public Object[] fetch(ObjectivityStoreAccessor storeAccessor, EStructuralFeature feature, int startIndex, int chunkSize) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        try {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("=> ObjyObject.fetch() - feature:" + feature.getName() + "from Object: " + this.ooId().getStoreString() + " version:" + this.getVersion());
            }
            int featureSize = this.size(feature);
            chunkSize = Math.min(featureSize - startIndex, chunkSize);
            Object[] objects = this.getAll(feature, startIndex, chunkSize);
            int i = 0;
            while (i < chunkSize) {
                if (objects[i] instanceof ooId) {
                    Class_Object refClassObject = Class_Object.class_object_from_oid((ooId)((ooId)objects[i]));
                    if (refClassObject.type_of().name().equals(ObjyProxy.className)) {
                        ObjyProxy proxyObject = new ObjyProxy(refClassObject);
                        results.add(OBJYCDOIDUtil.createCDIDExternal(proxyObject));
                    } else {
                        results.add(OBJYCDOIDUtil.getCDOID((ooId)objects[i]));
                    }
                } else if (objects[i] instanceof ObjyFeatureMapEntry) {
                    ObjyFeatureMapEntry mapEntry = (ObjyFeatureMapEntry)objects[i];
                    long metaId = mapEntry.getMetaId();
                    ooId oid = mapEntry.getObject();
                    CDOID cdoId = null;
                    Class_Object refClassObject = Class_Object.class_object_from_oid((ooId)oid);
                    if (refClassObject.type_of().name().equals(ObjyProxy.className)) {
                        ObjyProxy proxyObject = new ObjyProxy(refClassObject);
                        cdoId = OBJYCDOIDUtil.createCDIDExternal(proxyObject);
                    } else {
                        cdoId = OBJYCDOIDUtil.getCDOID((ooId)objects[i]);
                    }
                    EStructuralFeature entryFeature = (EStructuralFeature)storeAccessor.getMetaInstance(metaId);
                    FeatureMap.Entry entry = CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)entryFeature, (Object)cdoId);
                    entryFeature = entry.getEStructuralFeature();
                    results.add(entry);
                }
                ++i;
            }
        }
        catch (asException ex) {
            ex.printStackTrace();
        }
        return results.toArray();
    }

    private int size(EStructuralFeature feature) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        IManyTypeMapper mapper = (IManyTypeMapper)ObjyMapper.INSTANCE.getTypeMapper(feature);
        int size = mapper.size(this, feature);
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Size of object " + this.ooId().getStoreString() + " - is: " + size + " - feature: " + feature.getName());
        }
        return size;
    }

    public Object get(EStructuralFeature feature) {
        return this.get(feature, 0);
    }

    private Object get(EStructuralFeature feature, int index) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Getting object " + this.objectId.getStoreString() + " <feature ' " + feature.getName() + "':" + feature.getEType() + "> from " + this);
        }
        ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
        Object value = null;
        value = feature.isMany() ? ((IManyTypeMapper)mapper).getValue(this, feature, index) : ((ISingleTypeMapper)mapper).getValue(this, feature);
        return value;
    }

    protected Object[] getAll(EStructuralFeature feature, int startIndex, int chunkSize) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Get All objects for ID: " + this.ooId().getStoreString() + " <feature ' " + feature + "':" + feature.getEType() + "> from " + this);
        }
        assert (feature.isMany());
        IManyTypeMapper mapper = (IManyTypeMapper)ObjyMapper.INSTANCE.getTypeMapper(feature);
        Object[] values = mapper.getAll(this, feature, startIndex, chunkSize);
        return values;
    }

    public void add(EStructuralFeature feature, int index, Object value) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Adding object " + value + " to " + this.ooId().getStoreString());
        }
        assert (feature.isMany());
        IManyTypeMapper mapper = (IManyTypeMapper)ObjyMapper.INSTANCE.getTypeMapper(feature);
        mapper.add(this, feature, index, value);
    }

    public void clear(EStructuralFeature feature) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Clear List for " + this.ooId().getStoreString());
        }
        ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
        ((IManyTypeMapper)mapper).clear(this, feature);
    }

    public void move(EStructuralFeature feature, int targetIndex, int sourceIndex) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Move element from " + sourceIndex + " to " + targetIndex);
        }
        ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
        ((IManyTypeMapper)mapper).move(this, feature, targetIndex, sourceIndex);
    }

    public Object remove(EStructuralFeature feature, int index) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Remove object from '" + this.ooId().getStoreString() + "' at index " + index);
        }
        IManyTypeMapper mapper = (IManyTypeMapper)ObjyMapper.INSTANCE.getTypeMapper(feature);
        Object value = mapper.remove(this, feature, index);
        if (feature instanceof EAttribute) {
            return value;
        }
        CDOID objectFromResource = OBJYCDOIDUtil.getCDOID((ooId)value);
        return objectFromResource;
    }

    public Object set(EStructuralFeature feature, int index, Object value) {
        if (TRACER_DEBUG.isEnabled()) {
            this.checkSession();
            TRACER_DEBUG.trace("Set object '" + this.ooId().getStoreString() + "' feature : " + feature.getName());
        }
        ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
        if (feature.isMany()) {
            ((IManyTypeMapper)mapper).setValue(this, feature, index, value);
        } else {
            ((ISingleTypeMapper)mapper).setValue(this, feature, value);
        }
        return value;
    }

    public void unset(EStructuralFeature feature) {
        this.set(feature, 0, null);
    }

    protected void checkSession() {
    }

    public void delete(ObjectivityStoreAccessor storeAccessor, ObjyObjectManager objectManager) {
        EClass eClass = ObjySchema.getEClass(storeAccessor.getStore(), this.objyClass());
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature)) continue;
            if (feature.isMany()) {
                Object[] objects = this.getAll(feature, 0, -1);
                int i = 0;
                while (i < objects.length) {
                    if (objects[i] instanceof ooId) {
                        ooId oid = (ooId)objects[i];
                        ooObj obj = ooObj.create_ooObj((ooId)oid);
                        if (!obj.isDead()) {
                            Class_Object refClassObject = Class_Object.class_object_from_oid((ooId)oid);
                            if (refClassObject.type_of().name().equals(ObjyProxy.className)) {
                                obj.delete();
                            } else {
                                ObjyObject childObjyObject = objectManager.getObject(oid);
                                ooId containerId = childObjyObject.getEContainerAsOid();
                                ooId resourceId = childObjyObject.getEResourceAsOid();
                                int childVersion = childObjyObject.getVersion();
                                if (containerId.equals(this.objectId) || resourceId.equals(this.objectId)) {
                                    childObjyObject.setVersion(-childVersion);
                                }
                            }
                        }
                    } else if (objects[i] instanceof ObjyFeatureMapEntry) {
                        ObjyFeatureMapEntry mapEntry = (ObjyFeatureMapEntry)objects[i];
                        ooId oid = mapEntry.getObject();
                        ooObj obj = ooObj.create_ooObj((ooId)oid);
                        obj.delete();
                    } else if (TRACER_DEBUG.isEnabled()) {
                        TRACER_DEBUG.trace("-->> No process to delete() feature (" + i + ") -> feature:" + feature.getName() + " - value:" + objects[i] + " ... nothing to do here.");
                    }
                    ++i;
                }
                continue;
            }
            ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
            if (mapper == null) continue;
            mapper.delete(this, feature);
        }
    }

    public Numeric_Value get_numeric(Class_Position position) {
        return this.classObject.get_numeric(position);
    }

    public String_Value get_string(Class_Position position) {
        return this.classObject.get_string(position);
    }

    public void set_numeric(Class_Position position, Numeric_Value value) {
        this.classObject.set_numeric(position, value);
    }

    public VArray_Object get_varray(Class_Position position) {
        return this.classObject.get_varray(position);
    }

    public ooId get_ooId(Class_Position position) {
        return this.classObject.get_ooId(position);
    }

    public Class_Object get_class_obj(Class_Position position) {
        return this.classObject.get_class_obj(position);
    }

    public void set_ooId(Class_Position position, ooId object) {
        this.classObject.set_ooId(position, object);
    }

    public CDOID getRevisionId() {
        ooId oid = this.objectId;
        if (this.baseClassObject != null) {
            oid = this.baseClassObject.objectID();
        }
        return OBJYCDOIDUtil.getCDOID(oid);
    }

    public ObjyObject getRevision(long timeStamp, int branchId) {
        ObjyObject objyRevision = null;
        Session.getCurrent().setReturn_Class_Object(true);
        if (this.evaluateRevision(timeStamp, branchId, this)) {
            return this;
        }
        if (!this.lastRevisionRel.exists()) {
            return null;
        }
        Iterator itr = this.revisionsRel.get_iterator();
        while (itr.hasNext()) {
            objyRevision = new ObjyObject((Class_Object)itr.next());
            if (!this.evaluateRevision(timeStamp, branchId, objyRevision)) continue;
            return objyRevision;
        }
        return null;
    }

    protected boolean evaluateRevision(long timeStamp, int branchId, ObjyObject objyRevision) {
        if (objyRevision.getBranchId() == (long)branchId) {
            long creationTS;
            long revisedTS = objyRevision.getRevisedTime();
            if (timeStamp != 0L ? (creationTS = objyRevision.getCreationTime()) <= timeStamp && (revisedTS == 0L || revisedTS >= timeStamp) : revisedTS == 0L) {
                return true;
            }
        }
        return false;
    }

    public void detach(int version, CDOBranch branch, long timeStamp) {
        ObjyClass objyClass = ObjySchema.getObjyClass("ObjyBase");
        Class_Object detachedClassObject = Class_Object.new_persistent_object((d_Class)objyClass.getASClass(), (ooId)this.objectId, (boolean)false);
        ObjyObject detachedObjyObject = new ObjyObject(detachedClassObject);
        detachedObjyObject.setVersion(-(version + 1));
        detachedObjyObject.setBranchId(branch.getID());
        detachedObjyObject.setCreationTime(timeStamp);
        this.addToRevisions(detachedObjyObject);
    }
}

