/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.as.app.Class_Object;
import com.objy.as.app.d_Class;
import com.objy.db.ObjyRuntimeException;
import com.objy.db.app.ooId;
import java.util.WeakHashMap;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStoreAccessor;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.clustering.ObjyPlacementManager;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyClass;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ITypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ObjyMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.OBJYCDOIDUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjyObjectManager {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyObjectManager.class);
    private WeakHashMap<Long, ObjyObject> idToObjyObjectMap = new WeakHashMap();
    private ObjyPlacementManager globalPlacementManager = null;

    public ObjyObjectManager(ObjyPlacementManager placementManager) {
        this.globalPlacementManager = placementManager;
    }

    public int sizeOfObjectMap() {
        return this.idToObjyObjectMap.size();
    }

    public ObjyObject newObject(EClass eClass, ooId nearObject) {
        if (nearObject == null) {
            nearObject = this.globalPlacementManager.getNearObject(null, null, eClass);
        }
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Create new object of type " + eClass.getName() + " near object " + (nearObject != null ? nearObject.getStoreString() : null));
        }
        Class_Object newClassObject = this.newClassObject(eClass, nearObject);
        ObjyObject objyObject = new ObjyObject(newClassObject);
        this.idToObjyObjectMap.put(OBJYCDOIDUtil.getLong(objyObject.ooId()), objyObject);
        return objyObject;
    }

    private Class_Object newClassObject(EClass eClass, ooId nearObject) {
        ObjyClass objyClass = ObjySchema.getOrCreate(eClass);
        Class_Object newClassObject = Class_Object.new_persistent_object((d_Class)objyClass.getASClass(), (ooId)nearObject, (boolean)false);
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || !EMFUtil.isPersistent((EStructuralFeature)feature)) continue;
            ITypeMapper mapper = ObjyMapper.INSTANCE.getTypeMapper(feature);
            if (mapper == null) {
                if (!TRACER_DEBUG.isEnabled()) continue;
                TRACER_DEBUG.trace("Can't find mapper for feature " + feature.getName());
                continue;
            }
            mapper.initialize(newClassObject, feature);
        }
        return newClassObject;
    }

    public ObjyObject getObject(CDOID cdoId) {
        if (cdoId == null) {
            return null;
        }
        ooId oid = OBJYCDOIDUtil.getooId(cdoId);
        return this.getObject(oid);
    }

    public ObjyObject getObject(ooId oid) {
        ObjyObject objyObject = null;
        if (oid == null) {
            return objyObject;
        }
        objyObject = this.idToObjyObjectMap.get(OBJYCDOIDUtil.getLong(oid));
        if (objyObject == null) {
            try {
                objyObject = this.getObjectFromClassObject(Class_Object.class_object_from_oid((ooId)oid));
            }
            catch (ObjyRuntimeException ex) {
                ex.printStackTrace();
            }
        }
        return objyObject;
    }

    private ObjyObject getObjectFromClassObject(Class_Object classObject) {
        ObjyObject objyObject = new ObjyObject(classObject);
        this.idToObjyObjectMap.put(OBJYCDOIDUtil.getLong(objyObject.ooId()), objyObject);
        return objyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ObjyObject objyObject) {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("ObjyObjectManager.delete(" + objyObject.ooId().getStoreString() + ")");
        }
        WeakHashMap<Long, ObjyObject> weakHashMap = this.idToObjyObjectMap;
        synchronized (weakHashMap) {
            this.idToObjyObjectMap.remove(OBJYCDOIDUtil.getLong(objyObject.ooId()));
        }
    }

    public ObjyObject copyRevision(ObjectivityStoreAccessor storeAccessor, ObjyObject objyObject) {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("ObjyObjectManager.copyRevision(" + objyObject.ooId().getStoreString() + ")");
        }
        EClass eClass = ObjySchema.getEClass(storeAccessor.getStore(), objyObject.objyClass());
        ObjyObject newObjyRevision = objyObject.copy(eClass);
        objyObject.addToRevisions(newObjyRevision);
        return newObjyRevision;
    }

    public ObjyPlacementManager getGlobalPlacementManager() {
        return this.globalPlacementManager;
    }
}

