/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.db.app.Iterator;
import com.objy.db.app.Session;
import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import com.objy.db.util.ooMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyPackageInfo;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyPackageUnit;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.OBJYCDOIDUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.ObjyDb;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.SmartLock;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyPackageHandler {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyPackageHandler.class);
    private static final ContextTracer TRACER_INFO = new ContextTracer(OM.INFO, ObjyPackageHandler.class);
    protected ooId packageMapId;
    private boolean zipped = true;

    public ObjyPackageHandler(String repositoryName) {
        this.packageMapId = ObjyDb.getOrCreatePackageMap(repositoryName);
    }

    public static ooId create(ooId scopeContOid) {
        ooMap map = new ooMap();
        ooObj clusterObject = ooObj.create_ooObj((ooId)scopeContOid);
        clusterObject.cluster((Object)map);
        return map.getOid();
    }

    public void writePackages(CDOPackageRegistry packageRegistry, InternalCDOPackageUnit packageUnit, OMMonitor monitor) {
        try {
            ooMap packageMap = this.getMap();
            SmartLock.lock(packageMap.getContainer());
            InternalCDOPackageInfo[] packageInfos = packageUnit.getPackageInfos();
            monitor.begin((double)(1 + packageInfos.length));
            if (TRACER_INFO.isEnabled()) {
                TRACER_INFO.format("Writing package unit: {0}", new Object[]{packageUnit});
            }
            byte[] ePackageAsBytes = this.getEPackageBytes(packageRegistry, packageUnit);
            ObjyPackageUnit objyPackageUnit = new ObjyPackageUnit(ePackageAsBytes.length);
            packageMap.cluster((Object)objyPackageUnit);
            objyPackageUnit.setId(packageUnit.getID());
            objyPackageUnit.setOrdinal(packageUnit.getOriginalType().ordinal());
            objyPackageUnit.setTimeStamp(packageUnit.getTimeStamp());
            objyPackageUnit.setPackageAsBytes(ePackageAsBytes);
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("... writing ObjyPackageUnit.getId(): " + objyPackageUnit.getId());
            }
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageInfos;
            int n = packageInfos.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
                ObjyPackageInfo objyPackageInfo = this.createPackageInfo(packageInfo, monitor);
                objyPackageUnit.addPackageInfo(objyPackageInfo);
                String objyPackageName = ObjySchema.getObjyPackageName(packageInfo.getPackageURI());
                ObjySchema.setPackageNameMapping(packageInfo.getPackageURI(), objyPackageName);
                ObjySchema.setPackageNameMapping(objyPackageName, packageInfo.getPackageURI());
                EPackage ePackage = packageInfo.getEPackage();
                ObjySchema.registerEPackage(ePackage);
                ++n2;
            }
            packageMap.add((Object)objyPackageUnit, objyPackageUnit.getId());
        }
        finally {
            monitor.done();
        }
    }

    private ObjyPackageInfo createPackageInfo(InternalCDOPackageInfo packageInfo, OMMonitor monitor) {
        if (TRACER_INFO.isEnabled()) {
            TRACER_INFO.format("Writing package info: {0}", new Object[]{packageInfo});
        }
        ObjyPackageInfo ooPackageInfo = new ObjyPackageInfo();
        ooPackageInfo.setPackageURI(packageInfo.getPackageURI());
        ooPackageInfo.setParentURI(packageInfo.getParentURI());
        ooPackageInfo.setUnitID(packageInfo.getPackageUnit().getID());
        ooPackageInfo.setPackageName(packageInfo.getEPackage().getName());
        CDOIDMetaRange metaIDRange = packageInfo.getMetaIDRange();
        long metaLB = metaIDRange == null ? 0L : ((CDOIDMeta)metaIDRange.getLowerBound()).getLongValue();
        long metaUB = metaIDRange == null ? 0L : ((CDOIDMeta)metaIDRange.getUpperBound()).getLongValue();
        ooPackageInfo.setMetaLB(metaLB);
        ooPackageInfo.setMetaUB(metaUB);
        return ooPackageInfo;
    }

    private byte[] getEPackageBytes(CDOPackageRegistry packageRegistry, InternalCDOPackageUnit packageUnit) {
        EPackage ePackage = packageUnit.getTopLevelPackageInfo().getEPackage();
        return EMFUtil.getEPackageBytes((EPackage)ePackage, (boolean)this.zipped, (EPackage.Registry)packageRegistry);
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        HashMap<ObjyPackageUnit, InternalCDOPackageUnit> packageUnitsMap = new HashMap<ObjyPackageUnit, InternalCDOPackageUnit>();
        ooMap packageMap = this.getMap();
        Iterator itr = packageMap.elements();
        while (itr.hasNext()) {
            ObjyPackageUnit objyPackageUnit = (ObjyPackageUnit)((Object)itr.next());
            InternalCDOPackageUnit packageUnit = this.createPackageUnit();
            packageUnit.setOriginalType(CDOPackageUnit.Type.values()[objyPackageUnit.getOrdinal()]);
            packageUnit.setTimeStamp(objyPackageUnit.getTimeStamp());
            packageUnitsMap.put(objyPackageUnit, packageUnit);
            if (!TRACER_INFO.isEnabled()) continue;
            TRACER_INFO.format("Read package unit: {0}", new Object[]{packageUnit});
        }
        for (Map.Entry entry : packageUnitsMap.entrySet()) {
            List<ObjyPackageInfo> objyPackageInfoList = ((ObjyPackageUnit)((Object)entry.getKey())).getPackageInfos();
            ArrayList<InternalCDOPackageInfo> packageInfoList = new ArrayList<InternalCDOPackageInfo>();
            for (ObjyPackageInfo objyPackageInfo : objyPackageInfoList) {
                InternalCDOPackageInfo packageInfo = this.createPackageInfo(objyPackageInfo);
                packageInfoList.add(packageInfo);
                String objyPackageName = ObjySchema.getObjyPackageName(packageInfo.getPackageURI());
                ObjySchema.setPackageNameMapping(packageInfo.getPackageURI(), objyPackageName);
                ObjySchema.setPackageNameMapping(objyPackageName, packageInfo.getPackageURI());
            }
            InternalCDOPackageInfo[] array = packageInfoList.toArray(new InternalCDOPackageInfo[packageInfoList.size()]);
            ((InternalCDOPackageUnit)entry.getValue()).setPackageInfos(array);
        }
        return packageUnitsMap.values();
    }

    protected InternalCDOPackageUnit createPackageUnit() {
        return (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
    }

    protected InternalCDOPackageInfo createPackageInfo() {
        return (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
    }

    private InternalCDOPackageInfo createPackageInfo(ObjyPackageInfo ooPackageInfo) {
        if (TRACER_INFO.isEnabled()) {
            TRACER_INFO.format("create package info: {0}", new Object[]{ooPackageInfo});
        }
        InternalCDOPackageInfo packageInfo = this.createPackageInfo();
        packageInfo.setPackageURI(ooPackageInfo.getPackageURI());
        packageInfo.setParentURI(ooPackageInfo.getParentURI());
        long metaLB = ooPackageInfo.getMetaLB();
        long metaUB = ooPackageInfo.getMetaUB();
        CDOIDMetaRange metaIDRange = metaLB == 0L ? null : OBJYCDOIDUtil.createMetaRange((CDOID)OBJYCDOIDUtil.createMeta(metaLB), (int)(metaUB - metaLB) + 1);
        packageInfo.setMetaIDRange(metaIDRange);
        return packageInfo;
    }

    public byte[] readPackageBytes(InternalCDOPackageUnit packageUnit) {
        byte[] bytes = null;
        ooMap map = this.getMap();
        String packageUnitId = packageUnit.getID();
        if (TRACER_INFO.isEnabled()) {
            TRACER_INFO.format("Looking for package unit with ID: {0}", new Object[]{packageUnitId});
        }
        if (map.isMember(packageUnitId)) {
            if (TRACER_INFO.isEnabled()) {
                TRACER_INFO.format("Reading package unit with ID: {0}", new Object[]{packageUnitId});
            }
            ObjyPackageUnit objyPackageUnit = (ObjyPackageUnit)((Object)map.lookup(packageUnitId));
            bytes = objyPackageUnit.getPackageAsBytes();
        }
        return bytes;
    }

    private ooMap getMap() {
        ooMap map = null;
        map = (ooMap)Session.getCurrent().getFD().objectFrom(this.packageMapId);
        return map;
    }
}

