/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.as.app.d_Attribute;
import com.objy.as.app.d_Class;
import com.objy.as.app.d_Module;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStore;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyClass;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyClassProposed;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ITypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ObjyMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyArrayListId;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyArrayListString;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBase;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyFeatureMapArrayList;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyProxy;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyResourceList;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjySchema {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjySchema.class);
    private static HashMap<String, ObjyClass> mapOfObjyClasses = new HashMap();
    private static HashMap<String, EClass> mapOfEClasses = new HashMap();
    private static HashMap<EClass, EClass> visitedClasses = new HashMap();
    private static HashMap<EClass, EClass> visitedStructureOnlyClasses = new HashMap();
    private static Map<String, String> packageNameMapping = new HashMap<String, String>();
    private static d_Module topModule = null;

    public static void resetCache() {
        topModule = null;
        mapOfObjyClasses.clear();
        mapOfEClasses.clear();
        visitedClasses.clear();
        visitedStructureOnlyClasses.clear();
    }

    public static ObjyClass getObjyClass(String name) {
        ObjyClass classObject = mapOfObjyClasses.get(name);
        if (classObject == null) {
            d_Class newClass = ObjySchema.getTopModule().resolve_class(name);
            classObject = new ObjyClass(newClass);
            mapOfObjyClasses.put(name, classObject);
        }
        return classObject;
    }

    public static d_Module getTopModule() {
        if (topModule == null) {
            topModule = d_Module.top_level();
        }
        return topModule;
    }

    public static String getObjectivityClassName(EClassifier eClassifier) {
        return ObjySchema.formObjectivityClassName(eClassifier, false);
    }

    static String formObjectivityClassName(EClassifier eClassifier, boolean onlyStructure) {
        if (eClassifier == EcorePackage.eINSTANCE.getEObject()) {
            return "ooObj";
        }
        String nsURI = eClassifier.getEPackage().getNsURI();
        String objyPackageName = ObjySchema.getObjyPackageName(nsURI);
        if (onlyStructure) {
            return String.valueOf(objyPackageName) + ":" + eClassifier.getName() + "_ST";
        }
        return String.valueOf(objyPackageName) + ":" + eClassifier.getName();
    }

    public static void setPackageNameMapping(String name1, String name2) {
        if (packageNameMapping.get(name1) == null) {
            packageNameMapping.put(name1, name2);
        }
    }

    public static String getPackageNameMapping(String key) {
        return packageNameMapping.get(key);
    }

    public static void registerEPackage(EPackage ePackage) {
        for (EClassifier eClass : ePackage.getEClassifiers()) {
            if (!(eClass instanceof EClass)) continue;
            ObjySchema.getOrCreate(eClass.eClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjyClass getOrCreate(EClass eClass) {
        String className = ObjySchema.getObjectivityClassName((EClassifier)eClass);
        ObjyClass objyClass = mapOfObjyClasses.get(className);
        if (objyClass != null) {
            return objyClass;
        }
        d_Module d_Module2 = ObjySchema.getTopModule();
        synchronized (d_Module2) {
            d_Class dClass = ObjySchema.getTopModule().resolve_class(className);
            objyClass = dClass == null ? ObjySchema.createObjyClass(eClass) : (!ObjySchema.isSameClass(dClass, eClass) ? ObjySchema.evolveObjyClass(eClass) : new ObjyClass(dClass));
            if (objyClass == null) {
                throw new RuntimeException("Cannot retrieved " + eClass.getName() + " class from Objy schema as:" + className);
            }
            String asClassName = objyClass.getASClassName();
            mapOfObjyClasses.put(asClassName, objyClass);
            mapOfEClasses.put(asClassName, eClass);
        }
        return objyClass;
    }

    private static ObjyClass createObjyClass(EClass eClass) {
        try {
            String className = ObjySchema.getObjectivityClassName((EClassifier)eClass);
            ObjySchema.createObjyClassSchema(eClass, false);
            ObjySchema.getTopModule().activate_proposals(true, true);
            d_Class dClass = ObjySchema.getTopModule().resolve_class(className);
            ObjyClass objyClass = new ObjyClass(dClass);
            return objyClass;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static ObjyClass evolveObjyClass(EClass eClass) {
        try {
            String className = ObjySchema.getObjectivityClassName((EClassifier)eClass);
            ObjySchema.evolveObjyClassSchema(eClass, false);
            ObjySchema.getTopModule().activate_proposals(true, true);
            d_Class dClass = ObjySchema.getTopModule().resolve_class(className);
            ObjyClass objyClass = new ObjyClass(dClass);
            return objyClass;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    static void createObjyClassSchema(EClass eClass, boolean onlyStructure) {
        HashMap<EClass, EClass> hashMap;
        HashMap<EClass, EClass> hashMap2 = hashMap = onlyStructure ? visitedStructureOnlyClasses : visitedClasses;
        if (hashMap.containsKey(eClass)) {
            return;
        }
        hashMap.put(eClass, eClass);
        String className = ObjySchema.formObjectivityClassName((EClassifier)eClass, onlyStructure);
        d_Class dClass = ObjySchema.getTopModule().resolve_class(className);
        if (dClass != null) {
            return;
        }
        if (ObjySchema.getTopModule().resolve_proposed_class(className) == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Creating new class: " + className);
            }
            ObjyClassProposed proposedClass = new ObjyClassProposed(ObjySchema.getTopModule(), eClass, onlyStructure);
            proposedClass.propose();
        }
    }

    static void evolveObjyClassSchema(EClass eClass, boolean onlyStructure) {
        String className = ObjySchema.formObjectivityClassName((EClassifier)eClass, onlyStructure);
        if (ObjySchema.getTopModule().resolve_proposed_class(className) == null) {
            d_Class dClass = ObjySchema.getTopModule().resolve_class(className);
            TRACER_DEBUG.trace("Evolving class: " + className);
            ObjyClassProposed proposedClass = new ObjyClassProposed(ObjySchema.getTopModule(), eClass, onlyStructure);
            proposedClass.evolve(dClass);
        }
    }

    static boolean isSameClass(d_Class dClass, EClass eClass) {
        for (EClass superType : eClass.getESuperTypes()) {
            ObjySchema.getOrCreate(superType);
        }
        for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
            d_Attribute dAttr;
            ITypeMapper mapper;
            if (!(feature instanceof EAttribute) && !(feature instanceof EReference) || (mapper = ObjyMapper.INSTANCE.getTypeMapper(feature)) == null || (dAttr = dClass.resolve_attribute(feature.getName())) != null) continue;
            return false;
        }
        return true;
    }

    public static EClass getEClass(ObjectivityStore store, ObjyClass objyClass) {
        String className = objyClass.getASClassName();
        return ObjySchema.getEClass(store, className);
    }

    public static EClass getEClass(ObjectivityStore store, String className) {
        EClass eClass = mapOfEClasses.get(className);
        if (eClass == null) {
            String nsURI;
            String[] splits = className.split(":");
            InternalCDOPackageRegistry registry = store.getRepository().getPackageRegistry();
            EPackage packageObject = registry.getEPackage(nsURI = ObjySchema.getPackageNameMapping(splits[0]));
            if (packageObject == null) {
                throw new RuntimeException("Package not found " + splits[1] + " for class name " + className);
            }
            eClass = (EClass)packageObject.getEClassifier(splits[splits.length - 1]);
            mapOfEClasses.put(className, eClass);
        }
        return eClass;
    }

    public static boolean isResource(ObjectivityStore store, ObjyClass objyClass) {
        EClass eClass = ObjySchema.getEClass(store, objyClass);
        return eClass == EresourcePackage.Literals.CDO_RESOURCE || eClass == EresourcePackage.Literals.CDO_RESOURCE_NODE || eClass == EresourcePackage.Literals.CDO_RESOURCE_FOLDER;
    }

    public static void createBaseSchema() {
        ObjyArrayListId.buildSchema();
        ObjyFeatureMapArrayList.buildSchema();
        ObjyProxy.buildSchema();
        ObjyArrayListString.buildSchema();
        ObjyBase.buildSchema();
        ObjyResourceList.buildSchema();
    }

    public static String getObjyPackageName(String packageURI) {
        String[] splits;
        String name = "";
        boolean first = true;
        String[] stringArray = splits = packageURI.split("://");
        int n = splits.length;
        int n2 = 0;
        while (n2 < n) {
            String strValue = stringArray[n2];
            if (!strValue.equals("http")) {
                if (!first) {
                    name = name.concat("_");
                } else {
                    first = false;
                }
                name = name.concat(strValue);
            }
            ++n2;
        }
        name = name.replace("/", ".");
        name = name.replace(".", "_");
        return name;
    }
}

