/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.as.app.Class_Object;
import com.objy.db.ObjyRuntimeException;
import com.objy.db.app.Session;
import com.objy.db.app.ooContObj;
import com.objy.db.app.ooDBObj;
import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySession;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjyScope {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyScope.class);
    private ooContObj contObj;
    private ooDBObj dbObj;
    private String dbName;
    private String contName;

    public static void insureScopeExist(ObjySession objySession, String dbName, String contName) {
        try {
            ooDBObj db = !objySession.getFD().hasDB(dbName) ? Session.getCurrent().getFD().newDB(dbName) : Session.getCurrent().getFD().lookupDB(dbName);
            if (db.hasContainer(contName)) {
                ooContObj cont = db.lookupContainer(contName);
            } else {
                ooContObj cont = new ooContObj();
                db.addContainer(cont, 0, contName, 0L, 0L);
            }
        }
        catch (ObjyRuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public ObjyScope(String dbName, String contName) {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace(" DB: " + dbName + " - CT: " + contName);
        }
        this.dbName = dbName;
        this.contName = contName;
        this.init();
    }

    public ooId getScopeContOid() {
        return this.getContainerObj().getOid();
    }

    public ooId getScopeDbOid() {
        return this.getDatabaseObj().getOid();
    }

    private void init() {
        this.getContainerObj();
    }

    public ooContObj getContainerObj() {
        if (this.contObj == null) {
            ooDBObj db = this.getDatabaseObj();
            this.contObj = db.hasContainer(this.contName) ? db.lookupContainer(this.contName) : this.createNewContainer(this.contName);
        }
        return this.contObj;
    }

    public ooDBObj getDatabaseObj() {
        if (this.dbObj == null) {
            this.dbObj = !Session.getCurrent().getFD().hasDB(this.dbName) ? Session.getCurrent().getFD().newDB(this.dbName) : Session.getCurrent().getFD().lookupDB(this.dbName);
        }
        return this.dbObj;
    }

    private ooContObj createNewContainer(String name) {
        ooDBObj db = this.getDatabaseObj();
        ooContObj cont = new ooContObj();
        db.addContainer(cont, 0, name, 0L, 0L);
        return cont;
    }

    public String getDbName() {
        return this.dbName;
    }

    public ObjyObject lookupObjyObject(String nameObject) {
        ObjyObject objyObject = null;
        ooId oid = this.lookupObjectOid(nameObject);
        objyObject = new ObjyObject(Class_Object.class_object_from_oid((ooId)oid));
        return objyObject;
    }

    public ooId lookupObjectOid(String nameObject) {
        ooObj anObj = null;
        anObj = (ooObj)this.getContainerObj().lookupObj(nameObject);
        return anObj.getOid();
    }

    public ooObj lookupObject(String nameObject) {
        ooObj anObj = null;
        anObj = (ooObj)this.getContainerObj().lookupObj(nameObject);
        return anObj;
    }

    public void nameObj(String objName, ObjyObject objyObject) {
        ooId oid = objyObject.ooId();
        this.nameObj(objName, oid);
    }

    public void nameObj(String objName, ooId oid) {
        ooObj object = ooObj.create_ooObj((ooId)oid);
        this.nameObj(objName, object);
    }

    public void nameObj(String objName, ooObj obj) {
        this.getContainerObj().nameObj((Object)obj, objName);
    }
}

