/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.db;

import com.objy.db.app.Session;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyConnection;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObjectManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBranchManager;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyResourceList;
import org.eclipse.emf.cdo.server.internal.objectivity.utils.ObjyDb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjySession
extends Session {
    private ObjyObjectManager objectManger = null;
    private ObjyResourceList resourceList = null;
    private ObjyBranchManager branchManager = null;
    protected String sessionName;
    protected ConcurrentHashMap<String, ObjySession> sessionPool;
    protected boolean available;

    public ObjySession(String name, ConcurrentHashMap<String, ObjySession> pool, ObjyConnection objyConnection) {
        super(objyConnection.getMinSessionCacheSize(), objyConnection.getMaxSessionCacheSize());
        this.setThreadPolicy(1);
        this.sessionName = name;
        this.sessionPool = pool;
        this.objectManger = new ObjyObjectManager(objyConnection.getDefaultPlacementManager());
    }

    public ObjyObjectManager getObjectManager() {
        return this.objectManger;
    }

    public ObjyBranchManager getBranchManager(String repositoryName) {
        if (this.branchManager == null) {
            this.branchManager = ObjyDb.getOrCreateBranchManager(repositoryName);
        }
        return this.branchManager;
    }

    public void setAvailable(boolean value) {
        this.available = value;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public String getName() {
        return this.sessionName;
    }

    public ConcurrentHashMap<String, ObjySession> getPool() {
        return this.sessionPool;
    }

    public ObjyResourceList getResourceList(String repositoryName) {
        if (this.resourceList == null) {
            this.resourceList = new ObjyResourceList(this, ObjyDb.getOrCreateResourceList(repositoryName));
        }
        return this.resourceList;
    }

    public synchronized void terminate() {
        this.resourceList = null;
        super.terminate();
    }
}

