/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.mapper;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Class_Position;
import com.objy.as.app.Numeric_Value;
import com.objy.as.app.Proposed_Class;
import com.objy.as.app.VArray_Object;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Attribute;
import com.objy.as.app.d_Type;
import com.objy.as.app.ooBaseType;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.BasicTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ISingleTypeMapper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ByteArrayTypeMapper
extends BasicTypeMapper
implements ISingleTypeMapper {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ByteArrayTypeMapper.class);
    static ByteArrayTypeMapper INSTANCE = new ByteArrayTypeMapper();

    protected ooBaseType getObjyBaseType() {
        return ooBaseType.ooINT8;
    }

    public Object getValue(ObjyObject objyObject, EStructuralFeature feature) {
        Class_Position position = this.getAttributePosition(objyObject, feature);
        VArray_Object vArray = objyObject.get_varray(position);
        Class_Position nullPosition = this.getNullAttributePosition(objyObject, feature);
        boolean isNull = objyObject.get_numeric(nullPosition).booleanValue();
        if (isNull) {
            return null;
        }
        int size = (int)vArray.size();
        byte[] byteArray = new byte[size];
        int i = 0;
        while (i < size) {
            Numeric_Value value = vArray.get_numeric((long)i);
            byteArray[i] = value.byteValue();
            ++i;
        }
        return byteArray;
    }

    public void setValue(ObjyObject objyObject, EStructuralFeature feature, Object newValue) {
        Class_Position position = this.getAttributePosition(objyObject, feature);
        VArray_Object vArray = objyObject.get_varray(position);
        Class_Position nullPosition = this.getNullAttributePosition(objyObject, feature);
        Numeric_Value isNullValue = newValue == null ? numericTrue : numericFalse;
        objyObject.set_numeric(nullPosition, isNullValue);
        if (newValue == null) {
            vArray.resize(0L);
            return;
        }
        byte[] byteArray = (byte[])newValue;
        if (vArray.size() != (long)byteArray.length) {
            vArray.resize((long)byteArray.length);
        }
        int i = 0;
        while (i < byteArray.length) {
            Byte byteValue = byteArray[i];
            Numeric_Value numericValue = new Numeric_Value(byteValue.byteValue());
            vArray.set_numeric((long)i, numericValue);
            ++i;
        }
    }

    public boolean createSchema(Proposed_Class proposedClass, EStructuralFeature feature) {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Adding attribute " + feature.getName() + "  " + this.getClass().getName());
        }
        proposedClass.add_varray_attribute(-1, d_Access_Kind.d_PUBLIC, this.getAttributeName(feature), 1L, this.getObjyBaseType());
        proposedClass.add_basic_attribute(-1, d_Access_Kind.d_PUBLIC, this.getNullAttributeName(feature), 1L, ooBaseType.ooBOOLEAN);
        return false;
    }

    public boolean validate(d_Attribute ooAttribute, EStructuralFeature feature) {
        d_Type type = ooAttribute.type_of();
        return type.is_varray_basic_type();
    }

    public Object remove(ObjyObject objyObject, EStructuralFeature feature) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    public void delete(ObjyObject objyObject, EStructuralFeature feature) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    public void initialize(Class_Object classObject, EStructuralFeature feature) {
        Class_Position position = classObject.type_of().position_in_class(feature.getName());
        VArray_Object vArray = classObject.get_varray(position);
        vArray.resize(0L);
    }

    public void modifySchema(Proposed_Class proposedooClass, EStructuralFeature feature) {
        throw new UnsupportedOperationException("Implement me!!");
    }
}

