/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.mapper;

import com.objy.as.app.Basic_Type;
import com.objy.as.app.Class_Object;
import com.objy.as.app.Class_Position;
import com.objy.as.app.Numeric_Value;
import com.objy.as.app.Proposed_Basic_Attribute;
import com.objy.as.app.Proposed_Class;
import com.objy.as.app.Proposed_Property;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Attribute;
import com.objy.as.app.d_Type;
import com.objy.as.app.ooBaseType;
import java.util.Date;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.BasicTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ISingleTypeMapper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class NumericTypeMapper
extends BasicTypeMapper
implements ISingleTypeMapper {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, NumericTypeMapper.class);
    public static TMBoolean TMBOOLEAN = new TMBoolean();
    public static TMByte TMBYTE = new TMByte();
    public static TMChar TMCHAR = new TMChar();
    public static TMDate TMDATE = new TMDate();
    public static TMDouble TMDOUBLE = new TMDouble();
    public static TMFloat TMFLOAT = new TMFloat();
    public static TMInteger TMINTEGER = new TMInteger();
    public static TMLong TMLONG = new TMLong();
    public static TMShort TMSHORT = new TMShort();

    protected abstract Object fromNumericValue(Numeric_Value var1, boolean var2);

    protected abstract Numeric_Value toNumericValue(Object var1);

    protected abstract ooBaseType getObjyBaseType();

    public boolean createSchema(Proposed_Class proposedClass, EStructuralFeature feature) {
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace("Adding attribute " + feature.getName() + "  " + this.getClass().getName());
        }
        proposedClass.add_basic_attribute(-1, d_Access_Kind.d_PUBLIC, this.getAttributeName(feature), 1L, this.getObjyBaseType());
        proposedClass.add_basic_attribute(-1, d_Access_Kind.d_PUBLIC, this.getNullAttributeName(feature), 1L, ooBaseType.ooBOOLEAN);
        return false;
    }

    public void modifySchema(Proposed_Class proposedooClass, EStructuralFeature feature) {
        Proposed_Property prop = proposedooClass.resolve_property(this.getAttributeName(feature));
        if (prop instanceof Proposed_Basic_Attribute) {
            Proposed_Basic_Attribute attr = (Proposed_Basic_Attribute)prop;
            attr.change_base_type(this.getObjyBaseType());
        }
    }

    public boolean validate(d_Attribute ooAttribute, EStructuralFeature feature) {
        d_Type type = ooAttribute.type_of();
        if (TRACER_DEBUG.isEnabled()) {
            TRACER_DEBUG.trace(String.valueOf(this.getAttributeName(feature)) + " " + ((Basic_Type)type).base_type() + " basic type " + type.is_basic_type() + " - " + this.getObjyBaseType());
        }
        return type.is_basic_type() && ((Basic_Type)type).base_type() == this.getObjyBaseType();
    }

    public Object getValue(ObjyObject objyObject, EStructuralFeature feature) {
        Numeric_Value numericValue = null;
        Class_Position nullPosition = this.getNullAttributePosition(objyObject, feature);
        boolean isNull = objyObject.get_numeric(nullPosition).booleanValue();
        if (!isNull) {
            Class_Position position = this.getAttributePosition(objyObject, feature);
            numericValue = objyObject.get_numeric(position);
        }
        return this.fromNumericValue(numericValue, isNull);
    }

    public void setValue(ObjyObject objyObject, EStructuralFeature feature, Object newValue) {
        boolean isNull = newValue == null || newValue == CDORevisionData.NIL;
        Numeric_Value isNullValue = isNull ? numericTrue : numericFalse;
        Class_Position nullPosition = this.getNullAttributePosition(objyObject, feature);
        if (!isNull) {
            Class_Position position = this.getAttributePosition(objyObject, feature);
            Numeric_Value numericValue = this.toNumericValue(newValue);
            objyObject.set_numeric(position, numericValue);
        }
        objyObject.set_numeric(nullPosition, isNullValue);
    }

    public Object remove(ObjyObject objyObject, EStructuralFeature feature) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    public void delete(ObjyObject objyObject, EStructuralFeature feature) {
        Class_Position position = this.getNullAttributePosition(objyObject, feature);
        objyObject.set_numeric(position, numericTrue);
    }

    public void initialize(Class_Object classObject, EStructuralFeature feature) {
        Class_Position position = classObject.type_of().position_in_class(this.getNullAttributeName(feature));
        classObject.set_numeric(position, numericTrue);
    }

    public static class TMBoolean
    extends NumericTypeMapper {
        protected ooBaseType getObjyBaseType() {
            return ooBaseType.ooBOOLEAN;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Boolean value = null;
            if (!isNull) {
                value = numericValue.booleanValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(false);
            }
            return new Numeric_Value(((Boolean)value).booleanValue());
        }
    }

    public static class TMByte
    extends NumericTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT8;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Byte value = null;
            if (!isNull) {
                value = numericValue.byteValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Byte)value).byteValue());
        }
    }

    public static class TMChar
    extends NumericTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT8;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Character value = null;
            if (!isNull) {
                value = Character.valueOf(numericValue.charValue());
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Character)value).charValue());
        }
    }

    public static class TMDate
    extends NumericTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT64;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Date value = null;
            if (!isNull) {
                value = new Date(numericValue.longValue());
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Date)value).getTime());
        }
    }

    public static class TMDouble
    extends NumericTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooFLOAT64;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Double value = null;
            if (!isNull) {
                value = numericValue.doubleValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0.0);
            }
            return new Numeric_Value(((Double)value).doubleValue());
        }
    }

    public static class TMFloat
    extends NumericTypeMapper {
        protected ooBaseType getObjyBaseType() {
            return ooBaseType.ooFLOAT64;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Float value = null;
            if (!isNull) {
                value = Float.valueOf(numericValue.floatValue());
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0.0);
            }
            return new Numeric_Value(((Float)value).floatValue());
        }
    }

    public static class TMInteger
    extends NumericTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT32;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Integer value = null;
            if (!isNull) {
                value = numericValue.intValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Integer)value).intValue());
        }
    }

    public static class TMLong
    extends NumericTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT64;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Long value = null;
            if (!isNull) {
                value = numericValue.longValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Long)value).longValue());
        }
    }

    public static class TMShort
    extends NumericTypeMapper {
        public ooBaseType getObjyBaseType() {
            return ooBaseType.ooINT16;
        }

        protected Object fromNumericValue(Numeric_Value numericValue, boolean isNull) {
            Short value = null;
            if (!isNull) {
                value = numericValue.shortValue();
            }
            return value;
        }

        protected Numeric_Value toNumericValue(Object value) {
            if (value == null) {
                return new Numeric_Value(0);
            }
            return new Numeric_Value(((Short)value).shortValue());
        }
    }
}

