/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.mapper;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Class_Position;
import com.objy.as.app.Numeric_Value;
import com.objy.as.app.Proposed_Class;
import com.objy.as.app.String_Value;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Attribute;
import com.objy.as.app.ooBaseType;
import com.objy.db.ObjyRuntimeException;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.BasicTypeMapper;
import org.eclipse.emf.cdo.server.internal.objectivity.mapper.ISingleTypeMapper;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StringTypeMapper
extends BasicTypeMapper
implements ISingleTypeMapper {
    public static StringTypeMapper INSTANCE = new StringTypeMapper();

    protected String getNullAttributeName(EStructuralFeature feature) {
        return String.valueOf(feature.getName()) + "_isNull";
    }

    public boolean createSchema(Proposed_Class proposedClass, EStructuralFeature feature) {
        try {
            proposedClass.add_embedded_class_attribute(-1, d_Access_Kind.d_PUBLIC, feature.getName(), 1L, "ooUtf8String");
            proposedClass.add_basic_attribute(-1, d_Access_Kind.d_PUBLIC, this.getNullAttributeName(feature), 1L, ooBaseType.ooBOOLEAN);
        }
        catch (ObjyRuntimeException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public Object getValue(ObjyObject objyObject, EStructuralFeature feature) {
        Class_Position position = this.getAttributePosition(objyObject, feature);
        Class_Position nullPosition = this.getNullAttributePosition(objyObject, feature);
        String_Value stringValue = objyObject.get_string(position);
        boolean isNull = objyObject.get_numeric(nullPosition).booleanValue();
        String value = null;
        if (!isNull) {
            value = stringValue.toString();
        }
        return value;
    }

    public void setValue(ObjyObject objyObject, EStructuralFeature feature, Object newValue) {
        boolean isNull = newValue == null || newValue == CDORevisionData.NIL;
        Class_Position nullPosition = this.getNullAttributePosition(objyObject, feature);
        if (!isNull) {
            Class_Position position = this.getAttributePosition(objyObject, feature);
            String_Value stringValue = objyObject.get_string(position);
            stringValue.update();
            stringValue.set((String)newValue);
        }
        Numeric_Value isNullValue = newValue == null ? numericTrue : numericFalse;
        objyObject.set_numeric(nullPosition, isNullValue);
    }

    public Object remove(ObjyObject objyObject, EStructuralFeature feature) {
        throw new UnsupportedOperationException("Implement me!!");
    }

    public void delete(ObjyObject objyObject, EStructuralFeature feature) {
        Class_Position position = this.getNullAttributePosition(objyObject, feature);
        objyObject.set_numeric(position, numericTrue);
    }

    public void initialize(Class_Object classObject, EStructuralFeature feature) {
        Class_Position position = classObject.type_of().position_in_class(this.getNullAttributeName(feature));
        classObject.set_numeric(position, numericTrue);
    }

    public void modifySchema(Proposed_Class proposedooClass, EStructuralFeature feature) {
    }

    public boolean validate(d_Attribute ooAttribute, EStructuralFeature feature) {
        System.out.println(">>>OBJYIMPL: StringTypeMapper.validate() - not implemented.");
        return true;
    }
}

