/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.schema;

import com.objy.db.app.ooObj;
import com.objy.db.util.ooTreeSetX;
import java.util.Iterator;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyBranch
extends ooObj {
    protected int branchId;
    protected int baseBranchId;
    protected long baseBranchTimeStamp;
    protected String branchName;
    protected ooTreeSetX revisions;

    public static ObjyBranch create(ooObj clusterObj, int branchId, int baseBranchId, String branchName, long timeStamp) {
        ObjyBranch objyBranch = new ObjyBranch(branchId, baseBranchId, branchName, timeStamp);
        clusterObj.cluster((Object)objyBranch);
        objyBranch.createRevisionsSet();
        return objyBranch;
    }

    public static ObjyBranch create(ooObj clusterObj, int branchId, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        ObjyBranch objyBranch = new ObjyBranch(branchId, branchInfo);
        clusterObj.cluster((Object)objyBranch);
        objyBranch.createRevisionsSet();
        return objyBranch;
    }

    private ObjyBranch(int id, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        this.branchId = id;
        this.baseBranchId = branchInfo.getBaseBranchID();
        this.baseBranchTimeStamp = branchInfo.getBaseTimeStamp();
        this.branchName = branchInfo.getName();
        this.revisions = null;
    }

    private ObjyBranch(int branchId, int baseBranchId, String branchName, long timeStamp) {
        this.branchId = branchId;
        this.baseBranchId = baseBranchId;
        this.baseBranchTimeStamp = timeStamp;
        this.branchName = branchName;
        this.revisions = null;
    }

    public int getBranchId() {
        this.fetch();
        return this.branchId;
    }

    public int getBaseBranchId() {
        this.fetch();
        return this.baseBranchId;
    }

    public long getBaseBranchTimeStamp() {
        this.fetch();
        return this.baseBranchTimeStamp;
    }

    public String getBranchName() {
        this.fetch();
        return this.branchName;
    }

    public void addRevision(ooObj anObj) {
        this.markModified();
        if (this.revisions == null) {
            this.revisions = new ooTreeSetX();
            this.cluster(this.revisions);
        }
        this.revisions.add((Object)anObj);
    }

    public int numberOfRevisions() {
        this.fetch();
        return this.revisions.size();
    }

    public Iterator<?> getRevisions() {
        this.fetch();
        return this.revisions.iterator();
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo getBranchInfo() {
        this.fetch();
        InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo = new InternalCDOBranchManager.BranchLoader.BranchInfo(this.getBranchName(), this.getBaseBranchId(), this.getBaseBranchTimeStamp());
        return branchInfo;
    }

    public boolean deleteRevision(Object anObject) {
        this.markModified();
        return this.revisions.remove(anObject);
    }

    private void createRevisionsSet() {
        if (this.revisions == null) {
            this.revisions = new ooTreeSetX();
            this.cluster(this.revisions);
        }
    }
}

