/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.schema;

import com.objy.db.app.ooId;
import com.objy.db.app.ooObj;
import com.objy.db.util.ooTreeSetX;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjyBranchManager
extends ooObj {
    protected int nextBranchId = 0;
    protected int nextLocalBranchId = 0;
    protected ooTreeSetX branchSet;

    private ObjyBranchManager() {
    }

    protected void createTreeSet(ooObj clusterObject) {
        this.branchSet = new ooTreeSetX();
        clusterObject.cluster((Object)this.branchSet);
    }

    public int getLastBranchId() {
        this.fetch();
        return this.nextBranchId;
    }

    public int nextBranchId() {
        this.markModified();
        return ++this.nextBranchId;
    }

    public int getlastLocalBranchId() {
        this.fetch();
        return this.nextLocalBranchId;
    }

    public int nextLocalBranchId() {
        this.markModified();
        return --this.nextLocalBranchId;
    }

    public int createBranch(int branchId, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        this.markModified();
        if (branchId == Integer.MAX_VALUE) {
            branchId = this.nextBranchId();
        } else if (branchId == Integer.MIN_VALUE) {
            branchId = this.nextLocalBranchId();
        }
        ObjyBranch newObjyBranch = ObjyBranch.create(this, branchId, branchInfo);
        this.branchSet.add((Object)newObjyBranch);
        return branchId;
    }

    public ObjyBranch getBranch(int branchId) {
        this.fetch();
        Iterator treeItr = this.branchSet.iterator();
        ObjyBranch objyBranch = null;
        while (treeItr.hasNext()) {
            objyBranch = (ObjyBranch)((Object)treeItr.next());
            if (branchId == objyBranch.getBranchId()) break;
        }
        return objyBranch;
    }

    public static ObjyBranchManager create(ooId scopeContOid) {
        ObjyBranchManager branchManager = new ObjyBranchManager();
        ooObj clusterObject = ooObj.create_ooObj((ooId)scopeContOid);
        clusterObject.cluster((Object)branchManager);
        branchManager.createTreeSet(branchManager);
        branchManager.createMainBranch();
        return branchManager;
    }

    public void createMainBranch() {
        ObjyBranch newObjyBranch = ObjyBranch.create(this, 0, 0, "MAIN", 0L);
        this.branchSet.add((Object)newObjyBranch);
    }

    public boolean deleteBranch(int branchId) {
        boolean done = false;
        this.markModified();
        Iterator treeItr = this.branchSet.iterator();
        ObjyBranch objyBranch = null;
        while (treeItr.hasNext()) {
            objyBranch = (ObjyBranch)((Object)treeItr.next());
            if (branchId != objyBranch.getBranchId()) continue;
            done = this.branchSet.remove((Object)objyBranch);
            break;
        }
        return done;
    }

    public List<ObjyBranch> getSubBranches(int baseBranchId) {
        this.fetch();
        ArrayList<ObjyBranch> objyBranchList = new ArrayList<ObjyBranch>();
        Iterator treeItr = this.branchSet.iterator();
        ObjyBranch objyBranch = null;
        while (treeItr.hasNext()) {
            objyBranch = (ObjyBranch)((Object)treeItr.next());
            if (objyBranch.getBranchId() == objyBranch.getBaseBranchId() || objyBranch.getBaseBranchId() != baseBranchId) continue;
            objyBranchList.add(objyBranch);
        }
        return objyBranchList;
    }

    public List<ObjyBranch> getBranches(int startId, int endId) {
        this.fetch();
        ArrayList<ObjyBranch> objyBranchList = new ArrayList<ObjyBranch>();
        int lastId = endId != 0 ? endId : Integer.MAX_VALUE;
        Iterator treeItr = this.branchSet.iterator();
        ObjyBranch objyBranch = null;
        while (treeItr.hasNext()) {
            objyBranch = (ObjyBranch)((Object)treeItr.next());
            int id = objyBranch.getBranchId();
            if (id < startId || id > lastId) continue;
            objyBranchList.add(objyBranch);
        }
        return objyBranchList;
    }
}

