/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.schema;

import com.objy.as.app.Class_Object;
import com.objy.as.app.Class_Position;
import com.objy.as.app.Proposed_Class;
import com.objy.as.app.d_Access_Kind;
import com.objy.as.app.d_Class;
import com.objy.as.app.d_Module;
import com.objy.db.ObjyRuntimeException;
import com.objy.db.app.ooId;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.internal.objectivity.ObjectivityStoreAccessor;
import org.eclipse.emf.cdo.server.internal.objectivity.bundle.OM;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjyObject;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySchema;
import org.eclipse.emf.cdo.server.internal.objectivity.db.ObjySession;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyArrayListId;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyProxy;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ObjyResourceList {
    private static final ContextTracer TRACER_DEBUG = new ContextTracer(OM.DEBUG, ObjyProxy.class);
    public static String className = "ooResourceList";
    public static String Attribute_arrayName = "oo_array";
    private ObjySession objySession;
    protected Class_Object classObject;
    protected ObjyArrayListId list = null;
    protected ooId objectId;
    private static final EStructuralFeature featureName = EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME;

    public static void buildSchema() {
        d_Module top_mod = ObjySchema.getTopModule();
        if (top_mod.resolve_class(className) == null && top_mod.resolve_proposed_class(className) == null) {
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("Schema not found for ooArrayListId. Adding ooArrayListId");
            }
            boolean inProcess = top_mod.proposed_classes().hasNext();
            Proposed_Class propClass = top_mod.propose_new_class(className);
            propClass.add_base_class(-1, d_Access_Kind.d_PUBLIC, "ObjyBase");
            propClass.add_ref_attribute(-1, d_Access_Kind.d_PUBLIC, Attribute_arrayName, 1L, ObjyArrayListId.className, false);
            if (!inProcess) {
                top_mod.activate_proposals(true, true);
            }
            if (TRACER_DEBUG.isEnabled()) {
                TRACER_DEBUG.trace("SCHEMA changed : ooArrayListId added");
            }
        }
    }

    public ObjyResourceList(ObjySession objySession, ObjyObject objyObject) {
        this.classObject = objyObject.ooClassObject();
        this.objySession = objySession;
        this.objectId = objyObject.ooId();
    }

    private ObjyArrayListId getList() {
        if (this.list != null) {
            return this.list;
        }
        try {
            Class_Position position = this.classObject.position_in_class(Attribute_arrayName);
            ooId oid = this.classObject.get_ooId(position);
            if (!oid.isNull()) {
                this.list = new ObjyArrayListId(Class_Object.class_object_from_oid((ooId)oid));
            }
        }
        catch (ObjyRuntimeException e) {
            e.printStackTrace();
        }
        return this.list;
    }

    public void remove(ObjyObject objyObject) {
        int size = (int)this.getList().size();
        int i = 0;
        while (i < size) {
            if (objyObject.ooId().equals(this.getList().get(i))) {
                this.getList().remove(i);
                break;
            }
            ++i;
        }
    }

    public void add(ObjyObject objyObject) {
        this.getList().add(objyObject.ooId());
    }

    public void checkDuplicateResources(ObjectivityStoreAccessor storeAccessor, InternalCDORevision revision) throws IllegalStateException {
        CDOID folderId = (CDOID)revision.data().getContainerID();
        String name = (String)revision.data().get((EStructuralFeature)EresourcePackage.eINSTANCE.getCDOResourceNode_Name(), 0);
        int size = (int)this.getList().size();
        int i = 0;
        while (i < size) {
            ObjyObject resource;
            ObjyObject resourceRevision = resource = this.getResource(i);
            if (storeAccessor.getStore().isRequiredToSupportBranches()) {
                resourceRevision = resource.getRevision(revision.getTimeStamp(), revision.getBranch().getID());
            } else if (storeAccessor.getStore().isRequiredToSupportAudits()) {
                resourceRevision = resource.getRevision(revision.getTimeStamp(), 0);
            }
            if (resourceRevision != null && resourceRevision.getVersion() >= 0) {
                CDOID resourceFolderId = (CDOID)resourceRevision.getEContainer();
                String resourceName = ObjyResourceList.getResourceName(resourceRevision);
                if (resourceFolderId != null && resourceFolderId.equals(folderId) && resourceName != null && resourceName.equals(name)) {
                    throw new IllegalStateException("Duplicate resource or folder: " + name + " in folder: " + folderId);
                }
            }
            ++i;
        }
    }

    public ObjyObject getResource(int index) {
        return this.objySession.getObjectManager().getObject((ooId)this.getList().get(index));
    }

    public static String getResourceName(ObjyObject objyObject) {
        String name = (String)objyObject.get(featureName);
        return name;
    }

    public static ObjyObject create(ooId nearOid) {
        Class_Object classObject = Class_Object.new_persistent_object((d_Class)ObjySchema.getObjyClass(className).getASClass(), (ooId)nearOid, (boolean)false);
        Class_Position position = classObject.position_in_class(Attribute_arrayName);
        Class_Object arrayClassObject = Class_Object.new_persistent_object((d_Class)ObjySchema.getTopModule().resolve_class(ObjyArrayListId.className), (ooId)classObject.objectID(), (boolean)false);
        classObject.set_ooId(position, arrayClassObject.objectID());
        ObjyArrayListId.initObject(arrayClassObject);
        ObjyObject objyObject = new ObjyObject(classObject);
        return objyObject;
    }

    public ooId ooId() {
        return this.objectId;
    }

    public int size() {
        return (int)this.getList().size();
    }
}

