/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.objectivity.utils;

import com.objy.pm.ooId;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.server.internal.objectivity.schema.ObjyProxy;

public class OBJYCDOIDUtil {
    public static CDOID createLong(long value) {
        if (value == 0L) {
            return CDOID.NULL;
        }
        return CDOIDUtil.createLong((long)value);
    }

    public static CDOID getCDOID(com.objy.db.app.ooId id) {
        return OBJYCDOIDUtil.createLong(OBJYCDOIDUtil.getLong(id));
    }

    public static CDOID getCDOID(long id) {
        return OBJYCDOIDUtil.createLong(id);
    }

    public static long getLong(com.objy.db.app.ooId id) {
        long value = 0L;
        if (id != null) {
            value = (long)id.getSlot() << 48 | (long)id.getPage() << 32 | (long)id.getOC() << 16 | (long)id.getDB();
        }
        return value;
    }

    public static long addProxy(long ooid) {
        return ooid | Long.MIN_VALUE;
    }

    public static long removeProxy(long ooid) {
        return ooid << 1 >>> 1;
    }

    public static boolean isProxy(long ooid) {
        return ooid >>> 63 == 1L;
    }

    public static long adaptOOID(long ooid) {
        return OBJYCDOIDUtil.removeProxy(ooid);
    }

    public static boolean isValidObjyId(CDOID cdoId) {
        if (cdoId instanceof CDOIDObject) {
            try {
                return CDOIDUtil.getLong((CDOID)cdoId) > 1717828929L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static com.objy.db.app.ooId getooId(long longCdoID) {
        int slot = (int)(longCdoID >> 48 & 0xFFFFL);
        int page = (int)(longCdoID >> 32 & 0xFFFFL);
        int OC = (int)(longCdoID >> 16 & 0xFFFFL);
        int DB = (int)(longCdoID & 0xFFFFL);
        return new ooId(DB, OC, page, slot, 0L);
    }

    public static com.objy.db.app.ooId getContainerId(long longCdoID) {
        int slot = 1;
        int page = 1;
        int OC = (int)(longCdoID >> 16 & 0xFFFFL);
        int DB = (int)(longCdoID & 0xFFFFL);
        return new ooId(DB, OC, page, slot, 0L);
    }

    public static com.objy.db.app.ooId getooId(CDOID cdoId) {
        long longCdoID = CDOIDUtil.getLong((CDOID)cdoId);
        return OBJYCDOIDUtil.getooId(longCdoID);
    }

    public static com.objy.db.app.ooId getContainerId(CDOID cdoId) {
        long longCdoID = CDOIDUtil.getLong((CDOID)cdoId);
        return OBJYCDOIDUtil.getContainerId(longCdoID);
    }

    public static CDOIDMeta createMeta(long value) {
        return CDOIDUtil.createMeta((long)value);
    }

    public static CDOIDMetaRange createMetaRange(CDOID lowerBound, int count) {
        return CDOIDUtil.createMetaRange((CDOID)lowerBound, (int)count);
    }

    public static CDOIDExternal createCDIDExternal(ObjyProxy proxyObject) {
        return CDOIDUtil.createExternal((String)proxyObject.getUri());
    }
}

