/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaUtil;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitDataImpl;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionManagerImpl;
import org.eclipse.emf.cdo.internal.server.CommitManager;
import org.eclipse.emf.cdo.internal.server.LockManager;
import org.eclipse.emf.cdo.internal.server.QueryManager;
import org.eclipse.emf.cdo.internal.server.ResourcesQueryHandler;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.internal.server.XRefsQueryHandler;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IQueryHandlerProvider;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationInfo;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.server.ContainerQueryHandlerProvider;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalCommitManager;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalQueryManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
extends Container<Object>
implements InternalRepository {
    private String name;
    private String uuid;
    private InternalStore store;
    private CDOCommonRepository.Type type = CDOCommonRepository.Type.MASTER;
    private CDOCommonRepository.State state = CDOCommonRepository.State.ONLINE;
    private Map<String, String> properties;
    private boolean supportingAudits;
    private boolean supportingBranches;
    private boolean ensuringReferentialIntegrity;
    private InternalCDOPackageRegistry packageRegistry;
    private InternalCDOBranchManager branchManager;
    private InternalCDORevisionManager revisionManager;
    private InternalCDOCommitInfoManager commitInfoManager;
    private InternalSessionManager sessionManager;
    private InternalQueryManager queryManager;
    private InternalCommitManager commitManager;
    private InternalLockManager lockManager;
    private IQueryHandlerProvider queryHandlerProvider;
    private List<IRepository.ReadAccessHandler> readAccessHandlers = new ArrayList<IRepository.ReadAccessHandler>();
    private List<IRepository.WriteAccessHandler> writeAccessHandlers = new ArrayList<IRepository.WriteAccessHandler>();
    @ReflectUtil.ExcludeFromDump
    private transient long lastCommitTimeStamp;
    @ReflectUtil.ExcludeFromDump
    private transient Object lastCommitTimeStampLock = new Object();
    @ReflectUtil.ExcludeFromDump
    private transient Object createBranchLock = new Object();
    private CDOID rootResourceID;

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getUUID() {
        if (this.uuid == null) {
            this.uuid = this.getProperties().get("overrideUUID");
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID().toString();
            } else if (this.uuid.length() == 0) {
                this.uuid = this.getName();
            }
        }
        return this.uuid;
    }

    @Override
    public InternalStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(InternalStore store) {
        this.store = store;
        store.setRepository(this);
    }

    public CDOCommonRepository.Type getType() {
        return this.type;
    }

    @Override
    public void setType(CDOCommonRepository.Type type) {
        this.checkArg(type, "type");
        if (this.type != type) {
            this.changingType(this.type, type);
        }
    }

    protected void changingType(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        this.type = newType;
        this.fireEvent((IEvent)new RepositoryTypeChangedEvent((INotifier)this, oldType, newType));
        if (this.sessionManager != null) {
            this.sessionManager.sendRepositoryTypeNotification(oldType, newType);
        }
    }

    public CDOCommonRepository.State getState() {
        return this.state;
    }

    @Override
    public void setState(CDOCommonRepository.State state) {
        this.checkArg(state, "state");
        if (this.state != state) {
            this.changingState(this.state, state);
        }
    }

    protected void changingState(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        this.state = newState;
        this.fireEvent((IEvent)new RepositoryStateChangedEvent((INotifier)this, oldState, newState));
        if (this.sessionManager != null) {
            this.sessionManager.sendRepositoryStateNotification(oldState, newState);
        }
    }

    @Override
    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public synchronized void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isSupportingAudits() {
        return this.supportingAudits;
    }

    public boolean isSupportingBranches() {
        return this.supportingBranches;
    }

    public boolean isEnsuringReferentialIntegrity() {
        return this.ensuringReferentialIntegrity;
    }

    public String getStoreType() {
        return this.store.getType();
    }

    public Set<CDOID.ObjectType> getObjectIDTypes() {
        return this.store.getObjectIDTypes();
    }

    public CDOID getRootResourceID() {
        return this.rootResourceID;
    }

    @Override
    public void setRootResourceID(CDOID rootResourceID) {
        this.rootResourceID = rootResourceID;
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadPackageUnit((InternalCDOPackageUnit)packageUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        if (!this.isSupportingBranches()) {
            throw new IllegalStateException("Branching is not supported by " + this);
        }
        Object object = this.createBranchLock;
        synchronized (object) {
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            return accessor.createBranch(branchID, branchInfo);
        }
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadBranch(branchID);
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadSubBranches(branchID);
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadBranches(startID, endID, branchHandler);
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.loadCommitInfos(branch, startTime, endTime, handler);
    }

    public CDOCommitData loadCommitData(long timeStamp) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadCommitData(timeStamp);
    }

    public List<InternalCDORevision> loadRevisions(List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth) {
        block6: for (RevisionInfo info : infos) {
            CDOID id = info.getID();
            RevisionInfo.Type type = info.getType();
            switch (type) {
                case AVAILABLE_NORMAL: {
                    RevisionInfo.Available.Normal availableInfo = (RevisionInfo.Available.Normal)info;
                    this.checkArg(!availableInfo.isDirect(), "Load is not needed");
                    break;
                }
                case AVAILABLE_POINTER: {
                    RevisionInfo.Available.Pointer pointerInfo = (RevisionInfo.Available.Pointer)info;
                    boolean needsTarget = !pointerInfo.hasTarget();
                    this.checkArg(!pointerInfo.isDirect() || needsTarget, "Load is not needed");
                    if (!needsTarget) break;
                    CDOBranchVersion targetBranchVersion = pointerInfo.getTargetBranchVersion();
                    InternalCDORevision target = this.loadRevisionByVersion(id, targetBranchVersion, referenceChunk);
                    PointerCDORevision pointer = new PointerCDORevision(target.getEClass(), id, pointerInfo.getAvailableBranchVersion().getBranch(), 0L, (CDOBranchVersion)target);
                    info.setResult(target);
                    info.setSynthetic((SyntheticCDORevision)pointer);
                    continue block6;
                }
                case AVAILABLE_DETACHED: {
                    RevisionInfo.Available.Detached detachedInfo = (RevisionInfo.Available.Detached)info;
                    this.checkArg(!detachedInfo.isDirect(), "Load is not needed");
                    break;
                }
                case MISSING: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid revision info type: " + type);
                }
            }
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            InternalCDORevision revision = accessor.readRevision(id, branchPoint, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
            if (revision == null) {
                InternalCDORevision target = this.loadRevisionTarget(id, branchPoint, referenceChunk, accessor);
                if (target != null) {
                    CDOBranch branch = branchPoint.getBranch();
                    long revised = this.loadRevisionRevised(id, branch);
                    PointerCDORevision pointer = new PointerCDORevision(target.getEClass(), id, branch, revised, (CDOBranchVersion)target);
                    info.setSynthetic((SyntheticCDORevision)pointer);
                }
                info.setResult(target);
                continue;
            }
            if (revision instanceof DetachedCDORevision) {
                DetachedCDORevision detached = (DetachedCDORevision)revision;
                info.setSynthetic((SyntheticCDORevision)detached);
                continue;
            }
            info.setResult(revision);
        }
        return null;
    }

    private InternalCDORevision loadRevisionTarget(CDOID id, CDOBranchPoint branchPoint, int referenceChunk, IStoreAccessor accessor) {
        CDOBranch branch = branchPoint.getBranch();
        while (!branch.isMainBranch()) {
            branchPoint = branch.getBase();
            branch = branchPoint.getBranch();
            InternalCDORevision revision = accessor.readRevision(id, branchPoint, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
            if (revision == null) continue;
            return revision;
        }
        return null;
    }

    private long loadRevisionRevised(CDOID id, CDOBranch branch) {
        InternalCDORevision revision = this.loadRevisionByVersion(id, branch.getVersion(1), -1);
        if (revision != null) {
            return revision.getTimeStamp() - 1L;
        }
        return 0L;
    }

    public InternalCDORevision loadRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int referenceChunk) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.readRevisionByVersion(id, branchVersion, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
    }

    protected void ensureChunks(InternalCDORevision revision, int referenceChunk, IStoreAccessor accessor) {
        EClass eClass = revision.getEClass();
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            if (feature.isMany()) {
                CDOList list = revision.getList(feature);
                int chunkEnd = Math.min(referenceChunk, list.size());
                accessor = this.ensureChunk(revision, feature, accessor, (MoveableList<Object>)list, 0, chunkEnd);
            }
            ++i;
        }
    }

    @Override
    public IStoreAccessor ensureChunk(InternalCDORevision revision, EStructuralFeature feature, int chunkStart, int chunkEnd) {
        CDOList list = revision.getList(feature);
        chunkEnd = Math.min(chunkEnd, list.size());
        return this.ensureChunk(revision, feature, StoreThreadLocal.getAccessor(), (MoveableList<Object>)list, chunkStart, chunkEnd);
    }

    protected IStoreAccessor ensureChunk(InternalCDORevision revision, EStructuralFeature feature, IStoreAccessor accessor, MoveableList<Object> list, int chunkStart, int chunkEnd) {
        IStoreChunkReader chunkReader = null;
        int fromIndex = -1;
        int j = chunkStart;
        while (j < chunkEnd) {
            if (list.get(j) == InternalCDOList.UNINITIALIZED) {
                if (fromIndex == -1) {
                    fromIndex = j;
                }
            } else if (fromIndex != -1) {
                int toIndex;
                if (chunkReader == null) {
                    if (accessor == null) {
                        accessor = StoreThreadLocal.getAccessor();
                    }
                    chunkReader = accessor.createChunkReader(revision, feature);
                }
                if (fromIndex == (toIndex = j) - 1) {
                    chunkReader.addSimpleChunk(fromIndex);
                } else {
                    chunkReader.addRangedChunk(fromIndex, toIndex);
                }
                fromIndex = -1;
            }
            ++j;
        }
        if (fromIndex != -1) {
            int toIndex;
            if (chunkReader == null) {
                if (accessor == null) {
                    accessor = StoreThreadLocal.getAccessor();
                }
                chunkReader = accessor.createChunkReader(revision, feature);
            }
            if (fromIndex == (toIndex = chunkEnd) - 1) {
                chunkReader.addSimpleChunk(fromIndex);
            } else {
                chunkReader.addRangedChunk(fromIndex, toIndex);
            }
        }
        if (chunkReader != null) {
            List<IStoreChunkReader.Chunk> chunks = chunkReader.executeRead();
            for (IStoreChunkReader.Chunk chunk : chunks) {
                int startIndex = chunk.getStartIndex();
                int indexInChunk = 0;
                while (indexInChunk < chunk.size()) {
                    Object id = chunk.get(indexInChunk);
                    list.set(startIndex + indexInChunk, id);
                    ++indexInChunk;
                }
            }
        }
        return accessor;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry(boolean considerCommitContext) {
        InternalCDOPackageRegistry contextualPackageRegistry;
        IStoreAccessor.CommitContext commitContext;
        if (considerCommitContext && (commitContext = StoreThreadLocal.getCommitContext()) != null && (contextualPackageRegistry = commitContext.getPackageRegistry()) != null) {
            return contextualPackageRegistry;
        }
        return this.packageRegistry;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.getPackageRegistry(true);
    }

    public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry) {
        this.checkInactive();
        this.packageRegistry = packageRegistry;
    }

    @Override
    public InternalSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void setSessionManager(InternalSessionManager sessionManager) {
        this.checkInactive();
        this.sessionManager = sessionManager;
    }

    @Override
    public InternalCDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    @Override
    public void setBranchManager(InternalCDOBranchManager branchManager) {
        this.checkInactive();
        this.branchManager = branchManager;
    }

    @Override
    public InternalCDOCommitInfoManager getCommitInfoManager() {
        return this.commitInfoManager;
    }

    public void setCommitInfoManager(InternalCDOCommitInfoManager commitInfoManager) {
        this.checkInactive();
        this.commitInfoManager = commitInfoManager;
    }

    @Override
    public InternalCDORevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    @Override
    public void setRevisionManager(InternalCDORevisionManager revisionManager) {
        this.checkInactive();
        this.revisionManager = revisionManager;
    }

    @Override
    public InternalQueryManager getQueryManager() {
        return this.queryManager;
    }

    public void setQueryManager(InternalQueryManager queryManager) {
        this.checkInactive();
        this.queryManager = queryManager;
    }

    @Override
    public InternalCommitManager getCommitManager() {
        return this.commitManager;
    }

    public void setCommitManager(InternalCommitManager commitManager) {
        this.checkInactive();
        this.commitManager = commitManager;
    }

    @Override
    public InternalLockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(InternalLockManager lockManager) {
        this.checkInactive();
        this.lockManager = lockManager;
    }

    @Override
    public InternalCommitContext createCommitContext(InternalTransaction transaction) {
        return new TransactionCommitContext(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastCommitTimeStamp() {
        Object object = this.lastCommitTimeStampLock;
        synchronized (object) {
            return this.lastCommitTimeStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLastCommitTimeStamp(long lastCommitTimeStamp) {
        Object object = this.lastCommitTimeStampLock;
        synchronized (object) {
            if (this.lastCommitTimeStamp < lastCommitTimeStamp) {
                this.lastCommitTimeStamp = lastCommitTimeStamp;
                this.lastCommitTimeStampLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitForCommit(long timeout) {
        Object object = this.lastCommitTimeStampLock;
        synchronized (object) {
            try {
                this.lastCommitTimeStampLock.wait(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.lastCommitTimeStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createCommitTimeStamp(CDOBranch branch, OMMonitor monitor) {
        monitor.begin();
        try {
            long now = this.getTimeStamp();
            if (branch == null) {
                long l = now;
                return l;
            }
            Object object = this.lastCommitTimeStampLock;
            synchronized (object) {
                if (this.lastCommitTimeStamp != 0L) {
                    while (this.lastCommitTimeStamp >= now) {
                        ConcurrencyUtil.sleep((long)1L);
                        now = this.getTimeStamp();
                        monitor.checkCanceled();
                    }
                }
                this.lastCommitTimeStamp = now;
                long l = now;
                return l;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IQueryHandlerProvider getQueryHandlerProvider() {
        return this.queryHandlerProvider;
    }

    @Override
    public void setQueryHandlerProvider(IQueryHandlerProvider queryHandlerProvider) {
        this.queryHandlerProvider = queryHandlerProvider;
    }

    @Override
    public synchronized IQueryHandler getQueryHandler(CDOQueryInfo info) {
        IQueryHandler handler;
        String language = info.getQueryLanguage();
        if ("resources".equals(language)) {
            return new ResourcesQueryHandler();
        }
        if ("xrefs".equals(language)) {
            return new XRefsQueryHandler();
        }
        IStoreAccessor storeAccessor = StoreThreadLocal.getAccessor();
        if (storeAccessor != null && (handler = storeAccessor.getQueryHandler(info)) != null) {
            return handler;
        }
        if (this.queryHandlerProvider == null) {
            this.queryHandlerProvider = new ContainerQueryHandlerProvider((IManagedContainer)IPluginContainer.INSTANCE);
        }
        if ((handler = this.queryHandlerProvider.getQueryHandler(info)) != null) {
            return handler;
        }
        return null;
    }

    public Object[] getElements() {
        Object[] elements = new Object[]{this.packageRegistry, this.branchManager, this.revisionManager, this.sessionManager, this.queryManager, this.commitManager, this.commitInfoManager, this.lockManager, this.store};
        return elements;
    }

    public boolean isEmpty() {
        return false;
    }

    public long getCreationTime() {
        return this.store.getCreationTime();
    }

    @Override
    public void validateTimeStamp(long timeStamp) throws IllegalArgumentException {
        long creationTimeStamp = this.getCreationTime();
        if (timeStamp < creationTimeStamp) {
            throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) < repository creation time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)creationTimeStamp)));
        }
        long currentTimeStamp = this.getTimeStamp();
        if (timeStamp > currentTimeStamp) {
            throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) > current time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)currentTimeStamp)));
        }
    }

    public long getTimeStamp() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(IRepository.Handler handler) {
        List<IRepository.Handler> list;
        if (handler instanceof IRepository.ReadAccessHandler) {
            list = this.readAccessHandlers;
            synchronized (list) {
                if (!this.readAccessHandlers.contains(handler)) {
                    this.readAccessHandlers.add((IRepository.ReadAccessHandler)handler);
                }
            }
        }
        if (handler instanceof IRepository.WriteAccessHandler) {
            list = this.writeAccessHandlers;
            synchronized (list) {
                if (!this.writeAccessHandlers.contains(handler)) {
                    this.writeAccessHandlers.add((IRepository.WriteAccessHandler)handler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(IRepository.Handler handler) {
        List<IRepository.Handler> list;
        if (handler instanceof IRepository.ReadAccessHandler) {
            list = this.readAccessHandlers;
            synchronized (list) {
                this.readAccessHandlers.remove(handler);
            }
        }
        if (handler instanceof IRepository.WriteAccessHandler) {
            list = this.writeAccessHandlers;
            synchronized (list) {
                this.writeAccessHandlers.remove(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReadAccessHandlers(InternalSession session, CDORevision[] revisions, List<CDORevision> additionalRevisions) {
        IRepository.ReadAccessHandler[] handlers;
        List<IRepository.ReadAccessHandler> list = this.readAccessHandlers;
        synchronized (list) {
            int size = this.readAccessHandlers.size();
            if (size == 0) {
                return;
            }
            handlers = this.readAccessHandlers.toArray(new IRepository.ReadAccessHandler[size]);
        }
        IRepository.ReadAccessHandler[] readAccessHandlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository.ReadAccessHandler handler = readAccessHandlerArray[n2];
            handler.handleRevisionsBeforeSending(session, revisions, additionalRevisions);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyWriteAccessHandlers(ITransaction transaction, IStoreAccessor.CommitContext commitContext, boolean beforeCommit, OMMonitor monitor) {
        IRepository.WriteAccessHandler[] handlers;
        List<IRepository.WriteAccessHandler> list = this.writeAccessHandlers;
        synchronized (list) {
            int size = this.writeAccessHandlers.size();
            if (size == 0) {
                return;
            }
            handlers = this.writeAccessHandlers.toArray(new IRepository.WriteAccessHandler[size]);
        }
        try {
            monitor.begin((double)handlers.length);
            IRepository.WriteAccessHandler[] writeAccessHandlerArray = handlers;
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository.WriteAccessHandler handler = writeAccessHandlerArray[n2];
                try {
                    if (beforeCommit) {
                        handler.handleTransactionBeforeCommitting(transaction, commitContext, monitor.fork());
                    } else {
                        handler.handleTransactionAfterCommitted(transaction, commitContext, monitor.fork());
                    }
                }
                catch (RuntimeException ex) {
                    if (!beforeCommit) {
                        OM.LOG.error((Throwable)ex);
                    }
                    throw ex;
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public CDOReplicationInfo replicateRaw(CDODataOutput out, int lastReplicatedBranchID, long lastReplicatedCommitTime) throws IOException {
        int fromBranchID = lastReplicatedBranchID + 1;
        final int toBranchID = this.getStore().getLastBranchID();
        long fromCommitTime = lastReplicatedCommitTime + 1L;
        final long toCommitTime = this.getStore().getLastCommitTime();
        out.writeInt(toBranchID);
        out.writeLong(toCommitTime);
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.rawExport(out, fromBranchID, toBranchID, fromCommitTime, toCommitTime);
        return new CDOReplicationInfo(){

            public int getLastReplicatedBranchID() {
                return toBranchID;
            }

            public long getLastReplicatedCommitTime() {
                return toCommitTime;
            }
        };
    }

    @Override
    public void replicate(CDOReplicationContext context) {
        int startID = context.getLastReplicatedBranchID() + 1;
        this.branchManager.getBranches(startID, 0, (CDOBranchHandler)context);
        long startTime = context.getLastReplicatedCommitTime();
        if (context.isSqueezeCommitInfos() && startTime != 0L) {
            this.replicateSqueezed(startTime, (CDOCommitInfoHandler)context);
        } else {
            this.commitInfoManager.getCommitInfos(startTime + 1L, 0L, (CDOCommitInfoHandler)context);
        }
    }

    private void replicateSqueezed(long startTime, CDOCommitInfoHandler handler) {
        HashSet<CDOPackageUnit> replicatedPackageUnits = new HashSet<CDOPackageUnit>();
        InternalCDOCommitInfoManager manager = this.getCommitInfoManager();
        List<CDOChangeSetSegment> segments = this.getBaselineSegments(startTime, (CDOBranch)this.getBranchManager().getMainBranch());
        for (CDOChangeSetSegment segment : segments) {
            List<CDOPackageUnit> newPackages = this.getPackageUnitsToReplicate(segment, replicatedPackageUnits);
            CDOChangeSetData changeSet = this.getChangeSet((CDOBranchPoint)segment, segment.getEndPoint());
            if (newPackages.isEmpty() && changeSet.isEmpty()) continue;
            List newObjects = changeSet.getNewObjects();
            List changedObjects = changeSet.getChangedObjects();
            List detachedObjects = changeSet.getDetachedObjects();
            CDOCommitDataImpl data = new CDOCommitDataImpl(newPackages, newObjects, changedObjects, detachedObjects);
            CDOBranch branch = segment.getBranch();
            long timeStamp = segment.getEndTime();
            String comment = "<replicate squeezed commits>";
            CDOCommitInfo commitInfo = manager.createCommitInfo(branch, timeStamp, "CDO_SYSTEM", comment, (CDOCommitData)data);
            handler.handleCommitInfo(commitInfo);
        }
    }

    private List<CDOChangeSetSegment> getBaselineSegments(long startTime, CDOBranch branch) {
        ArrayList<CDOChangeSetSegment> segments = new ArrayList<CDOChangeSetSegment>();
        this.getBaselineSegments(startTime, branch, segments);
        Collections.sort(segments);
        return segments;
    }

    private void getBaselineSegments(long startTime, CDOBranch branch, List<CDOChangeSetSegment> segments) {
        if (startTime == 0L) {
            startTime = branch.getBase().getTimeStamp();
        }
        CDOBranch[] branches = branch.getBranches();
        Arrays.sort(branches, new Comparator<CDOBranch>(){

            @Override
            public int compare(CDOBranch o1, CDOBranch o2) {
                return CDOCommonUtil.compareTimeStamps((long)o1.getBase().getTimeStamp(), (long)o2.getBase().getTimeStamp());
            }
        });
        CDOBranch[] cDOBranchArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            CDOBranch subBranch = cDOBranchArray[n2];
            long baseTimeStamp = subBranch.getBase().getTimeStamp();
            if (baseTimeStamp > startTime) {
                segments.add(new CDOChangeSetSegment(branch, startTime, baseTimeStamp));
            }
            this.getBaselineSegments(baseTimeStamp, subBranch, segments);
            startTime = baseTimeStamp;
            ++n2;
        }
        segments.add(new CDOChangeSetSegment(branch, startTime, 0L));
    }

    private List<CDOPackageUnit> getPackageUnitsToReplicate(CDOChangeSetSegment segment, Set<CDOPackageUnit> replicated) {
        InternalCDOPackageUnit[] packageUnits;
        ArrayList<CDOPackageUnit> result = new ArrayList<CDOPackageUnit>();
        InternalCDOPackageRegistry packageRegistry = this.getPackageRegistry(false);
        long startTime = segment.getTimeStamp();
        long endTime = segment.getEndTime();
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits = packageRegistry.getPackageUnits(startTime, endTime);
        int n = packageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
            if (!packageUnit.isSystem() && replicated.add((CDOPackageUnit)packageUnit)) {
                result.add((CDOPackageUnit)packageUnit);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public CDOChangeSetData getChangeSet(CDOBranchPoint startPoint, CDOBranchPoint endPoint) {
        CDOChangeSetSegment[] segments = CDOChangeSetSegment.createFrom((CDOBranchPoint)startPoint, (CDOBranchPoint)endPoint);
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        Set<CDOID> ids = accessor.readChangeSet(segments);
        return CDORevisionDeltaUtil.createChangeSetData(ids, (CDOBranchPoint)startPoint, (CDOBranchPoint)endPoint, (CDORevisionManager)this.revisionManager);
    }

    @Override
    public Set<CDOID> getMergeData(CDORevisionAvailabilityInfo ancestorInfo, CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo) {
        CDOBranchPoint ancestor = ancestorInfo.getBranchPoint();
        CDOBranchPoint target = targetInfo.getBranchPoint();
        CDOBranchPoint source = sourceInfo.getBranchPoint();
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        Set<CDOID> ids = accessor.readChangeSet(CDOChangeSetSegment.createFrom((CDOBranchPoint)ancestor, (CDOBranchPoint)target));
        ids.addAll(accessor.readChangeSet(CDOChangeSetSegment.createFrom((CDOBranchPoint)ancestor, (CDOBranchPoint)source)));
        this.loadMergeData(ids, ancestorInfo);
        this.loadMergeData(ids, targetInfo);
        this.loadMergeData(ids, sourceInfo);
        return ids;
    }

    private void loadMergeData(Set<CDOID> ids, CDORevisionAvailabilityInfo info) {
        CDOBranchPoint branchPoint = info.getBranchPoint();
        for (CDOID id : ids) {
            if (info.containsRevision(id)) {
                info.removeRevision(id);
                continue;
            }
            InternalCDORevision revision = this.getRevisionFromBranch(id, branchPoint);
            if (revision != null) {
                info.addRevision((CDORevisionKey)revision);
                continue;
            }
            info.removeRevision(id);
        }
    }

    private InternalCDORevision getRevisionFromBranch(CDOID id, CDOBranchPoint branchPoint) {
        InternalCDORevision revision = this.revisionManager.getRevision(id, branchPoint, -1, 0, true);
        return revision;
    }

    public String toString() {
        return MessageFormat.format("CDORepositoryInfo[{0}]", this.name);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(!StringUtil.isEmpty((String)this.name), "name is empty");
        this.checkState(this.packageRegistry, "packageRegistry");
        this.checkState(this.sessionManager, "sessionManager");
        this.checkState(this.branchManager, "branchManager");
        this.checkState(this.revisionManager, "revisionManager");
        this.checkState(this.queryManager, "queryManager");
        this.checkState(this.commitInfoManager, "commitInfoManager");
        this.checkState(this.commitManager, "commitManager");
        this.checkState(this.lockManager, "lockingManager");
        this.packageRegistry.setReplacingDescriptors(true);
        this.packageRegistry.setPackageLoader((InternalCDOPackageRegistry.PackageLoader)this);
        this.branchManager.setBranchLoader((InternalCDOBranchManager.BranchLoader)this);
        this.branchManager.setTimeProvider((CDOTimeProvider)this);
        this.revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)this);
        this.sessionManager.setRepository(this);
        this.queryManager.setRepository(this);
        this.commitInfoManager.setCommitInfoLoader((InternalCDOCommitInfoManager.CommitInfoLoader)this);
        this.commitManager.setRepository(this);
        this.lockManager.setRepository(this);
        this.checkState(this.store, "store");
        String value = this.getProperties().get("supportingAudits");
        if (value != null) {
            this.supportingAudits = Boolean.valueOf(value);
            this.store.setRevisionTemporality(this.supportingAudits ? IStore.RevisionTemporality.AUDITING : IStore.RevisionTemporality.NONE);
        } else {
            this.supportingAudits = this.store.getRevisionTemporality() == IStore.RevisionTemporality.AUDITING;
        }
        value = this.getProperties().get("supportingBranches");
        if (value != null) {
            this.supportingBranches = Boolean.valueOf(value);
            this.store.setRevisionParallelism(this.supportingBranches ? IStore.RevisionParallelism.BRANCHING : IStore.RevisionParallelism.NONE);
        } else {
            this.supportingBranches = this.store.getRevisionParallelism() == IStore.RevisionParallelism.BRANCHING;
        }
        this.revisionManager.setSupportingBranches(this.supportingBranches);
        value = this.getProperties().get("ensureReferentialIntegrity");
        if (value != null) {
            this.ensuringReferentialIntegrity = Boolean.valueOf(value);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.packageRegistry);
        LifecycleUtil.activate((Object)this.store);
        LifecycleUtil.activate((Object)this.sessionManager);
        LifecycleUtil.activate((Object)this.revisionManager);
        LifecycleUtil.activate((Object)this.queryManager);
        LifecycleUtil.activate((Object)this.commitInfoManager);
        LifecycleUtil.activate((Object)this.commitManager);
        LifecycleUtil.activate((Object)this.queryHandlerProvider);
        LifecycleUtil.activate((Object)this.lockManager);
        this.lastCommitTimeStamp = Math.max(this.store.getCreationTime(), this.store.getLastCommitTime());
        this.branchManager.initMainBranch(this.lastCommitTimeStamp);
        LifecycleUtil.activate((Object)this.branchManager);
        if (this.store.isFirstTime()) {
            this.initSystemPackages();
            this.initRootResource();
        } else {
            this.readPackageUnits();
            this.loadRootResource();
        }
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.lockManager);
        LifecycleUtil.deactivate((Object)this.queryHandlerProvider);
        LifecycleUtil.deactivate((Object)this.commitManager);
        LifecycleUtil.deactivate((Object)this.commitInfoManager);
        LifecycleUtil.deactivate((Object)this.queryManager);
        LifecycleUtil.deactivate((Object)this.revisionManager);
        LifecycleUtil.deactivate((Object)this.sessionManager);
        LifecycleUtil.deactivate((Object)this.store);
        LifecycleUtil.deactivate((Object)this.branchManager);
        LifecycleUtil.deactivate((Object)this.packageRegistry);
        super.doDeactivate();
    }

    protected void initSystemPackages() {
        IStoreAccessor writer = this.store.getWriter(null);
        StoreThreadLocal.setAccessor(writer);
        try {
            InternalCDOPackageUnit ecoreUnit = this.initSystemPackage((EPackage)EcorePackage.eINSTANCE);
            InternalCDOPackageUnit eresourceUnit = this.initSystemPackage((EPackage)EresourcePackage.eINSTANCE);
            InternalCDOPackageUnit[] systemUnits = new InternalCDOPackageUnit[]{ecoreUnit, eresourceUnit};
            writer.writePackageUnits(systemUnits, (OMMonitor)new Monitor());
            writer.commit((OMMonitor)new Monitor());
        }
        finally {
            LifecycleUtil.deactivate((Object)writer);
            StoreThreadLocal.release();
        }
    }

    protected InternalCDOPackageUnit initSystemPackage(EPackage ePackage) {
        EMFUtil.registerPackage((EPackage)ePackage, (EPackage.Registry[])new EPackage.Registry[]{this.packageRegistry});
        InternalCDOPackageInfo packageInfo = this.packageRegistry.getPackageInfo(ePackage);
        CDOIDMetaRange metaIDRange = this.store.getNextMetaIDRange(packageInfo.getMetaIDRange().size());
        packageInfo.setMetaIDRange(metaIDRange);
        this.packageRegistry.getMetaInstanceMapper().mapMetaInstances(ePackage, metaIDRange);
        InternalCDOPackageUnit packageUnit = packageInfo.getPackageUnit();
        packageUnit.setTimeStamp(this.store.getCreationTime());
        packageUnit.setState(CDOPackageUnit.State.LOADED);
        return packageUnit;
    }

    protected void initRootResource() {
        CDOBranchPoint head = this.branchManager.getMainBranch().getHead();
        CDOIDTemp tempID = CDOIDUtil.createTempObject((int)1);
        CDORevisionImpl rootResource = new CDORevisionImpl(EresourcePackage.Literals.CDO_RESOURCE);
        rootResource.setBranchPoint(head);
        rootResource.setContainerID((Object)CDOID.NULL);
        rootResource.setContainingFeatureID(0);
        rootResource.setID((CDOID)tempID);
        rootResource.setResourceID((CDOID)tempID);
        InternalSession session = this.getSessionManager().openSession(null);
        InternalTransaction transaction = session.openTransaction(1, head);
        TransactionCommitContext commitContext = new TransactionCommitContext(transaction){

            protected long createTimeStamp(OMMonitor monitor) {
                return Repository.this.store.getCreationTime();
            }

            public String getUserID() {
                return "CDO_SYSTEM";
            }

            public String getCommitComment() {
                return "<initialize root resource>";
            }
        };
        commitContext.setNewObjects(new InternalCDORevision[]{rootResource});
        commitContext.preWrite();
        boolean success = false;
        try {
            commitContext.write((OMMonitor)new Monitor());
            commitContext.commit((OMMonitor)new Monitor());
            success = true;
            this.rootResourceID = commitContext.getIDMappings().get(tempID);
        }
        finally {
            commitContext.postCommit(success);
            session.close();
        }
    }

    protected void loadRootResource() {
        IStoreAccessor reader = this.store.getReader(null);
        StoreThreadLocal.setAccessor(reader);
        try {
            CDOBranchPoint head = this.branchManager.getMainBranch().getHead();
            this.rootResourceID = reader.readResourceID(CDOID.NULL, null, head);
        }
        finally {
            LifecycleUtil.deactivate((Object)reader);
            StoreThreadLocal.release();
        }
    }

    protected void readPackageUnits() {
        IStoreAccessor reader = this.store.getReader(null);
        StoreThreadLocal.setAccessor(reader);
        try {
            Collection<InternalCDOPackageUnit> packageUnits = reader.readPackageUnits();
            for (InternalCDOPackageUnit packageUnit : packageUnits) {
                this.packageRegistry.putPackageUnit(packageUnit);
            }
        }
        finally {
            LifecycleUtil.deactivate((Object)reader);
            StoreThreadLocal.release();
        }
    }

    public static class Default
    extends Repository {
        protected void doBeforeActivate() throws Exception {
            if (this.getPackageRegistry(false) == null) {
                this.setPackageRegistry(this.createPackageRegistry());
            }
            if (this.getSessionManager() == null) {
                this.setSessionManager(this.createSessionManager());
            }
            if (this.getBranchManager() == null) {
                this.setBranchManager(this.createBranchManager());
            }
            if (this.getRevisionManager() == null) {
                this.setRevisionManager(this.createRevisionManager());
            }
            if (this.getQueryManager() == null) {
                this.setQueryManager(this.createQueryManager());
            }
            if (this.getCommitInfoManager() == null) {
                this.setCommitInfoManager(this.createCommitInfoManager());
            }
            if (this.getCommitManager() == null) {
                this.setCommitManager(this.createCommitManager());
            }
            if (this.getLockManager() == null) {
                this.setLockManager(this.createLockManager());
            }
            super.doBeforeActivate();
        }

        protected InternalCDOPackageRegistry createPackageRegistry() {
            return new CDOPackageRegistryImpl();
        }

        protected InternalSessionManager createSessionManager() {
            return new SessionManager();
        }

        protected InternalCDOBranchManager createBranchManager() {
            return CDOBranchUtil.createBranchManager();
        }

        protected InternalCDORevisionManager createRevisionManager() {
            return new CDORevisionManagerImpl();
        }

        protected InternalQueryManager createQueryManager() {
            return new QueryManager();
        }

        protected InternalCDOCommitInfoManager createCommitInfoManager() {
            return CDOCommitInfoUtil.createCommitInfoManager();
        }

        protected InternalCommitManager createCommitManager() {
            return new CommitManager();
        }

        protected InternalLockManager createLockManager() {
            return new LockManager();
        }
    }
}

