/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryFactory;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreFactory;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.IUserManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConfigurator {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REPOSITORY, RepositoryConfigurator.class);
    private IManagedContainer container;

    public RepositoryConfigurator() {
        this(null);
    }

    public RepositoryConfigurator(IManagedContainer container) {
        this.container = container;
    }

    public IManagedContainer getContainer() {
        return this.container;
    }

    public IRepository[] configure(File configFile) throws ParserConfigurationException, SAXException, IOException, CoreException {
        if (TRACER.isEnabled()) {
            TRACER.trace("Configuring CDO server from " + configFile.getAbsolutePath());
        }
        ArrayList<IRepository> repositories = new ArrayList<IRepository>();
        Document document = this.getDocument(configFile);
        NodeList elements = document.getElementsByTagName("repository");
        int i = 0;
        while (i < elements.getLength()) {
            Element repositoryConfig = (Element)elements.item(i);
            IRepository repository = this.getRepository(repositoryConfig);
            repositories.add(repository);
            if (this.container != null) {
                CDOServerUtil.addRepository(this.container, repository);
            }
            ++i;
        }
        return repositories.toArray(new IRepository[repositories.size()]);
    }

    protected Document getDocument(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(configFile);
    }

    protected IRepositoryFactory getRepositoryFactory(String type) throws CoreException {
        IRepositoryFactory factory = (IRepositoryFactory)RepositoryConfigurator.createExecutableExtension("repositoryFactories", "repositoryFactory", "repositoryType", type);
        if (factory == null) {
            throw new IllegalStateException("CDORepositoryInfo factory not found: " + type);
        }
        return factory;
    }

    protected IRepository getRepository(Element repositoryConfig) throws CoreException {
        IUserManager userManager;
        String repositoryName = repositoryConfig.getAttribute("name");
        if (StringUtil.isEmpty((String)repositoryName)) {
            throw new IllegalArgumentException("CDORepositoryInfo name is missing or empty");
        }
        String repositoryType = repositoryConfig.getAttribute("type");
        if (StringUtil.isEmpty((String)repositoryType)) {
            repositoryType = "default";
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Configuring repository {0} (type={1})", new Object[]{repositoryName, repositoryType});
        }
        InternalRepository repository = (InternalRepository)this.getRepository(repositoryType);
        repository.setName(repositoryName);
        Element userManagerConfig = this.getUserManagerConfig(repositoryConfig);
        if (userManagerConfig != null && (userManager = this.getUserManager(userManagerConfig)) != null) {
            InternalSessionManager sessionManager = repository.getSessionManager();
            if (sessionManager == null) {
                sessionManager = new SessionManager();
                repository.setSessionManager(sessionManager);
            }
            sessionManager.setUserManager(userManager);
        }
        Element storeConfig = this.getStoreConfig(repositoryConfig);
        InternalStore store = (InternalStore)this.getStore(storeConfig);
        repository.setStore(store);
        Map<String, String> properties = RepositoryConfigurator.getProperties(repositoryConfig, 1);
        repository.setProperties(properties);
        return repository;
    }

    protected IRepository getRepository(String repositoryType) throws CoreException {
        IRepositoryFactory factory = this.getRepositoryFactory(repositoryType);
        return factory.createRepository();
    }

    protected Element getUserManagerConfig(Element repositoryConfig) {
        NodeList userManagerConfig = repositoryConfig.getElementsByTagName("userManager");
        if (userManagerConfig.getLength() > 1) {
            String repositoryName = repositoryConfig.getAttribute("name");
            throw new IllegalStateException("At most one user manager must be configured for repository " + repositoryName);
        }
        return (Element)(userManagerConfig.getLength() > 0 ? userManagerConfig.item(0) : null);
    }

    protected IUserManager getUserManager(Element userManagerConfig) throws CoreException {
        String type = userManagerConfig.getAttribute("type");
        String description = userManagerConfig.getAttribute("description");
        return this.getUserManager(type, description);
    }

    protected IUserManager getUserManager(String type, String description) throws CoreException {
        IUserManager userManager = (IUserManager)this.container.getElement("org.eclipse.net4j.userManagers", type, description);
        if (userManager == null) {
            throw new IllegalStateException("UserManager factory not found: " + type);
        }
        return userManager;
    }

    protected Element getStoreConfig(Element repositoryConfig) {
        NodeList storeConfigs = repositoryConfig.getElementsByTagName("store");
        if (storeConfigs.getLength() != 1) {
            String repositoryName = repositoryConfig.getAttribute("name");
            throw new IllegalStateException("Exactly one store must be configured for repository " + repositoryName);
        }
        return (Element)storeConfigs.item(0);
    }

    protected IStoreFactory getStoreFactory(String type) throws CoreException {
        IStoreFactory factory = (IStoreFactory)RepositoryConfigurator.createExecutableExtension("storeFactories", "storeFactory", "storeType", type);
        if (factory == null) {
            throw new IllegalStateException("Store factory not found: " + type);
        }
        return factory;
    }

    protected IStore getStore(Element storeConfig) throws CoreException {
        String type = storeConfig.getAttribute("type");
        IStoreFactory storeFactory = this.getStoreFactory(type);
        return storeFactory.createStore(storeConfig);
    }

    public static Map<String, String> getProperties(Element element, int levels) {
        HashMap<String, String> properties = new HashMap<String, String>();
        RepositoryConfigurator.collectProperties(element, "", properties, levels);
        return properties;
    }

    private static void collectProperties(Element element, String prefix, Map<String, String> properties, int levels) {
        if ("property".equals(element.getNodeName())) {
            String name = element.getAttribute("name");
            String value = element.getAttribute("value");
            properties.put(String.valueOf(prefix) + name, value);
            prefix = String.valueOf(prefix) + name + ".";
        }
        if (levels > 0) {
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode instanceof Element) {
                    RepositoryConfigurator.collectProperties((Element)childNode, prefix, properties, levels - 1);
                }
                ++i;
            }
        }
    }

    private static Object createExecutableExtension(String extPointName, String elementName, String attributeName, String type) throws CoreException {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server", extPointName);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String storeType;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ObjectUtil.equals((Object)element.getName(), (Object)elementName) && ObjectUtil.equals((Object)(storeType = element.getAttribute(attributeName)), (Object)type)) {
                return element.createExecutableExtension("class");
            }
            ++n2;
        }
        return null;
    }
}

