/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.server.QueryHandlerFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class ResourcesQueryHandler
implements IQueryHandler {
    public void executeQuery(CDOQueryInfo info, IQueryContext context) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        QueryContext resourcesContext = new QueryContext(info, context);
        accessor.queryResources(resourcesContext);
        IQueryContext branchPoint = context;
        CDOBranch branch = branchPoint.getBranch();
        while (!branch.isMainBranch() && resourcesContext.getResourceIDs().size() < info.getMaxResults()) {
            branchPoint = branch.getBase();
            branch = branchPoint.getBranch();
            resourcesContext.setBranchPoint(branchPoint);
            accessor.queryResources(resourcesContext);
        }
    }

    public static class Factory
    extends QueryHandlerFactory {
        public Factory() {
            super("resources");
        }

        public IQueryHandler create(String description) throws ProductCreationException {
            return new ResourcesQueryHandler();
        }

        public static IQueryHandler get(IManagedContainer container, String queryLanguage) {
            return (IQueryHandler)container.getElement("org.eclipse.emf.cdo.server.queryHandlerFactories", "resources", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class QueryContext
    implements IStoreAccessor.QueryResourcesContext {
        private CDOQueryInfo info;
        private IQueryContext context;
        private CDOBranchPoint branchPoint;
        private Set<CDOID> resourceIDs = new HashSet<CDOID>();

        public QueryContext(CDOQueryInfo info, IQueryContext context) {
            this.info = info;
            this.context = context;
            this.branchPoint = context;
        }

        public void setBranchPoint(CDOBranchPoint branchPoint) {
            this.branchPoint = branchPoint;
        }

        public Set<CDOID> getResourceIDs() {
            return this.resourceIDs;
        }

        public CDOBranch getBranch() {
            return this.branchPoint.getBranch();
        }

        public long getTimeStamp() {
            return this.branchPoint.getTimeStamp();
        }

        @Override
        public CDOID getFolderID() {
            return (CDOID)this.info.getParameters().get("folder");
        }

        @Override
        public String getName() {
            return this.info.getQueryString();
        }

        @Override
        public boolean exactMatch() {
            return (Boolean)this.info.getParameters().get("exactMatch");
        }

        @Override
        public int getMaxResults() {
            return this.info.getMaxResults();
        }

        @Override
        public boolean addResource(CDOID resourceID) {
            if (this.resourceIDs.add(resourceID)) {
                return this.context.addResult(resourceID);
            }
            return true;
        }

        public int compareTo(CDOBranchPoint o) {
            return this.branchPoint.compareTo((Object)o);
        }
    }
}

