/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.internal.common.commit.DelegatingCommitInfo;
import org.eclipse.emf.cdo.internal.server.Transaction;
import org.eclipse.emf.cdo.internal.server.View;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.collection.IndexedList;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.options.IOptionsContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
extends Container<IView>
implements InternalSession {
    private InternalSessionManager manager;
    private ISessionProtocol protocol;
    private int sessionID;
    private String userID;
    private boolean passiveUpdateEnabled = true;
    private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode = CDOCommonSession.Options.PassiveUpdateMode.INVALIDATIONS;
    private ConcurrentMap<Integer, InternalView> views = new ConcurrentHashMap<Integer, InternalView>();
    private AtomicInteger lastTempViewID = new AtomicInteger();
    @ReflectUtil.ExcludeFromDump
    private IListener protocolListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            Session.this.deactivate();
        }
    };
    private boolean subscribed;

    public Session(InternalSessionManager manager, ISessionProtocol protocol, int sessionID, String userID) {
        this.manager = manager;
        this.protocol = protocol;
        this.sessionID = sessionID;
        this.userID = userID;
        EventUtil.addListener((Object)protocol, (IListener)this.protocolListener);
        this.activate();
    }

    public CDOCommonSession.Options options() {
        return this;
    }

    public IOptionsContainer getContainer() {
        return this;
    }

    @Override
    public InternalSessionManager getManager() {
        return this.manager;
    }

    @Override
    public ISessionProtocol getProtocol() {
        return this.protocol;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public String getUserID() {
        return this.userID;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscribed;
    }

    @Override
    public void setSubscribed(boolean subscribed) {
        this.checkActive();
        if (this.subscribed != subscribed) {
            this.subscribed = subscribed;
            byte opcode = subscribed ? (byte)3 : 4;
            this.manager.sendRemoteSessionNotification(this, opcode);
        }
    }

    public boolean isPassiveUpdateEnabled() {
        return this.passiveUpdateEnabled;
    }

    public void setPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
        this.checkActive();
        this.passiveUpdateEnabled = passiveUpdateEnabled;
    }

    public CDOCommonSession.Options.PassiveUpdateMode getPassiveUpdateMode() {
        return this.passiveUpdateMode;
    }

    public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode) {
        this.checkActive();
        this.checkArg(passiveUpdateMode, "passiveUpdateMode");
        this.passiveUpdateMode = passiveUpdateMode;
    }

    public InternalView[] getElements() {
        this.checkActive();
        return this.getViews();
    }

    public boolean isEmpty() {
        this.checkActive();
        return this.views.isEmpty();
    }

    @Override
    public InternalView[] getViews() {
        this.checkActive();
        return this.getViewsArray();
    }

    private InternalView[] getViewsArray() {
        return this.views.values().toArray(new InternalView[this.views.size()]);
    }

    @Override
    public InternalView getView(int viewID) {
        this.checkActive();
        return (InternalView)this.views.get(viewID);
    }

    @Override
    public InternalView openView(int viewID, CDOBranchPoint branchPoint) {
        this.checkActive();
        if (viewID == 0) {
            viewID = -this.lastTempViewID.incrementAndGet();
        }
        View view = new View(this, viewID, branchPoint);
        view.activate();
        this.addView(view);
        return view;
    }

    @Override
    public InternalTransaction openTransaction(int viewID, CDOBranchPoint branchPoint) {
        this.checkActive();
        if (viewID == 0) {
            viewID = -this.lastTempViewID.incrementAndGet();
        }
        Transaction transaction = new Transaction(this, viewID, branchPoint);
        transaction.activate();
        this.addView(transaction);
        return transaction;
    }

    private void addView(InternalView view) {
        this.checkActive();
        int viewID = view.getViewID();
        this.views.put(viewID, view);
        this.fireElementAddedEvent(view);
    }

    @Override
    public void viewClosed(InternalView view) {
        int viewID = view.getViewID();
        if (this.views.remove(viewID) == view) {
            view.doClose();
            this.fireElementRemovedEvent(view);
        }
    }

    @Override
    public void collectContainedRevisions(InternalCDORevision revision, CDOBranchPoint branchPoint, int referenceChunk, Set<CDOID> revisions, List<CDORevision> additionalRevisions) {
        InternalCDORevisionManager revisionManager = this.getManager().getRepository().getRevisionManager();
        EClass eClass = revision.getEClass();
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int i = 0;
        while (i < features.length) {
            CDOID id;
            Object value;
            EStructuralFeature feature = features[i];
            if (feature instanceof EReference && !feature.isMany() && ((EReference)feature).isContainment() && (value = revision.getValue(feature)) instanceof CDOID && !CDOIDUtil.isNull((CDOID)(id = (CDOID)value)) && !revisions.contains(id)) {
                InternalCDORevision containedRevision = revisionManager.getRevision(id, branchPoint, referenceChunk, 0, true);
                revisions.add(id);
                additionalRevisions.add((CDORevision)containedRevision);
                this.collectContainedRevisions(containedRevision, branchPoint, referenceChunk, revisions, additionalRevisions);
            }
            ++i;
        }
    }

    public CDOID provideCDOID(Object idObject) {
        return (CDOID)idObject;
    }

    @Override
    public void sendRepositoryTypeNotification(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) throws Exception {
        if (this.protocol != null) {
            this.protocol.sendRepositoryTypeNotification(oldType, newType);
        }
    }

    @Override
    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) throws Exception {
        if (this.protocol != null) {
            this.protocol.sendRepositoryStateNotification(oldState, newState);
        }
    }

    @Override
    public void sendBranchNotification(InternalCDOBranch branch) throws Exception {
        if (this.protocol != null) {
            this.protocol.sendBranchNotification(branch);
        }
    }

    @Override
    public void sendCommitNotification(final CDOCommitInfo commitInfo) throws Exception {
        if (this.protocol == null) {
            return;
        }
        if (!this.isPassiveUpdateEnabled()) {
            return;
        }
        final InternalView[] views = this.getViews();
        this.protocol.sendCommitNotification((CDOCommitInfo)new DelegatingCommitInfo(){
            final boolean additions;
            final boolean changes;
            {
                this.additions = Session.this.getPassiveUpdateMode() == CDOCommonSession.Options.PassiveUpdateMode.ADDITIONS;
                this.changes = Session.this.getPassiveUpdateMode() == CDOCommonSession.Options.PassiveUpdateMode.CHANGES;
            }

            protected CDOCommitInfo getDelegate() {
                return commitInfo;
            }

            public boolean isEmpty() {
                return this.getDelegate().isEmpty();
            }

            public List<CDOIDAndVersion> getNewObjects() {
                final List newObjects = super.getNewObjects();
                return new IndexedList<CDOIDAndVersion>(){

                    public CDOIDAndVersion get(int index) {
                        CDOIDAndVersion newObject = (CDOIDAndVersion)newObjects.get(index);
                        if (additions) {
                            return newObject;
                        }
                        return CDOIDUtil.createIDAndVersion((CDOIDAndVersion)newObject);
                    }

                    public int size() {
                        return newObjects.size();
                    }
                };
            }

            public List<CDORevisionKey> getChangedObjects() {
                final List changedObjects = super.getChangedObjects();
                return new IndexedList<CDORevisionKey>(){

                    public CDORevisionKey get(int index) {
                        CDORevisionKey changedObject = (CDORevisionKey)changedObjects.get(index);
                        if (changes || additions || Session.this.hasSubscription(changedObject.getID(), views)) {
                            return changedObject;
                        }
                        return CDORevisionUtil.createRevisionKey((CDORevisionKey)changedObject);
                    }

                    public int size() {
                        return changedObjects.size();
                    }
                };
            }
        });
    }

    private boolean hasSubscription(CDOID id, InternalView[] views) {
        InternalView[] internalViewArray = views;
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            InternalView view = internalViewArray[n2];
            if (view.hasSubscription(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void sendRemoteSessionNotification(InternalSession sender, byte opcode) throws Exception {
        if (this.protocol != null) {
            this.protocol.sendRemoteSessionNotification(sender, opcode);
        }
    }

    @Override
    public void sendRemoteMessageNotification(InternalSession sender, CDORemoteSessionMessage message) throws Exception {
        if (this.protocol != null) {
            this.protocol.sendRemoteMessageNotification(sender, message);
        }
    }

    public String toString() {
        return MessageFormat.format("Session[{0}]", this.sessionID);
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    protected void doDeactivate() throws Exception {
        EventUtil.removeListener((Object)this.protocol, (IListener)this.protocolListener);
        this.protocolListener = null;
        LifecycleUtil.deactivate((Object)this.protocol, (OMLogger.Level)OMLogger.Level.DEBUG);
        this.protocol = null;
        InternalView[] internalViewArray = this.getViewsArray();
        int n = internalViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalView view = internalViewArray[n2];
            view.close();
            ++n2;
        }
        this.views = null;
        this.manager.sessionClosed(this);
        this.manager = null;
        super.doDeactivate();
    }
}

