/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitDataImpl;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.XRefsQueryHandler;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.IndexedList;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionCommitContext
implements InternalCommitContext {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSACTION, TransactionCommitContext.class);
    private InternalTransaction transaction;
    private TransactionPackageRegistry packageRegistry;
    private IStoreAccessor accessor;
    private long timeStamp = 0L;
    private String commitComment;
    private InternalCDOPackageUnit[] newPackageUnits = new InternalCDOPackageUnit[0];
    private InternalCDORevision[] newObjects = new InternalCDORevision[0];
    private InternalCDORevisionDelta[] dirtyObjectDeltas = new InternalCDORevisionDelta[0];
    private CDOID[] detachedObjects = new CDOID[0];
    private Map<CDOID, EClass> detachedObjectTypes;
    private InternalCDORevision[] dirtyObjects = new InternalCDORevision[0];
    private List<InternalCDORevision> detachedRevisions = new ArrayList<InternalCDORevision>();
    private List<Object> lockedObjects = new ArrayList<Object>();
    private List<CDOIDMetaRange> metaIDRanges = new ArrayList<CDOIDMetaRange>();
    private ConcurrentMap<CDOID, CDOID> idMappings = new ConcurrentHashMap<CDOID, CDOID>();
    private CDOReferenceAdjuster idMapper = new CDOIDMapper(this.idMappings);
    private String rollbackMessage;
    private boolean ensuringReferentialIntegrity;
    private boolean autoReleaseLocksEnabled;

    public TransactionCommitContext(InternalTransaction transaction) {
        this.transaction = transaction;
        IRepository repository = transaction.getRepository();
        this.ensuringReferentialIntegrity = repository instanceof Repository && ((Repository)repository).isEnsuringReferentialIntegrity();
        this.packageRegistry = new TransactionPackageRegistry(repository.getPackageRegistry(false));
        this.packageRegistry.activate();
    }

    @Override
    public int getTransactionID() {
        return this.transaction.getViewID();
    }

    @Override
    public InternalTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public CDOBranchPoint getBranchPoint() {
        return this.transaction.getBranch().getPoint(this.timeStamp);
    }

    @Override
    public String getUserID() {
        return this.getTransaction().getSession().getUserID();
    }

    @Override
    public String getCommitComment() {
        return this.commitComment;
    }

    @Override
    public boolean isAutoReleaseLocksEnabled() {
        return this.autoReleaseLocksEnabled;
    }

    @Override
    public String getRollbackMessage() {
        return this.rollbackMessage;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    @Override
    public InternalCDOPackageUnit[] getNewPackageUnits() {
        return this.newPackageUnits;
    }

    @Override
    public InternalCDORevision[] getNewObjects() {
        return this.newObjects;
    }

    @Override
    public InternalCDORevision[] getDirtyObjects() {
        return this.dirtyObjects;
    }

    @Override
    public CDOID[] getDetachedObjects() {
        return this.detachedObjects;
    }

    public Map<CDOID, EClass> getDetachedObjectTypes() {
        return this.detachedObjectTypes;
    }

    @Override
    public InternalCDORevisionDelta[] getDirtyObjectDeltas() {
        return this.dirtyObjectDeltas;
    }

    @Override
    public List<CDOIDMetaRange> getMetaIDRanges() {
        return Collections.unmodifiableList(this.metaIDRanges);
    }

    @Override
    public Map<CDOID, CDOID> getIDMappings() {
        return Collections.unmodifiableMap(this.idMappings);
    }

    @Override
    public void addIDMapping(CDOID oldID, CDOID newID) {
        if (CDOIDUtil.isNull((CDOID)newID) || newID.isTemporary()) {
            throw new IllegalStateException("newID=" + newID);
        }
        CDOID previousMapping = this.idMappings.putIfAbsent(oldID, newID);
        if (previousMapping != null) {
            throw new IllegalStateException("previousMapping != null");
        }
    }

    @Override
    public void applyIDMappings(OMMonitor monitor) {
        try {
            monitor.begin((double)(this.newObjects.length + this.dirtyObjects.length + this.dirtyObjectDeltas.length));
            this.applyIDMappings(this.newObjects, monitor.fork((double)this.newObjects.length));
            this.applyIDMappings(this.dirtyObjects, monitor.fork((double)this.dirtyObjects.length));
            InternalCDORevisionDelta[] internalCDORevisionDeltaArray = this.dirtyObjectDeltas;
            int n = this.dirtyObjectDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevisionDelta dirtyObjectDelta = internalCDORevisionDeltaArray[n2];
                dirtyObjectDelta.adjustReferences(this.idMapper);
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void preWrite() {
        this.accessor = this.transaction.getRepository().getStore().getWriter(this.transaction);
        StoreThreadLocal.setAccessor(this.accessor);
        StoreThreadLocal.setCommitContext(this);
    }

    @Override
    public void setNewPackageUnits(InternalCDOPackageUnit[] newPackageUnits) {
        this.newPackageUnits = newPackageUnits;
    }

    @Override
    public void setNewObjects(InternalCDORevision[] newObjects) {
        this.newObjects = newObjects;
    }

    @Override
    public void setDirtyObjectDeltas(InternalCDORevisionDelta[] dirtyObjectDeltas) {
        this.dirtyObjectDeltas = dirtyObjectDeltas;
    }

    @Override
    public void setDetachedObjects(CDOID[] detachedObjects) {
        this.detachedObjects = detachedObjects;
    }

    public void setDetachedObjectTypes(Map<CDOID, EClass> detachedObjectTypes) {
        this.detachedObjectTypes = detachedObjectTypes;
    }

    @Override
    public void setAutoReleaseLocksEnabled(boolean on) {
        this.autoReleaseLocksEnabled = on;
    }

    @Override
    public void setCommitComment(String commitComment) {
        this.commitComment = commitComment;
    }

    @Override
    public void write(OMMonitor monitor) {
        try {
            try {
                monitor.begin(107.0);
                this.dirtyObjects = new InternalCDORevision[this.dirtyObjectDeltas.length];
                this.adjustMetaRanges();
                monitor.worked();
                this.lockObjects();
                this.checkXRefs();
                this.timeStamp = this.createTimeStamp(monitor.fork());
                this.adjustForCommit();
                monitor.worked();
                IRepository repository = this.transaction.getRepository();
                this.computeDirtyObjects(monitor.fork());
                monitor.worked();
                repository.notifyWriteAccessHandlers(this.transaction, this, true, monitor.fork());
                this.detachObjects(monitor.fork());
                this.accessor.write(this, monitor.fork(100.0));
            }
            catch (Throwable t) {
                this.handleException(t);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void commit(OMMonitor monitor) {
        try {
            try {
                monitor.begin(101.0);
                this.accessor.commit(monitor.fork(100.0));
                this.updateInfraStructure(monitor.fork());
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
                monitor.done();
            }
            catch (Error ex) {
                this.handleException(ex);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void handleException(Throwable ex) {
        OM.LOG.error(ex);
        String storeClass = this.transaction.getRepository().getStore().getClass().getSimpleName();
        this.rollback("Rollback in " + storeClass + ": " + StringUtil.formatException((Throwable)ex));
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw WrappedException.wrap((Exception)((Exception)ex));
    }

    protected long createTimeStamp(OMMonitor monitor) {
        InternalRepository repository = this.transaction.getSession().getManager().getRepository();
        return repository.createCommitTimeStamp(this.getBranchPoint().getBranch(), monitor);
    }

    protected long getTimeStamp() {
        return this.timeStamp;
    }

    protected void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public void postCommit(boolean success) {
        try {
            try {
                if (success) {
                    ISession sender = this.transaction.getSession();
                    CDOCommitInfo commitInfo = this.createCommitInfo();
                    InternalSessionManager sessionManager = this.transaction.getRepository().getSessionManager();
                    sessionManager.sendCommitNotification((InternalSession)sender, commitInfo);
                }
            }
            catch (Exception ex) {
                OM.LOG.warn("A problem occured while notifying other sessions", (Throwable)ex);
                StoreThreadLocal.release();
                this.accessor = null;
                this.timeStamp = 0L;
                if (this.packageRegistry != null) {
                    this.packageRegistry.deactivate();
                    this.packageRegistry = null;
                }
                if (this.metaIDRanges != null) {
                    this.metaIDRanges.clear();
                    this.metaIDRanges = null;
                }
                if (this.idMappings != null) {
                    this.idMappings.clear();
                    this.idMappings = null;
                }
                this.rollbackMessage = null;
                this.newPackageUnits = null;
                this.newObjects = null;
                this.dirtyObjectDeltas = null;
                this.dirtyObjects = null;
            }
        }
        finally {
            StoreThreadLocal.release();
            this.accessor = null;
            this.timeStamp = 0L;
            if (this.packageRegistry != null) {
                this.packageRegistry.deactivate();
                this.packageRegistry = null;
            }
            if (this.metaIDRanges != null) {
                this.metaIDRanges.clear();
                this.metaIDRanges = null;
            }
            if (this.idMappings != null) {
                this.idMappings.clear();
                this.idMappings = null;
            }
            this.rollbackMessage = null;
            this.newPackageUnits = null;
            this.newObjects = null;
            this.dirtyObjectDeltas = null;
            this.dirtyObjects = null;
        }
    }

    private CDOCommitInfo createCommitInfo() {
        InternalCDOCommitInfoManager commitInfoManager = this.transaction.getRepository().getCommitInfoManager();
        CDOBranch branch = this.transaction.getBranch();
        String userID = this.transaction.getSession().getUserID();
        CDOCommitData commitData = this.createCommitData();
        return commitInfoManager.createCommitInfo(branch, this.timeStamp, userID, this.commitComment, commitData);
    }

    private CDOCommitData createCommitData() {
        IndexedList.ArrayBacked<CDOPackageUnit> newPackageUnitsCollection = new IndexedList.ArrayBacked<CDOPackageUnit>(){

            protected CDOPackageUnit[] getArray() {
                return TransactionCommitContext.this.newPackageUnits;
            }
        };
        IndexedList.ArrayBacked<CDOIDAndVersion> newObjectsCollection = new IndexedList.ArrayBacked<CDOIDAndVersion>(){

            protected CDOIDAndVersion[] getArray() {
                return TransactionCommitContext.this.newObjects;
            }
        };
        IndexedList.ArrayBacked<CDORevisionKey> changedObjectsCollection = new IndexedList.ArrayBacked<CDORevisionKey>(){

            protected CDORevisionKey[] getArray() {
                return TransactionCommitContext.this.dirtyObjectDeltas;
            }
        };
        IndexedList<CDOIDAndVersion> detachedObjectsCollection = new IndexedList<CDOIDAndVersion>(){

            public CDOIDAndVersion get(int i) {
                return (CDOIDAndVersion)TransactionCommitContext.this.detachedRevisions.get(i);
            }

            public int size() {
                return TransactionCommitContext.this.detachedRevisions.size();
            }
        };
        return new CDOCommitDataImpl((List)newPackageUnitsCollection, (List)newObjectsCollection, (List)changedObjectsCollection, (List)detachedObjectsCollection);
    }

    protected void adjustForCommit() {
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = this.newPackageUnits;
        int n = this.newPackageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit newPackageUnit = internalCDOPackageUnitArray[n2];
            newPackageUnit.setTimeStamp(this.timeStamp);
            ++n2;
        }
        CDOBranch branch = this.transaction.getBranch();
        InternalCDORevision[] internalCDORevisionArray = this.newObjects;
        int n3 = this.newObjects.length;
        n = 0;
        while (n < n3) {
            InternalCDORevision newObject = internalCDORevisionArray[n];
            newObject.adjustForCommit(branch, this.timeStamp);
            ++n;
        }
    }

    protected void adjustMetaRanges() {
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = this.newPackageUnits;
        int n = this.newPackageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit newPackageUnit = internalCDOPackageUnitArray[n2];
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = newPackageUnit.getPackageInfos();
            int n3 = internalCDOPackageInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n4];
                this.adjustMetaRange(packageInfo);
                ++n4;
            }
            ++n2;
        }
    }

    private void adjustMetaRange(InternalCDOPackageInfo packageInfo) {
        CDOIDMetaRange oldRange = packageInfo.getMetaIDRange();
        if (!oldRange.isTemporary()) {
            throw new IllegalStateException("!oldRange.isTemporary()");
        }
        int count = oldRange.size();
        CDOIDMetaRange newRange = this.transaction.getRepository().getStore().getNextMetaIDRange(count);
        packageInfo.setMetaIDRange(newRange);
        this.packageRegistry.getMetaInstanceMapper().mapMetaInstances(packageInfo.getEPackage(), newRange);
        int i = 0;
        while (i < count) {
            CDOIDTemp oldID = (CDOIDTemp)oldRange.get(i);
            CDOID newID = newRange.get(i);
            this.idMappings.put((CDOID)oldID, newID);
            ++i;
        }
        this.addMetaIDRange(newRange);
        if (TRACER.isEnabled()) {
            TRACER.format("Mapping meta ID range: {0} --> {1}", new Object[]{oldRange, newRange});
        }
    }

    protected void addMetaIDRange(CDOIDMetaRange range) {
        this.metaIDRanges.add(range);
    }

    protected void lockObjects() throws InterruptedException {
        this.lockedObjects.clear();
        final boolean supportingBranches = this.transaction.getRepository().isSupportingBranches();
        CDOFeatureDeltaVisitorImpl deltaTargetLocker = null;
        if (this.ensuringReferentialIntegrity) {
            deltaTargetLocker = new CDOFeatureDeltaVisitorImpl(){

                public void visit(CDOAddFeatureDelta delta) {
                    TransactionCommitContext.this.lockTarget(delta.getValue(), supportingBranches);
                }

                public void visit(CDOSetFeatureDelta delta) {
                    TransactionCommitContext.this.lockTarget(delta.getValue(), supportingBranches);
                }
            };
            CDOReferenceAdjuster revisionTargetLocker = new CDOReferenceAdjuster(){

                public Object adjustReference(Object value) {
                    TransactionCommitContext.this.lockTarget(value, supportingBranches);
                    return value;
                }
            };
            int i = 0;
            while (i < this.newObjects.length) {
                InternalCDORevision newRevision = this.newObjects[i];
                newRevision.adjustReferences(revisionTargetLocker);
                ++i;
            }
        }
        int i = 0;
        while (i < this.dirtyObjectDeltas.length) {
            InternalCDORevisionDelta delta = this.dirtyObjectDeltas[i];
            CDOID id = delta.getID();
            CDOID key = supportingBranches ? CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)this.transaction.getBranch()) : id;
            this.lockedObjects.add(key);
            if (deltaTargetLocker != null) {
                delta.accept((CDOFeatureDeltaVisitor)deltaTargetLocker);
            }
            ++i;
        }
        i = 0;
        while (i < this.detachedObjects.length) {
            CDOID id = this.detachedObjects[i];
            CDOID key = supportingBranches ? CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)this.transaction.getBranch()) : id;
            this.lockedObjects.add(key);
            ++i;
        }
        try {
            if (!this.lockedObjects.isEmpty()) {
                InternalLockManager lockManager = this.transaction.getRepository().getLockManager();
                lockManager.lock(IRWLockManager.LockType.WRITE, this.transaction, this.lockedObjects, 1000L);
            }
        }
        catch (TimeoutRuntimeException exception) {
            this.lockedObjects.clear();
            throw exception;
        }
    }

    private void lockTarget(Object value, boolean supportingBranches) {
        if (value instanceof CDOIDObject) {
            CDOIDObject id = (CDOIDObject)value;
            CDOIDObject key = supportingBranches ? CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)this.transaction.getBranch()) : id;
            this.lockedObjects.add(key);
        }
    }

    protected void checkXRefs() {
        if (!this.ensuringReferentialIntegrity || this.detachedObjectTypes == null) {
            return;
        }
        final HashMap<EClass, List<EReference>> sourceCandidates = new HashMap<EClass, List<EReference>>();
        XRefsQueryHandler.collectSourceCandidates(this.transaction, this.detachedObjectTypes.values(), sourceCandidates);
        final HashSet xrefs = new HashSet();
        IStoreAccessor.QueryXRefsContext context = new IStoreAccessor.QueryXRefsContext(){

            public int compareTo(CDOBranchPoint o) {
                throw new UnsupportedOperationException();
            }

            public long getTimeStamp() {
                return 0L;
            }

            public CDOBranch getBranch() {
                return TransactionCommitContext.this.transaction.getBranch();
            }

            @Override
            public Map<CDOID, EClass> getTargetObjects() {
                return TransactionCommitContext.this.detachedObjectTypes;
            }

            @Override
            public EReference[] getSourceReferences() {
                return new EReference[0];
            }

            @Override
            public Map<EClass, List<EReference>> getSourceCandidates() {
                return sourceCandidates;
            }

            @Override
            public int getMaxResults() {
                return -1;
            }

            @Override
            public boolean addXRef(CDOID targetID, CDOID sourceID, EReference sourceReference, int sourceIndex) {
                xrefs.add(sourceID);
                return true;
            }
        };
        this.accessor.queryXRefs(context);
        CDOID[] cDOIDArray = this.detachedObjects;
        int n = this.detachedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID id = cDOIDArray[n2];
            xrefs.remove(id);
            ++n2;
        }
        if (!xrefs.isEmpty()) {
            throw new IllegalStateException("The following objects are still pointing to one or more of the objects to be detached: " + xrefs);
        }
    }

    private synchronized void unlockObjects() {
        if (!this.lockedObjects.isEmpty()) {
            InternalLockManager lockManager = this.transaction.getRepository().getLockManager();
            lockManager.unlock(IRWLockManager.LockType.WRITE, this.transaction, this.lockedObjects);
            this.lockedObjects.clear();
        }
    }

    private void computeDirtyObjects(OMMonitor monitor) {
        try {
            monitor.begin((double)this.dirtyObjectDeltas.length);
            int i = 0;
            while (i < this.dirtyObjectDeltas.length) {
                this.dirtyObjects[i] = this.computeDirtyObject(this.dirtyObjectDeltas[i]);
                if (this.dirtyObjects[i] == null) {
                    throw new IllegalStateException("Can not retrieve origin revision for " + this.dirtyObjectDeltas[i]);
                }
                monitor.worked();
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private InternalCDORevision computeDirtyObject(InternalCDORevisionDelta delta) {
        IRepository repository = this.transaction.getRepository();
        InternalCDORevisionManager revisionManager = repository.getRevisionManager();
        InternalCDORevision oldRevision = this.getOldRevision(revisionManager, delta);
        if (oldRevision == null) {
            throw new IllegalStateException("Origin revision not found for " + delta);
        }
        CDOBranch branch = this.transaction.getBranch();
        if (ObjectUtil.equals((Object)oldRevision.getBranch(), (Object)branch) && oldRevision.isHistorical()) {
            throw new ConcurrentModificationException("Attempt by " + this.transaction + " to modify historical revision: " + oldRevision);
        }
        EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)oldRevision.getEClass());
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany()) {
                repository.ensureChunk(oldRevision, feature, 0, oldRevision.getList(feature).size());
            }
            ++n2;
        }
        InternalCDORevision newRevision = oldRevision.copy();
        newRevision.adjustForCommit(branch, this.timeStamp);
        delta.apply((CDORevision)newRevision);
        return newRevision;
    }

    protected InternalCDORevision getOldRevision(InternalCDORevisionManager revisionManager, InternalCDORevisionDelta delta) {
        return revisionManager.getRevisionByVersion(delta.getID(), (CDOBranchVersion)delta, -1, true);
    }

    private void applyIDMappings(InternalCDORevision[] revisions, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                if (revision != null) {
                    CDOID newID = (CDOID)this.idMappings.get(revision.getID());
                    if (newID != null) {
                        revision.setID(newID);
                    }
                    revision.adjustReferences(this.idMapper);
                    monitor.worked();
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public synchronized void rollback(String message) {
        if (this.rollbackMessage == null) {
            this.rollbackMessage = message;
            this.unlockObjects();
            if (this.accessor != null) {
                try {
                    this.accessor.rollback();
                }
                catch (RuntimeException ex) {
                    OM.LOG.warn("Problem while rolling back  the transaction", (Throwable)ex);
                }
            }
        }
    }

    protected IStoreAccessor getAccessor() {
        return this.accessor;
    }

    private void updateInfraStructure(OMMonitor monitor) {
        try {
            monitor.begin(7.0);
            this.addNewPackageUnits(monitor.fork());
            this.addRevisions((CDORevision[])this.newObjects, monitor.fork());
            this.addRevisions((CDORevision[])this.dirtyObjects, monitor.fork());
            this.reviseDetachedObjects(monitor.fork());
            this.unlockObjects();
            monitor.worked();
            if (this.isAutoReleaseLocksEnabled()) {
                this.transaction.getRepository().getLockManager().unlock(this.transaction);
            }
            monitor.worked();
            IRepository repository = this.transaction.getRepository();
            repository.notifyWriteAccessHandlers(this.transaction, this, false, monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewPackageUnits(OMMonitor monitor) {
        InternalCDOPackageRegistry repositoryPackageRegistry;
        IRepository repository = this.transaction.getRepository();
        InternalCDOPackageRegistry internalCDOPackageRegistry = repositoryPackageRegistry = repository.getPackageRegistry(false);
        synchronized (internalCDOPackageRegistry) {
            try {
                monitor.begin((double)this.newPackageUnits.length);
                int i = 0;
                while (i < this.newPackageUnits.length) {
                    this.newPackageUnits[i].setState(CDOPackageUnit.State.LOADED);
                    repositoryPackageRegistry.putPackageUnit(this.newPackageUnits[i]);
                    monitor.worked();
                    ++i;
                }
                repositoryPackageRegistry.getMetaInstanceMapper().mapMetaInstances(this.packageRegistry.getMetaInstanceMapper());
            }
            finally {
                monitor.done();
            }
        }
    }

    private void addRevisions(CDORevision[] revisions, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            InternalCDORevisionManager revisionManager = this.transaction.getRepository().getRevisionManager();
            CDORevision[] cDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                CDORevision revision = cDORevisionArray[n2];
                if (revision != null && !revisionManager.addRevision(revision)) {
                    throw new IllegalStateException("Revision was not registered: " + revision);
                }
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void reviseDetachedObjects(OMMonitor monitor) {
        try {
            monitor.begin((double)this.detachedRevisions.size());
            long revised = this.getBranchPoint().getTimeStamp() - 1L;
            for (InternalCDORevision revision : this.detachedRevisions) {
                revision.setRevised(revised);
                monitor.worked();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void detachObjects(OMMonitor monitor) {
        this.detachedRevisions.clear();
        InternalCDORevisionManager revisionManager = this.transaction.getRepository().getRevisionManager();
        CDOID[] detachedObjects = this.getDetachedObjects();
        try {
            monitor.begin((double)detachedObjects.length);
            CDOID[] cDOIDArray = detachedObjects;
            int n = detachedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                CDOID id = cDOIDArray[n2];
                InternalCDORevision revision = (InternalCDORevision)revisionManager.getCache().getRevision(id, (CDOBranchPoint)this.transaction);
                if (revision != null) {
                    this.detachedRevisions.add(revision);
                }
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public String toString() {
        return MessageFormat.format("TransactionCommitContext[{0}, {1}, {2}]", this.transaction.getSession(), this.transaction, CDOCommonUtil.formatTimeStamp((long)this.timeStamp));
    }

    public static final class TransactionPackageRegistry
    extends CDOPackageRegistryImpl {
        private static final long serialVersionUID = 1L;

        public TransactionPackageRegistry(InternalCDOPackageRegistry repositoryPackageRegistry) {
            this.delegateRegistry = repositoryPackageRegistry;
            this.setPackageLoader(repositoryPackageRegistry.getPackageLoader());
        }

        public synchronized void putPackageUnit(InternalCDOPackageUnit packageUnit) {
            packageUnit.setPackageRegistry((InternalCDOPackageRegistry)this);
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
            int n = internalCDOPackageInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
                EPackage ePackage = packageInfo.getEPackage();
                this.basicPut(ePackage.getNsURI(), ePackage);
                ++n2;
            }
            this.resetInternalCaches();
        }

        protected void disposePackageUnits() {
        }
    }
}

