/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.embedded;

import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCache;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionManagerImpl;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.embedded.EmbeddedClientSession;
import org.eclipse.emf.cdo.internal.server.embedded.EmbeddedClientSessionProtocol;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.embedded.CDOSession;
import org.eclipse.emf.cdo.server.embedded.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.internal.cdo.session.CDOSessionConfigurationImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.CheckUtil;

public class EmbeddedClientSessionConfiguration
extends CDOSessionConfigurationImpl
implements CDOSessionConfiguration {
    private InternalRepository repository;
    private InternalCDORevisionManager revisionManager;

    public EmbeddedClientSessionConfiguration() {
        throw new UnsupportedOperationException("Embedded sessions are not yet supported");
    }

    public InternalRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IRepository repository) {
        this.checkNotOpen();
        this.repository = (InternalRepository)repository;
    }

    public InternalCDORevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    public void setRevisionManager(CDORevisionManager revisionManager) {
        this.checkNotOpen();
        this.revisionManager = (InternalCDORevisionManager)revisionManager;
    }

    public CDOSession openSession() {
        return (CDOSession)super.openSession();
    }

    public InternalCDOSession createSession() {
        if (this.isActivateOnOpen()) {
            CheckUtil.checkState((Object)this.repository, (String)"Specify a repository");
        }
        return new EmbeddedClientSession(this);
    }

    public void activateSession(InternalCDOSession session) throws Exception {
        super.activateSession(session);
        EmbeddedClientSessionProtocol protocol = new EmbeddedClientSessionProtocol((EmbeddedClientSession)session);
        session.setSessionProtocol((CDOSessionProtocol)protocol);
        protocol.activate();
        protocol.openSession(this.isPassiveUpdateEnabled());
        session.setLastUpdateTime(this.repository.getLastCommitTimeStamp());
        session.setRepositoryInfo((CDORepositoryInfo)new RepositoryInfo());
        this.revisionManager = new CDORevisionManagerImpl();
        this.revisionManager.setSupportingBranches(session.getRepositoryInfo().isSupportingBranches());
        this.revisionManager.setCache(CDORevisionCache.NOOP);
        this.revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)session.getSessionProtocol());
        this.revisionManager.setRevisionLocker((InternalCDORevisionManager.RevisionLocker)session);
        this.revisionManager.activate();
    }

    public void deactivateSession(InternalCDOSession session) throws Exception {
        this.revisionManager.deactivate();
        this.revisionManager = null;
        super.deactivateSession(session);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RepositoryInfo
    implements CDORepositoryInfo {
        public String getName() {
            return EmbeddedClientSessionConfiguration.this.repository.getName();
        }

        public String getUUID() {
            return EmbeddedClientSessionConfiguration.this.repository.getUUID();
        }

        public CDOCommonRepository.Type getType() {
            return EmbeddedClientSessionConfiguration.this.repository.getType();
        }

        public CDOCommonRepository.State getState() {
            return EmbeddedClientSessionConfiguration.this.repository.getState();
        }

        public long getCreationTime() {
            return EmbeddedClientSessionConfiguration.this.repository.getCreationTime();
        }

        public long getTimeStamp() {
            return this.getTimeStamp(false);
        }

        public long getTimeStamp(boolean forceRefresh) {
            return System.currentTimeMillis();
        }

        public CDOID getRootResourceID() {
            return EmbeddedClientSessionConfiguration.this.repository.getRootResourceID();
        }

        public boolean isSupportingAudits() {
            return EmbeddedClientSessionConfiguration.this.repository.isSupportingAudits();
        }

        public boolean isSupportingBranches() {
            return EmbeddedClientSessionConfiguration.this.repository.isSupportingBranches();
        }

        public boolean isEnsuringReferentialIntegrity() {
            if (EmbeddedClientSessionConfiguration.this.repository instanceof Repository) {
                return ((Repository)EmbeddedClientSessionConfiguration.this.repository).isEnsuringReferentialIntegrity();
            }
            return false;
        }

        public String getStoreType() {
            return EmbeddedClientSessionConfiguration.this.repository.getStoreType();
        }

        public Set<CDOID.ObjectType> getObjectIDTypes() {
            return EmbeddedClientSessionConfiguration.this.repository.getObjectIDTypes();
        }
    }
}

