/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.mem;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.server.mem.MEMStoreAccessor;
import org.eclipse.emf.cdo.server.IMEMStore;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.server.LongIDStore;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEMStore
extends LongIDStore
implements IMEMStore,
InternalCDOBranchManager.BranchLoader {
    public static final String TYPE = "mem";
    private long creationTime;
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<Integer, InternalCDOBranchManager.BranchLoader.BranchInfo> branchInfos = new HashMap<Integer, InternalCDOBranchManager.BranchLoader.BranchInfo>();
    private int lastBranchID;
    private int lastLocalBranchID;
    private Map<Object, List<InternalCDORevision>> revisions = new HashMap<Object, List<InternalCDORevision>>();
    private List<CommitInfo> commitInfos = new ArrayList<CommitInfo>();
    private Map<CDOID, EClass> objectTypes = new HashMap<CDOID, EClass>();
    private int listLimit;
    @ReflectUtil.ExcludeFromDump
    private transient EStructuralFeature resourceNameFeature;

    public MEMStore(int listLimit) {
        super(TYPE, MEMStore.set(IStore.ChangeFormat.REVISION, IStore.ChangeFormat.DELTA), MEMStore.set(IStore.RevisionTemporality.NONE, IStore.RevisionTemporality.AUDITING), MEMStore.set(IStore.RevisionParallelism.NONE, IStore.RevisionParallelism.BRANCHING));
        this.setRevisionTemporality(IStore.RevisionTemporality.AUDITING);
        this.setRevisionParallelism(IStore.RevisionParallelism.BRANCHING);
        this.listLimit = listLimit;
    }

    public MEMStore() {
        this(-1);
    }

    @Override
    public synchronized Map<String, String> getPropertyValues(Set<String> names) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : names) {
            String value = this.properties.get(name);
            if (value == null) continue;
            result.put(name, value);
        }
        return result;
    }

    @Override
    public synchronized void setPropertyValues(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    @Override
    public synchronized void removePropertyValues(Set<String> names) {
        for (String name : names) {
            this.properties.remove(name);
        }
    }

    public synchronized int createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        if (branchID == Integer.MAX_VALUE) {
            branchID = ++this.lastBranchID;
        } else if (branchID == Integer.MIN_VALUE) {
            branchID = --this.lastLocalBranchID;
        }
        this.branchInfos.put(branchID, branchInfo);
        return branchID;
    }

    public synchronized InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        return this.branchInfos.get(branchID);
    }

    public synchronized InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo> result = new ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo>();
        for (Map.Entry<Integer, InternalCDOBranchManager.BranchLoader.BranchInfo> entry : this.branchInfos.entrySet()) {
            InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo = entry.getValue();
            if (branchInfo.getBaseBranchID() != branchID) continue;
            int id = entry.getKey();
            result.add(new InternalCDOBranchManager.BranchLoader.SubBranchInfo(id, branchInfo.getName(), branchInfo.getBaseTimeStamp()));
        }
        return result.toArray(new InternalCDOBranchManager.BranchLoader.SubBranchInfo[result.size()]);
    }

    public synchronized int loadBranches(int startID, int endID, CDOBranchHandler handler) {
        int count = 0;
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        for (Map.Entry<Integer, InternalCDOBranchManager.BranchLoader.BranchInfo> entry : this.branchInfos.entrySet()) {
            int id = entry.getKey();
            if (startID > id || id > endID && endID != 0) continue;
            InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo = entry.getValue();
            InternalCDOBranch branch = branchManager.getBranch(id, branchInfo);
            handler.handleBranch((CDOBranch)branch);
            ++count;
        }
        return count;
    }

    public synchronized void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        InternalCDOCommitInfoManager manager = this.getRepository().getCommitInfoManager();
        int i = 0;
        while (i < this.commitInfos.size()) {
            CommitInfo info = this.commitInfos.get(i);
            if (!(startTime != 0L && info.getTimeStamp() < startTime || endTime != 0L && info.getTimeStamp() > endTime || branch != null && !ObjectUtil.equals((Object)info.getBranch(), (Object)branch))) {
                info.handle(manager, handler);
            }
            ++i;
        }
    }

    public synchronized Set<CDOID> readChangeSet(CDOChangeSetSegment[] segments) {
        HashSet<CDOID> ids = new HashSet<CDOID>();
        CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
            for (List<InternalCDORevision> list : this.revisions.values()) {
                this.readChangeSet(segment, list, ids);
            }
            ++n2;
        }
        return ids;
    }

    private void readChangeSet(CDOChangeSetSegment segment, List<InternalCDORevision> list, Set<CDOID> ids) {
        long startTime = segment.getTimeStamp();
        long endTime = segment.getEndTime();
        boolean listCheckDone = false;
        for (InternalCDORevision revision : list) {
            CDOID id = revision.getID();
            if (!listCheckDone) {
                if (ids.contains(id)) {
                    return;
                }
                if (!ObjectUtil.equals((Object)revision.getBranch(), (Object)segment.getBranch())) {
                    return;
                }
                listCheckDone = true;
            }
            if (!CDOCommonUtil.isValidTimeStamp((long)revision.getTimeStamp(), (long)startTime, (long)endTime)) continue;
            ids.add(id);
        }
    }

    public synchronized void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, CDORevisionHandler handler) {
        for (List<InternalCDORevision> list : this.revisions.values()) {
            for (InternalCDORevision revision : list) {
                this.handleRevision(revision, eClass, branch, timeStamp, handler);
            }
        }
    }

    private void handleRevision(InternalCDORevision revision, EClass eClass, CDOBranch branch, long timeStamp, CDORevisionHandler handler) {
        if (eClass != null && revision.getEClass() != eClass) {
            return;
        }
        if (branch != null && !ObjectUtil.equals((Object)revision.getBranch(), (Object)branch)) {
            return;
        }
        if (timeStamp != 0L && revision.getTimeStamp() != timeStamp) {
            return;
        }
        handler.handleRevision((CDORevision)revision);
    }

    @Override
    public int getListLimit() {
        return this.listLimit;
    }

    @Override
    public synchronized void setListLimit(int listLimit) {
        if (listLimit != -1 && this.listLimit != listLimit) {
            for (List<InternalCDORevision> list : this.revisions.values()) {
                this.enforceListLimit(list);
            }
        }
        this.listLimit = listLimit;
    }

    public synchronized List<InternalCDORevision> getCurrentRevisions() {
        ArrayList<InternalCDORevision> simpleRevisions = new ArrayList<InternalCDORevision>();
        for (List<InternalCDORevision> list : this.revisions.values()) {
            InternalCDORevision revision = list.get(list.size() - 1);
            simpleRevisions.add(revision);
        }
        return simpleRevisions;
    }

    public synchronized InternalCDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        Object listKey = this.getListKey(id, branchVersion.getBranch());
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list == null) {
            return null;
        }
        return this.getRevisionByVersion(list, branchVersion.getVersion());
    }

    public synchronized InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        Object listKey = this.getListKey(id, branchPoint.getBranch());
        if (branchPoint.getTimeStamp() == 0L) {
            List<InternalCDORevision> list = this.revisions.get(listKey);
            if (list == null) {
                return null;
            }
            return list.get(list.size() - 1);
        }
        if (!this.getRepository().isSupportingAudits()) {
            throw new UnsupportedOperationException("Auditing not supported");
        }
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list == null) {
            return null;
        }
        return this.getRevision(list, branchPoint);
    }

    public synchronized void addRevision(InternalCDORevision revision) {
        Object listKey = this.getListKey(revision.getID(), revision.getBranch());
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list == null) {
            list = new ArrayList<InternalCDORevision>();
            this.revisions.put(listKey, list);
        }
        this.addRevision(list, revision);
    }

    public synchronized void addCommitInfo(CDOBranch branch, long timeStamp, String userID, String comment) {
        int index = this.commitInfos.size() - 1;
        while (index >= 0) {
            CommitInfo info = this.commitInfos.get(index);
            if (timeStamp > info.getTimeStamp()) break;
            --index;
        }
        CommitInfo commitInfo = new CommitInfo(branch, timeStamp, userID, comment);
        this.commitInfos.add(index + 1, commitInfo);
    }

    public synchronized boolean rollbackRevision(InternalCDORevision revision) {
        CDOID id = revision.getID();
        CDOBranch branch = revision.getBranch();
        int version = revision.getVersion();
        Object listKey = this.getListKey(id, branch);
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list == null) {
            return false;
        }
        Iterator<InternalCDORevision> it = list.iterator();
        while (it.hasNext()) {
            InternalCDORevision rev = it.next();
            if (rev.getVersion() == version) {
                it.remove();
                return true;
            }
            if (rev.getVersion() != version - 1) continue;
            rev.setRevised(0L);
        }
        return false;
    }

    public synchronized DetachedCDORevision detachObject(CDOID id, CDOBranch branch, long timeStamp) {
        int version;
        InternalCDORevision revision;
        Object listKey = this.getListKey(id, branch);
        List<InternalCDORevision> list = this.revisions.get(listKey);
        if (list != null && (revision = this.getRevision(list, branch.getHead())) != null) {
            revision.setRevised(timeStamp - 1L);
        }
        if (list == null) {
            list = new ArrayList<InternalCDORevision>();
            this.revisions.put(listKey, list);
            version = 1;
        } else {
            version = this.getHighestVersion(list) + 1;
        }
        EClass eClass = this.getObjectType(id);
        DetachedCDORevision detached = new DetachedCDORevision(eClass, id, branch, version, timeStamp);
        this.addRevision(list, (InternalCDORevision)detached);
        return detached;
    }

    public synchronized void queryResources(IStoreAccessor.QueryResourcesContext context) {
        CDOID folderID = context.getFolderID();
        String name = context.getName();
        boolean exactMatch = context.exactMatch();
        for (Map.Entry<Object, List<InternalCDORevision>> entry : this.revisions.entrySet()) {
            boolean match;
            CDOID revisionFolder;
            InternalCDORevision revision;
            List<InternalCDORevision> list;
            CDOBranch branch = this.getBranch(entry.getKey());
            if (!ObjectUtil.equals((Object)branch, (Object)context.getBranch()) || (list = entry.getValue()).isEmpty() || (revision = list.get(0)) instanceof SyntheticCDORevision || !revision.isResourceNode() || (revision = this.getRevision(list, (CDOBranchPoint)context)) == null || revision instanceof DetachedCDORevision || !CDOIDUtil.equals((CDOID)(revisionFolder = (CDOID)revision.data().getContainerID()), (CDOID)folderID)) continue;
            String revisionName = (String)revision.data().get(this.resourceNameFeature, 0);
            boolean useEquals = exactMatch || revisionName == null || name == null;
            boolean bl = match = useEquals ? ObjectUtil.equals((Object)revisionName, (Object)name) : revisionName.startsWith(name);
            if (match && !context.addResource(revision.getID())) break;
        }
    }

    public synchronized void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        Set<CDOID> targetIDs = context.getTargetObjects().keySet();
        Map<EClass, List<EReference>> sourceCandidates = context.getSourceCandidates();
        for (Map.Entry<Object, List<InternalCDORevision>> entry : this.revisions.entrySet()) {
            InternalCDORevision revision;
            List<InternalCDORevision> list;
            CDOBranch branch = this.getBranch(entry.getKey());
            if (!ObjectUtil.equals((Object)branch, (Object)context.getBranch()) || (list = entry.getValue()).isEmpty() || (revision = this.getRevision(list, (CDOBranchPoint)context)) == null || revision instanceof SyntheticCDORevision) continue;
            EClass eClass = revision.getEClass();
            CDOID sourceID = revision.getID();
            List<EReference> eReferences = sourceCandidates.get(eClass);
            if (eReferences == null) continue;
            for (EReference eReference : eReferences) {
                Object value = revision.getValue((EStructuralFeature)eReference);
                if (eReference.isMany()) {
                    List ids = (List)value;
                    int index = 0;
                    for (CDOID id : ids) {
                        if (this.queryXRefs(context, targetIDs, id, sourceID, eReference, index++)) continue;
                        return;
                    }
                    continue;
                }
                CDOID id = (CDOID)value;
                if (this.queryXRefs(context, targetIDs, id, sourceID, eReference, 0)) continue;
                return;
            }
        }
    }

    private boolean queryXRefs(IStoreAccessor.QueryXRefsContext context, Set<CDOID> targetIDs, CDOID targetID, CDOID sourceID, EReference sourceReference, int index) {
        for (CDOID id : targetIDs) {
            if (!id.equals(targetID) || context.addXRef(targetID, sourceID, sourceReference, index)) continue;
            return false;
        }
        return true;
    }

    @Override
    public MEMStoreAccessor createReader(ISession session) {
        return new MEMStoreAccessor(this, session);
    }

    @Override
    public MEMStoreAccessor createWriter(ITransaction transaction) {
        return new MEMStoreAccessor(this, transaction);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public boolean isFirstTime() {
        return true;
    }

    public synchronized Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        result.put((CDOBranch)branchManager.getMainBranch(), new ArrayList());
        for (Integer n : this.branchInfos.keySet()) {
            InternalCDOBranch branch = branchManager.getBranch(n.intValue());
            result.put((CDOBranch)branch, new ArrayList());
        }
        for (List list : this.revisions.values()) {
            for (InternalCDORevision revision : list) {
                CDOBranch branch = revision.getBranch();
                List resultList = (List)result.get(branch);
                resultList.add(revision);
            }
        }
        return result;
    }

    @Override
    public synchronized EClass getObjectType(CDOID id) {
        return this.objectTypes.get(id);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.creationTime = System.currentTimeMillis();
    }

    protected void doDeactivate() throws Exception {
        this.revisions.clear();
        this.branchInfos.clear();
        this.commitInfos.clear();
        this.objectTypes.clear();
        this.properties.clear();
        this.resourceNameFeature = null;
        this.lastBranchID = 0;
        this.lastLocalBranchID = 0;
        super.doDeactivate();
    }

    @Override
    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return null;
    }

    @Override
    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return null;
    }

    private Object getListKey(CDOID id, CDOBranch branch) {
        if (this.getRevisionParallelism() == IStore.RevisionParallelism.NONE) {
            return id;
        }
        return new ListKey(id, branch);
    }

    private CDOBranch getBranch(Object key) {
        if (key instanceof ListKey) {
            return ((ListKey)key).getBranch();
        }
        return this.getRepository().getBranchManager().getMainBranch();
    }

    private int getHighestVersion(List<InternalCDORevision> list) {
        int version = 0;
        for (InternalCDORevision revision : list) {
            if (revision.getVersion() <= version) continue;
            version = revision.getVersion();
        }
        return version;
    }

    private InternalCDORevision getRevisionByVersion(List<InternalCDORevision> list, int version) {
        for (InternalCDORevision revision : list) {
            if (revision.getVersion() != version) continue;
            return revision;
        }
        return null;
    }

    private InternalCDORevision getRevision(List<InternalCDORevision> list, CDOBranchPoint branchPoint) {
        long timeStamp = branchPoint.getTimeStamp();
        for (InternalCDORevision revision : list) {
            if (!(timeStamp == 0L ? !revision.isHistorical() : revision.isValid(timeStamp))) continue;
            return revision;
        }
        return null;
    }

    private void addRevision(List<InternalCDORevision> list, InternalCDORevision revision) {
        CDOID id;
        InternalCDORevision oldRevision;
        int version = revision.getVersion();
        InternalCDORevision rev = this.getRevisionByVersion(list, version);
        if (rev != null) {
            rev = this.getRevisionByVersion(list, version);
            throw new IllegalStateException("Concurrent modification of " + rev.getEClass().getName() + "@" + rev.getID());
        }
        int oldVersion = version - 1;
        if (oldVersion >= 0 && (oldRevision = this.getRevisionByVersion(list, oldVersion)) != null) {
            oldRevision.setRevised(revision.getTimeStamp() - 1L);
        }
        if (!(revision instanceof SyntheticCDORevision) && revision.isResource()) {
            this.checkDuplicateResource(revision);
        }
        list.add(revision);
        if (this.listLimit != -1) {
            this.enforceListLimit(list);
        }
        if (!this.objectTypes.containsKey(id = revision.getID())) {
            this.objectTypes.put(id, revision.getEClass());
        }
    }

    private void checkDuplicateResource(InternalCDORevision revision) {
        if (this.resourceNameFeature == null) {
            this.resourceNameFeature = revision.getEClass().getEStructuralFeature("name");
        }
        CDOID revisionFolder = (CDOID)revision.data().getContainerID();
        String revisionName = (String)revision.data().get(this.resourceNameFeature, 0);
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        CDOID resourceID = accessor.readResourceID(revisionFolder, revisionName, (CDOBranchPoint)revision);
        if (!CDOIDUtil.isNull((CDOID)resourceID)) {
            throw new IllegalStateException("Duplicate resource: name=" + revisionName + ", folderID=" + revisionFolder);
        }
    }

    private void enforceListLimit(List<InternalCDORevision> list) {
        while (list.size() > this.listLimit) {
            list.remove(0);
        }
    }

    private static final class CommitInfo {
        private CDOBranch branch;
        private long timeStamp;
        private String userID;
        private String comment;

        public CommitInfo(CDOBranch branch, long timeStamp, String userID, String comment) {
            this.branch = branch;
            this.timeStamp = timeStamp;
            this.userID = userID;
            this.comment = comment;
        }

        public CDOBranch getBranch() {
            return this.branch;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void handle(InternalCDOCommitInfoManager manager, CDOCommitInfoHandler handler) {
            CDOCommitInfo commitInfo = manager.createCommitInfo(this.branch, this.timeStamp, this.userID, this.comment, null);
            handler.handleCommitInfo(commitInfo);
        }
    }

    private static final class ListKey {
        private CDOID id;
        private CDOBranch branch;

        public ListKey(CDOID id, CDOBranch branch) {
            this.id = id;
            this.branch = branch;
        }

        public CDOID getID() {
            return this.id;
        }

        public CDOBranch getBranch() {
            return this.branch;
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.branch.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ListKey) {
                ListKey that = (ListKey)obj;
                return ObjectUtil.equals((Object)this.id, (Object)that.getID()) && ObjectUtil.equals((Object)this.branch, (Object)that.getBranch());
            }
            return false;
        }

        public String toString() {
            return MessageFormat.format("{0}:{1}", this.id, this.branch.getID());
        }
    }
}

