/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.syncing;

import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.internal.server.syncing.SynchronizableRepository;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;

public class FailoverParticipant
extends SynchronizableRepository {
    public FailoverParticipant() {
        this.setState(OFFLINE);
    }

    public void setType(CDOCommonRepository.Type type) {
        this.checkArg(type == MASTER || type == BACKUP, "Type must be MASTER or BACKUP");
        super.setType(type);
    }

    protected void changingType(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        if (this.isActive()) {
            if (newType == MASTER) {
                this.doStopSynchronization();
            } else {
                this.setReplicationCountersToLatest();
                this.doStartSynchronization();
            }
        }
        super.changingType(oldType, newType);
    }

    protected void initRootResource() {
        if (this.getType() == BACKUP) {
            super.initRootResource();
        } else {
            this.doInitRootResource();
        }
    }

    protected void doStartSynchronization() {
        super.startSynchronization();
    }

    protected void doStopSynchronization() {
        super.stopSynchronization();
    }

    protected void startSynchronization() {
        if (this.getType() == BACKUP) {
            this.doStartSynchronization();
        }
    }

    protected void stopSynchronization() {
        if (this.getType() == BACKUP) {
            this.doStopSynchronization();
        }
    }

    public InternalCommitContext createCommitContext(InternalTransaction transaction) {
        if (this.getType() == BACKUP && transaction.getSession() != this.getReplicatorSession()) {
            throw new IllegalStateException("Only the repository synchronizer is allowed to commit transactions to a backup repository");
        }
        return this.createNormalCommitContext(transaction);
    }
}

