/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.syncing;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.internal.server.syncing.SynchronizableRepository;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.collection.IndexedList;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.transaction.TransactionException;

public class OfflineClone
extends SynchronizableRepository {
    public OfflineClone() {
        this.setState(OFFLINE);
    }

    public final CDOCommonRepository.Type getType() {
        return CLONE;
    }

    public final void setType(CDOCommonRepository.Type type) {
        throw new UnsupportedOperationException();
    }

    public InternalCommitContext createCommitContext(InternalTransaction transaction) {
        CDOBranch branch = transaction.getBranch();
        if (branch.isLocal()) {
            return this.createNormalCommitContext(transaction);
        }
        if (this.getState() != ONLINE) {
            return this.createBranchingCommitContext(transaction, branch);
        }
        return this.createWriteThroughCommitContext(transaction);
    }

    protected InternalCommitContext createBranchingCommitContext(InternalTransaction transaction, CDOBranch branch) {
        long timeStamp = this.createCommitTimeStamp(null, (OMMonitor)new Monitor());
        CDOBranch offlineBranch = this.createOfflineBranch(branch, timeStamp - 1L);
        transaction.setBranchPoint(offlineBranch.getHead());
        return new BranchingCommitContext(transaction, timeStamp);
    }

    protected InternalCommitContext createWriteThroughCommitContext(InternalTransaction transaction) {
        return new WriteThroughCommitContext(transaction);
    }

    protected CDOBranch createOfflineBranch(CDOBranch baseBranch, long baseTimeStamp) {
        try {
            StoreThreadLocal.setSession(this.getReplicatorSession());
            InternalCDOBranchManager branchManager = this.getBranchManager();
            InternalCDOBranch internalCDOBranch = branchManager.createBranch(Integer.MIN_VALUE, "Offline-" + baseTimeStamp, (InternalCDOBranch)baseBranch, baseTimeStamp);
            return internalCDOBranch;
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected final class BranchingCommitContext
    extends TransactionCommitContext {
        private long timeStamp;

        public BranchingCommitContext(InternalTransaction transaction, long timeStamp) {
            super(transaction);
            this.timeStamp = timeStamp;
        }

        protected void lockObjects() throws InterruptedException {
        }

        protected long createTimeStamp(OMMonitor monitor) {
            return this.timeStamp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class CommitContextData
    implements CDOCommitData {
        private InternalCommitContext commitContext;

        public CommitContextData(InternalCommitContext commitContext) {
            this.commitContext = commitContext;
        }

        public boolean isEmpty() {
            return false;
        }

        public List<CDOPackageUnit> getNewPackageUnits() {
            final InternalCDOPackageUnit[] newPackageUnits = this.commitContext.getNewPackageUnits();
            return new IndexedList<CDOPackageUnit>(){

                public CDOPackageUnit get(int index) {
                    return newPackageUnits[index];
                }

                public int size() {
                    return newPackageUnits.length;
                }
            };
        }

        public List<CDOIDAndVersion> getNewObjects() {
            final InternalCDORevision[] newObjects = this.commitContext.getNewObjects();
            return new IndexedList<CDOIDAndVersion>(){

                public CDOIDAndVersion get(int index) {
                    return newObjects[index];
                }

                public int size() {
                    return newObjects.length;
                }
            };
        }

        public List<CDORevisionKey> getChangedObjects() {
            final InternalCDORevisionDelta[] changedObjects = this.commitContext.getDirtyObjectDeltas();
            return new IndexedList<CDORevisionKey>(){

                public CDORevisionKey get(int index) {
                    return changedObjects[index];
                }

                public int size() {
                    return changedObjects.length;
                }
            };
        }

        public List<CDOIDAndVersion> getDetachedObjects() {
            final CDOID[] detachedObjects = this.commitContext.getDetachedObjects();
            return new IndexedList<CDOIDAndVersion>(){

                public CDOIDAndVersion get(int index) {
                    return CDOIDUtil.createIDAndVersion((CDOID)detachedObjects[index], (int)0);
                }

                public int size() {
                    return detachedObjects.length;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class WriteThroughCommitContext
    extends TransactionCommitContext {
        public WriteThroughCommitContext(InternalTransaction transaction) {
            super(transaction);
        }

        @Override
        public void preWrite() {
        }

        @Override
        public void write(OMMonitor monitor) {
        }

        @Override
        public void commit(OMMonitor monitor) {
            InternalTransaction transaction = this.getTransaction();
            CDOBranch branch = transaction.getBranch();
            String userID = this.getUserID();
            String comment = this.getCommitComment();
            CommitContextData commitData = new CommitContextData(this);
            CDOSessionProtocol sessionProtocol = OfflineClone.this.getSynchronizer().getRemoteSession().getSessionProtocol();
            CDOSessionProtocol.CommitTransactionResult result = sessionProtocol.commitDelegation(branch, userID, comment, (CDOCommitData)commitData, monitor);
            String rollbackMessage = result.getRollbackMessage();
            if (rollbackMessage != null) {
                throw new TransactionException(rollbackMessage);
            }
            long timeStamp = result.getTimeStamp();
            this.setTimeStamp(timeStamp);
            this.addMetaIDRanges(commitData.getNewPackageUnits());
            this.addIDMappings(result.getIDMappings());
            this.applyIDMappings((OMMonitor)new Monitor());
            super.preWrite();
            super.write((OMMonitor)new Monitor());
            super.commit((OMMonitor)new Monitor());
            OfflineClone.this.setLastCommitTimeStamp(timeStamp);
            OfflineClone.this.setLastReplicatedCommitTime(timeStamp);
        }

        @Override
        protected long createTimeStamp(OMMonitor monitor) {
            return this.getTimeStamp();
        }

        @Override
        protected void lockObjects() throws InterruptedException {
        }

        @Override
        protected void adjustMetaRanges() {
        }

        private void addMetaIDRanges(List<CDOPackageUnit> newPackageUnits) {
            for (CDOPackageUnit newPackageUnit : newPackageUnits) {
                CDOPackageInfo[] cDOPackageInfoArray = newPackageUnit.getPackageInfos();
                int n = cDOPackageInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOPackageInfo packageInfo = cDOPackageInfoArray[n2];
                    this.addMetaIDRange(packageInfo.getMetaIDRange());
                    ++n2;
                }
            }
        }

        private void addIDMappings(Map<CDOID, CDOID> idMappings) {
            for (Map.Entry<CDOID, CDOID> idMapping : idMappings.entrySet()) {
                CDOID oldID = idMapping.getKey();
                CDOID newID = idMapping.getValue();
                this.addIDMapping(oldID, newID);
            }
        }
    }
}

