/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.syncing;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitDataImpl;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.syncing.ReplicatorCommitContext;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepositorySynchronizer;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalSynchronizableRepository;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SynchronizableRepository
extends Repository.Default
implements InternalSynchronizableRepository {
    protected static final CDOCommonRepository.Type MASTER = CDOCommonRepository.Type.MASTER;
    protected static final CDOCommonRepository.Type BACKUP = CDOCommonRepository.Type.BACKUP;
    protected static final CDOCommonRepository.Type CLONE = CDOCommonRepository.Type.CLONE;
    protected static final CDOCommonRepository.State INITIAL = CDOCommonRepository.State.INITIAL;
    protected static final CDOCommonRepository.State OFFLINE = CDOCommonRepository.State.OFFLINE;
    protected static final CDOCommonRepository.State SYNCING = CDOCommonRepository.State.SYNCING;
    protected static final CDOCommonRepository.State ONLINE = CDOCommonRepository.State.ONLINE;
    private static final String PROP_LAST_REPLICATED_BRANCH_ID = "org.eclipse.emf.cdo.server.lastReplicatedBranchID";
    private static final String PROP_LAST_REPLICATED_COMMIT_TIME = "org.eclipse.emf.cdo.server.lastReplicatedCommitTime";
    private static final String PROP_GRACEFULLY_SHUT_DOWN = "org.eclipse.emf.cdo.server.gracefullyShutDown";
    private InternalRepositorySynchronizer synchronizer;
    private InternalSession replicatorSession;
    private int lastReplicatedBranchID = 0;
    private long lastReplicatedCommitTime = 0L;
    private int lastTransactionID;

    @Override
    public InternalRepositorySynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    @Override
    public void setSynchronizer(InternalRepositorySynchronizer synchronizer) {
        this.checkInactive();
        this.synchronizer = synchronizer;
    }

    @Override
    public InternalSession getReplicatorSession() {
        return this.replicatorSession;
    }

    @Override
    public Object[] getElements() {
        List<Object> list = Arrays.asList(super.getElements());
        list.add(this.synchronizer);
        return list.toArray();
    }

    @Override
    public int getLastReplicatedBranchID() {
        return this.lastReplicatedBranchID;
    }

    @Override
    public void setLastReplicatedBranchID(int lastReplicatedBranchID) {
        if (this.lastReplicatedBranchID < lastReplicatedBranchID) {
            this.lastReplicatedBranchID = lastReplicatedBranchID;
        }
    }

    @Override
    public long getLastReplicatedCommitTime() {
        return this.lastReplicatedCommitTime;
    }

    @Override
    public void setLastReplicatedCommitTime(long lastReplicatedCommitTime) {
        if (this.lastReplicatedCommitTime < lastReplicatedCommitTime) {
            this.lastReplicatedCommitTime = lastReplicatedCommitTime;
        }
    }

    @Override
    public boolean isSqueezeCommitInfos() {
        return this.synchronizer.isSqueezeCommitInfos();
    }

    public void handleBranch(CDOBranch branch) {
        if (branch.isLocal()) {
            return;
        }
        int branchID = branch.getID();
        String name = branch.getName();
        CDOBranchPoint base = branch.getBase();
        InternalCDOBranch baseBranch = (InternalCDOBranch)base.getBranch();
        long baseTimeStamp = base.getTimeStamp();
        InternalCDOBranchManager branchManager = this.getBranchManager();
        branchManager.createBranch(branchID, name, baseBranch, baseTimeStamp);
        this.setLastReplicatedBranchID(branchID);
    }

    public void handleCommitInfo(CDOCommitInfo commitInfo) {
        CDOBranch branch = commitInfo.getBranch();
        if (branch.isLocal()) {
            return;
        }
        long timeStamp = commitInfo.getTimeStamp();
        CDOBranchPoint head = branch.getHead();
        InternalTransaction transaction = this.replicatorSession.openTransaction(++this.lastTransactionID, head);
        boolean squeezed = this.isSqueezeCommitInfos() && this.lastReplicatedCommitTime != 0L;
        ReplicatorCommitContext commitContext = new ReplicatorCommitContext(transaction, commitInfo, squeezed);
        commitContext.preWrite();
        boolean success = false;
        try {
            commitContext.write((OMMonitor)new Monitor());
            commitContext.commit((OMMonitor)new Monitor());
            this.setLastCommitTimeStamp(timeStamp);
            this.setLastReplicatedCommitTime(timeStamp);
            success = true;
        }
        finally {
            commitContext.postCommit(success);
            transaction.close();
        }
    }

    public void replicateRaw(CDODataInput in) throws IOException {
        try {
            int fromBranchID = this.lastReplicatedBranchID + 1;
            int toBranchID = in.readInt();
            long fromCommitTime = this.lastReplicatedCommitTime + 1L;
            long toCommitTime = in.readLong();
            StoreThreadLocal.setSession(this.replicatorSession);
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            accessor.rawImport(in, fromBranchID, toBranchID, fromCommitTime, toCommitTime);
            this.replicateRawReviseRevisions();
            this.replicateRawNotifyClients(this.lastReplicatedCommitTime, toCommitTime);
            this.setLastReplicatedBranchID(toBranchID);
            this.setLastReplicatedCommitTime(toCommitTime);
            this.setLastCommitTimeStamp(toCommitTime);
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    private void replicateRawReviseRevisions() {
        InternalCDORevisionCache cache = this.getRevisionManager().getCache();
        for (CDORevision revision : cache.getCurrentRevisions()) {
            cache.removeRevision(revision.getID(), (CDOBranchVersion)revision);
        }
    }

    private void replicateRawNotifyClients(long fromCommitTime, long toCommitTime) {
        InternalCDOCommitInfoManager manager = this.getCommitInfoManager();
        InternalSessionManager sessionManager = this.getSessionManager();
        Map<CDOBranch, TimeRange> branches = this.replicateRawGetBranches(fromCommitTime, toCommitTime);
        for (Map.Entry<CDOBranch, TimeRange> entry : branches.entrySet()) {
            CDOBranch branch = entry.getKey();
            TimeRange range = entry.getValue();
            fromCommitTime = range.getTime1();
            toCommitTime = range.getTime2();
            CDOBranchPoint startPoint = branch.getPoint(fromCommitTime);
            CDOBranchPoint endPoint = branch.getPoint(toCommitTime);
            CDOChangeSetData changeSet = this.getChangeSet(startPoint, endPoint);
            List newPackages = Collections.emptyList();
            List newObjects = changeSet.getNewObjects();
            List changedObjects = changeSet.getChangedObjects();
            List detachedObjects = changeSet.getDetachedObjects();
            CDOCommitDataImpl data = new CDOCommitDataImpl(newPackages, newObjects, changedObjects, detachedObjects);
            String comment = "<replicate raw commits>";
            CDOCommitInfo commitInfo = manager.createCommitInfo(branch, toCommitTime, "CDO_SYSTEM", comment, (CDOCommitData)data);
            sessionManager.sendCommitNotification(this.replicatorSession, commitInfo);
        }
    }

    private Map<CDOBranch, TimeRange> replicateRawGetBranches(long fromCommitTime, long toCommitTime) {
        final HashMap<CDOBranch, TimeRange> branches = new HashMap<CDOBranch, TimeRange>();
        CDOCommitInfoHandler handler = new CDOCommitInfoHandler(){

            public void handleCommitInfo(CDOCommitInfo commitInfo) {
                CDOBranch branch = commitInfo.getBranch();
                long timeStamp = commitInfo.getTimeStamp();
                TimeRange range = (TimeRange)branches.get(branch);
                if (range == null) {
                    branches.put(branch, new TimeRange(timeStamp));
                } else {
                    range.update(timeStamp);
                }
            }
        };
        this.getCommitInfoManager().getCommitInfos(fromCommitTime, toCommitTime, handler);
        return branches;
    }

    @Override
    public abstract InternalCommitContext createCommitContext(InternalTransaction var1);

    protected InternalCommitContext createNormalCommitContext(InternalTransaction transaction) {
        return super.createCommitContext(transaction);
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.synchronizer, "synchronizer");
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        InternalStore store = this.getStore();
        if (!store.isFirstTime()) {
            Map<String, String> map = store.getPropertyValues(Collections.singleton(PROP_GRACEFULLY_SHUT_DOWN));
            if (!map.containsKey(PROP_GRACEFULLY_SHUT_DOWN)) {
                this.setReplicationCountersToLatest();
            } else {
                HashSet<String> names = new HashSet<String>();
                names.add(PROP_LAST_REPLICATED_BRANCH_ID);
                names.add(PROP_LAST_REPLICATED_COMMIT_TIME);
                map = store.getPropertyValues(names);
                this.setLastReplicatedBranchID(Integer.valueOf(map.get(PROP_LAST_REPLICATED_BRANCH_ID)));
                this.setLastReplicatedCommitTime(Long.valueOf(map.get(PROP_LAST_REPLICATED_COMMIT_TIME)));
            }
        }
        store.removePropertyValues(Collections.singleton(PROP_GRACEFULLY_SHUT_DOWN));
        if (this.getType() != MASTER) {
            this.startSynchronization();
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.stopSynchronization();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_LAST_REPLICATED_BRANCH_ID, Integer.toString(this.lastReplicatedBranchID));
        map.put(PROP_LAST_REPLICATED_COMMIT_TIME, Long.toString(this.lastReplicatedCommitTime));
        map.put(PROP_GRACEFULLY_SHUT_DOWN, Boolean.TRUE.toString());
        InternalStore store = this.getStore();
        store.setPropertyValues(map);
        super.doDeactivate();
    }

    protected void startSynchronization() {
        this.replicatorSession = this.getSessionManager().openSession(null);
        this.replicatorSession.options().setPassiveUpdateEnabled(false);
        this.synchronizer.setLocalRepository(this);
        this.synchronizer.activate();
    }

    protected void stopSynchronization() {
        if (this.synchronizer != null) {
            this.synchronizer.deactivate();
        }
    }

    protected void setReplicationCountersToLatest() {
        this.setLastReplicatedBranchID(this.getStore().getLastBranchID());
        this.setLastReplicatedCommitTime(this.getStore().getLastNonLocalCommitTime());
    }

    protected void doInitRootResource() {
        super.initRootResource();
    }

    @Override
    protected void initRootResource() {
        this.setState(INITIAL);
    }

    private static final class TimeRange {
        private long time1;
        private long time2;

        public TimeRange(long time) {
            this.time1 = time;
            this.time2 = time;
        }

        public void update(long time) {
            if (time < this.time1) {
                this.time1 = time;
            }
            if (time > this.time2) {
                this.time2 = time;
            }
        }

        public long getTime1() {
            return this.time1;
        }

        public long getTime2() {
            return this.time2;
        }

        public String toString() {
            return "[" + CDOCommonUtil.formatTimeStamp((long)this.time1) + " - " + CDOCommonUtil.formatTimeStamp((long)this.time1) + "]";
        }
    }
}

