/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.LongIDStore;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public abstract class LongIDStoreAccessor
extends StoreAccessor {
    protected LongIDStoreAccessor(Store store, ISession session) {
        super(store, session);
    }

    protected LongIDStoreAccessor(Store store, ITransaction transaction) {
        super(store, transaction);
    }

    protected void addIDMappings(InternalCommitContext commitContext, OMMonitor monitor) {
        try {
            LongIDStore longIDStore = (LongIDStore)this.getStore();
            InternalCDORevision[] newObjects = commitContext.getNewObjects();
            monitor.begin((double)newObjects.length);
            InternalCDORevision[] internalCDORevisionArray = newObjects;
            int n = newObjects.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                CDOID id = revision.getID();
                if (id instanceof CDOIDTemp) {
                    CDOIDTemp oldID = (CDOIDTemp)id;
                    CDOID newID = longIDStore.getNextCDOID(revision.getBranch().isLocal());
                    if (CDOIDUtil.isNull((CDOID)newID) || newID.isTemporary()) {
                        throw new IllegalStateException("newID=" + newID);
                    }
                    commitContext.addIDMapping((CDOID)oldID, newID);
                }
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }
}

