/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitDataImpl;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class StoreAccessor
extends Lifecycle
implements IStoreAccessor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, StoreAccessor.class);
    private List<IStoreAccessor.CommitContext> commitContexts = new ArrayList<IStoreAccessor.CommitContext>();
    private Store store;
    private Object context;
    private boolean reader;

    private StoreAccessor(Store store, Object context, boolean reader) {
        this.store = store;
        this.context = context;
        this.reader = reader;
    }

    protected StoreAccessor(Store store, ISession session) {
        this(store, session, true);
    }

    protected StoreAccessor(Store store, ITransaction transaction) {
        this(store, transaction, false);
    }

    public Store getStore() {
        return this.store;
    }

    public boolean isReader() {
        return this.reader;
    }

    public InternalSession getSession() {
        if (this.context instanceof ITransaction) {
            return (InternalSession)((ITransaction)this.context).getSession();
        }
        return (InternalSession)this.context;
    }

    public ITransaction getTransaction() {
        if (this.context instanceof ITransaction) {
            return (ITransaction)this.context;
        }
        return null;
    }

    void setContext(Object context) {
        this.context = context;
    }

    public CDOID readResourceID(CDOID folderID, String name, CDOBranchPoint branchPoint) {
        IStoreAccessor.QueryResourcesContext.ExactMatch context = Store.createExactMatchContext(folderID, name, branchPoint);
        this.queryResources(context);
        return context.getResourceID();
    }

    public CDOCommitData loadCommitData(long timeStamp) {
        CommitDataRevisionHandler handler = new CommitDataRevisionHandler(this, timeStamp);
        return handler.getCommitData();
    }

    public void write(InternalCommitContext context, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing transaction: {0}", new Object[]{this.getTransaction()});
        }
        this.commitContexts.add(context);
        CDOBranch branch = context.getBranchPoint().getBranch();
        long timeStamp = context.getBranchPoint().getTimeStamp();
        String userID = context.getUserID();
        String commitComment = context.getCommitComment();
        boolean deltas = this.store.getSupportedChangeFormats().contains((Object)IStore.ChangeFormat.DELTA);
        InternalCDOPackageUnit[] newPackageUnits = context.getNewPackageUnits();
        InternalCDORevision[] newObjects = context.getNewObjects();
        CDOID[] detachedObjects = context.getDetachedObjects();
        int dirtyCount = deltas ? context.getDirtyObjectDeltas().length : context.getDirtyObjects().length;
        try {
            monitor.begin((double)(1 + newPackageUnits.length + 2 + newObjects.length + detachedObjects.length + dirtyCount));
            this.writeCommitInfo(branch, timeStamp, userID, commitComment, monitor.fork(1.0));
            if (newPackageUnits.length != 0) {
                this.writePackageUnits(newPackageUnits, monitor.fork((double)newPackageUnits.length));
            }
            this.addIDMappings(context, monitor.fork());
            this.applyIDMappings(context, monitor);
            if (detachedObjects.length != 0) {
                this.detachObjects(detachedObjects, branch, timeStamp, monitor.fork((double)detachedObjects.length));
            }
            if (newObjects.length != 0) {
                this.writeRevisions(newObjects, branch, monitor.fork((double)newObjects.length));
            }
            if (dirtyCount != 0) {
                if (deltas) {
                    this.writeRevisionDeltas(context.getDirtyObjectDeltas(), branch, timeStamp, monitor.fork((double)dirtyCount));
                } else {
                    this.writeRevisions(context.getDirtyObjects(), branch, monitor.fork((double)dirtyCount));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public final void commit(OMMonitor monitor) {
        this.doCommit(monitor);
        long latest = 0L;
        long latestNonLocal = 0L;
        for (IStoreAccessor.CommitContext commitContext : this.commitContexts) {
            CDOBranch branch;
            CDOBranchPoint branchPoint = commitContext.getBranchPoint();
            long timeStamp = branchPoint.getTimeStamp();
            if (timeStamp > latest) {
                latest = timeStamp;
            }
            if ((branch = branchPoint.getBranch()).isLocal() || timeStamp <= latestNonLocal) continue;
            latestNonLocal = timeStamp;
        }
        this.store.setLastCommitTime(latest);
        this.store.setLastNonLocalCommitTime(latestNonLocal);
    }

    protected abstract void doCommit(OMMonitor var1);

    public void rollback() {
        if (TRACER.isEnabled()) {
            TRACER.format("Rolling back transaction: {0}", new Object[]{this.getTransaction()});
        }
        for (IStoreAccessor.CommitContext commitContext : this.commitContexts) {
            this.rollback(commitContext);
        }
    }

    protected abstract void rollback(IStoreAccessor.CommitContext var1);

    public final void release() {
        this.store.releaseAccessor(this);
        this.commitContexts.clear();
    }

    protected abstract void addIDMappings(InternalCommitContext var1, OMMonitor var2);

    protected void applyIDMappings(InternalCommitContext context, OMMonitor monitor) {
        context.applyIDMappings(monitor.fork());
    }

    protected abstract void writeCommitInfo(CDOBranch var1, long var2, String var4, String var5, OMMonitor var6);

    protected abstract void writeRevisions(InternalCDORevision[] var1, CDOBranch var2, OMMonitor var3);

    protected abstract void writeRevisionDeltas(InternalCDORevisionDelta[] var1, CDOBranch var2, long var3, OMMonitor var5);

    protected abstract void detachObjects(CDOID[] var1, CDOBranch var2, long var3, OMMonitor var5);

    protected abstract void doActivate() throws Exception;

    protected abstract void doDeactivate() throws Exception;

    protected abstract void doPassivate() throws Exception;

    protected abstract void doUnpassivate() throws Exception;

    public static class CommitDataRevisionHandler
    implements CDORevisionHandler {
        private IStoreAccessor storeAccessor;
        private long timeStamp;
        private InternalCDORevisionManager revisionManager;
        private List<CDOPackageUnit> newPackageUnits = new ArrayList<CDOPackageUnit>();
        private List<CDOIDAndVersion> newObjects = new ArrayList<CDOIDAndVersion>();
        private List<CDORevisionKey> changedObjects = new ArrayList<CDORevisionKey>();
        private List<CDOIDAndVersion> detachedObjects = new ArrayList<CDOIDAndVersion>();

        public CommitDataRevisionHandler(IStoreAccessor storeAccessor, long timeStamp) {
            InternalCDOPackageUnit[] packageUnits;
            this.storeAccessor = storeAccessor;
            this.timeStamp = timeStamp;
            InternalStore store = (InternalStore)storeAccessor.getStore();
            InternalRepository repository = store.getRepository();
            this.revisionManager = repository.getRevisionManager();
            InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits = packageRegistry.getPackageUnits(timeStamp, timeStamp);
            int n = packageUnits.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                if (!packageUnit.isSystem()) {
                    this.newPackageUnits.add((CDOPackageUnit)packageUnit);
                }
                ++n2;
            }
        }

        public CDOCommitData getCommitData() {
            this.storeAccessor.handleRevisions(null, null, this.timeStamp, this);
            return new CDOCommitDataImpl(this.newPackageUnits, this.newObjects, this.changedObjects, this.detachedObjects);
        }

        public void handleRevision(CDORevision rev) {
            if (rev.getTimeStamp() != this.timeStamp) {
                throw new IllegalArgumentException("Invalid revision time stamp: " + CDOCommonUtil.formatTimeStamp((long)rev.getTimeStamp()));
            }
            if (rev instanceof DetachedCDORevision) {
                this.detachedObjects.add((CDOIDAndVersion)rev);
            } else {
                InternalCDORevision revision = (InternalCDORevision)rev;
                CDOID id = revision.getID();
                CDOBranch branch = revision.getBranch();
                int version = revision.getVersion();
                if (version > 1) {
                    CDOBranchVersion oldVersion = branch.getVersion(version - 1);
                    InternalCDORevision oldRevision = this.revisionManager.getRevisionByVersion(id, oldVersion, -1, true);
                    InternalCDORevisionDelta delta = revision.compare((CDORevision)oldRevision);
                    this.changedObjects.add((CDORevisionKey)delta);
                } else {
                    InternalCDORevision oldRevision = this.getRevisionFromBase(id, branch);
                    if (oldRevision != null) {
                        InternalCDORevisionDelta delta = revision.compare((CDORevision)oldRevision);
                        this.changedObjects.add((CDORevisionKey)delta);
                    } else {
                        InternalCDORevision newRevision = revision.copy();
                        newRevision.setRevised(0L);
                        this.newObjects.add((CDOIDAndVersion)newRevision);
                    }
                }
            }
        }

        private InternalCDORevision getRevisionFromBase(CDOID id, CDOBranch branch) {
            if (branch.isMainBranch()) {
                return null;
            }
            CDOBranchPoint base = branch.getBase();
            InternalCDORevision revision = this.revisionManager.getRevision(id, base, -1, 0, true);
            if (revision == null) {
                revision = this.getRevisionFromBase(id, base.getBranch());
            }
            return revision;
        }
    }
}

